/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;

public class TransactFileOutputStream
extends FileOutputStream {
    private static final Logger log = Logger.getLogger(TransactFileOutputStream.class.getName());
    protected File origFile;
    protected final boolean keepOld;

    public TransactFileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public TransactFileOutputStream(File file, boolean bl) throws FileNotFoundException {
        super(TransactFileOutputStream.getOutFile(file));
        this.origFile = file;
        this.keepOld = bl;
    }

    public void close() throws IOException {
        this.flush();
        this.getFD().sync();
        super.close();
        File file = TransactFileOutputStream.getOutFile(this.origFile);
        if (Utils.debugMode) {
            log.fine(file.getPath() + " was closed, renaming to original name (keepOld=" + this.keepOld + ").");
        }
        if (this.keepOld || !file.renameTo(this.origFile)) {
            File file2 = TransactFileOutputStream.getBackupFileName(this.origFile);
            if (file2.exists()) {
                file2.delete();
            }
            if (!this.origFile.exists() || this.origFile.renameTo(file2)) {
                if (file.renameTo(this.origFile) && !this.keepOld) {
                    file2.delete();
                }
            } else {
                throw new IOException("Could not rename " + file + " to " + this.origFile);
            }
        }
        if (Utils.debugMode) {
            log.fine(file.getPath() + " successfully renamed to " + this.origFile.getPath());
        }
    }

    protected static File getOutFile(File file) {
        return new File(file.getPath() + "~new");
    }

    public static File getBackupFileName(File file) {
        return new File(file.getPath() + "~old");
    }

    public static boolean checkRecovery(File file) {
        if (!file.exists() || file.length() == 0L) {
            log.fine(file + " file does not exist or is empty");
            File file2 = TransactFileOutputStream.getBackupFileName(file);
            if (file2.exists() && file2.length() > 0L) {
                try {
                    Utils.copyFile(file2, file);
                }
                catch (IOException iOException) {
                    log.log(Level.WARNING, "Error during recovery", iOException);
                }
                log.severe("Recovered " + file + " from backup file " + file2);
                return true;
            }
            log.info("Backup does not exist or is empty.");
        }
        return false;
    }
}

