/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.anon;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import sun.invoke.anon.AnonymousClassLoader;
import sun.invoke.anon.ConstantPoolPatch;
import sun.invoke.anon.ConstantPoolVisitor;
import sun.invoke.anon.InvalidConstantPoolFormatException;

public class ConstantPoolParser {
    final byte[] classFile;
    final byte[] tags;
    final char[] firstHeader;
    int endOffset;
    char[] secondHeader;
    private char[] charArray = new char[80];

    public ConstantPoolParser(byte[] byArray) throws InvalidConstantPoolFormatException {
        this.classFile = byArray;
        this.firstHeader = ConstantPoolParser.parseHeader(byArray);
        this.tags = new byte[this.firstHeader[4]];
    }

    public ConstantPoolParser(Class<?> clazz) throws IOException, InvalidConstantPoolFormatException {
        this(AnonymousClassLoader.readClassFile(clazz));
    }

    public ConstantPoolPatch createPatch() {
        return new ConstantPoolPatch(this);
    }

    public byte getTag(int n) {
        this.getEndOffset();
        return this.tags[n];
    }

    public int getLength() {
        return this.firstHeader[4];
    }

    public int getStartOffset() {
        return this.firstHeader.length * 2;
    }

    public int getEndOffset() {
        if (this.endOffset == 0) {
            throw new IllegalStateException("class file has not yet been parsed");
        }
        return this.endOffset;
    }

    public int getThisClassIndex() {
        this.getEndOffset();
        return this.secondHeader[1];
    }

    public int getTailLength() {
        return this.classFile.length - this.getEndOffset();
    }

    public void writeHead(OutputStream outputStream) throws IOException {
        outputStream.write(this.classFile, 0, this.getEndOffset());
    }

    void writePatchedHead(OutputStream outputStream, Object[] objectArray) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void writeTail(OutputStream outputStream) throws IOException {
        outputStream.write(this.classFile, this.getEndOffset(), this.getTailLength());
    }

    private static char[] parseHeader(byte[] byArray) throws InvalidConstantPoolFormatException {
        int n;
        char[] cArray = new char[5];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = (char)ConstantPoolParser.getUnsignedShort(byteBuffer);
        }
        n = cArray[0] << 16 | cArray[1] << 0;
        if (n != -889275714) {
            throw new InvalidConstantPoolFormatException("invalid magic number " + n);
        }
        char c = cArray[4];
        if (c < '\u0001') {
            throw new InvalidConstantPoolFormatException("constant pool length < 1");
        }
        return cArray;
    }

    public void parse(ConstantPoolVisitor constantPoolVisitor) throws InvalidConstantPoolFormatException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.classFile);
        byteBuffer.position(this.getStartOffset());
        Object[] objectArray = new Object[this.getLength()];
        try {
            this.parseConstantPool(byteBuffer, objectArray, constantPoolVisitor);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new InvalidConstantPoolFormatException(bufferUnderflowException);
        }
        if (this.endOffset == 0) {
            this.endOffset = byteBuffer.position();
            this.secondHeader = new char[4];
            for (int i = 0; i < this.secondHeader.length; ++i) {
                this.secondHeader[i] = (char)ConstantPoolParser.getUnsignedShort(byteBuffer);
            }
        }
        this.resolveConstantPool(objectArray, constantPoolVisitor);
    }

    private char[] getCharArray(int n) {
        if (n <= this.charArray.length) {
            return this.charArray;
        }
        this.charArray = new char[n];
        return this.charArray;
    }

    private void parseConstantPool(ByteBuffer byteBuffer, Object[] objectArray, ConstantPoolVisitor constantPoolVisitor) throws InvalidConstantPoolFormatException {
        int n = 1;
        block9: while (n < this.tags.length) {
            byte by = (byte)ConstantPoolParser.getUnsignedByte(byteBuffer);
            assert (this.tags[n] == 0 || this.tags[n] == by);
            this.tags[n] = by;
            switch (by) {
                case 1: {
                    int n2 = ConstantPoolParser.getUnsignedShort(byteBuffer);
                    String string = ConstantPoolParser.getUTF8(byteBuffer, n2, this.getCharArray(n2));
                    constantPoolVisitor.visitUTF8(n, (byte)1, string);
                    this.tags[n] = by;
                    objectArray[n++] = string;
                    continue block9;
                }
                case 3: {
                    constantPoolVisitor.visitConstantValue(n, by, byteBuffer.getInt());
                    ++n;
                    continue block9;
                }
                case 4: {
                    constantPoolVisitor.visitConstantValue(n, by, Float.valueOf(byteBuffer.getFloat()));
                    ++n;
                    continue block9;
                }
                case 5: {
                    constantPoolVisitor.visitConstantValue(n, by, byteBuffer.getLong());
                    n += 2;
                    continue block9;
                }
                case 6: {
                    constantPoolVisitor.visitConstantValue(n, by, byteBuffer.getDouble());
                    n += 2;
                    continue block9;
                }
                case 7: 
                case 8: {
                    this.tags[n] = by;
                    objectArray[n++] = new int[]{ConstantPoolParser.getUnsignedShort(byteBuffer)};
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.tags[n] = by;
                    objectArray[n++] = new int[]{ConstantPoolParser.getUnsignedShort(byteBuffer), ConstantPoolParser.getUnsignedShort(byteBuffer)};
                    continue block9;
                }
            }
            throw new AssertionError((Object)("invalid constant " + by));
        }
    }

    private void resolveConstantPool(Object[] objectArray, ConstantPoolVisitor constantPoolVisitor) {
        int n = 1;
        int n2 = objectArray.length - 1;
        while (n <= n2) {
            int n3 = n2;
            int n4 = n - 1;
            block7: for (int i = n; i <= n2; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof int[])) continue;
                int[] nArray = (int[])object;
                byte by = this.tags[i];
                switch (by) {
                    case 8: {
                        String string = (String)objectArray[nArray[0]];
                        constantPoolVisitor.visitConstantString(i, by, string, nArray[0]);
                        objectArray[i] = null;
                        continue block7;
                    }
                    case 7: {
                        Object object2 = (String)objectArray[nArray[0]];
                        object2 = ((String)object2).replace('/', '.');
                        constantPoolVisitor.visitConstantString(i, by, (String)object2, nArray[0]);
                        objectArray[i] = object2;
                        continue block7;
                    }
                    case 12: {
                        Object object2 = (String)objectArray[nArray[0]];
                        Object object3 = (String)objectArray[nArray[1]];
                        constantPoolVisitor.visitDescriptor(i, by, (String)object2, (String)object3, nArray[0], nArray[1]);
                        objectArray[i] = new String[]{object2, object3};
                        continue block7;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        Object object2 = objectArray[nArray[0]];
                        Object object3 = objectArray[nArray[1]];
                        if (!(object2 instanceof String) || !(object3 instanceof String[])) {
                            if (n3 > i) {
                                n3 = i;
                            }
                            if (n4 >= i) continue block7;
                            n4 = i;
                            continue block7;
                        }
                        String[] stringArray = (String[])object3;
                        constantPoolVisitor.visitMemberRef(i, by, (String)object2, stringArray[0], stringArray[1], nArray[0], nArray[1]);
                        objectArray[i] = null;
                        continue block7;
                    }
                    default: {
                        continue block7;
                    }
                }
            }
            n = n3;
            n2 = n4;
        }
    }

    private static int getUnsignedByte(ByteBuffer byteBuffer) {
        return byteBuffer.get() & 0xFF;
    }

    private static int getUnsignedShort(ByteBuffer byteBuffer) {
        int n = ConstantPoolParser.getUnsignedByte(byteBuffer);
        int n2 = ConstantPoolParser.getUnsignedByte(byteBuffer);
        return (n << 8) + (n2 << 0);
    }

    private static String getUTF8(ByteBuffer byteBuffer, int n, char[] cArray) throws InvalidConstantPoolFormatException {
        int n2 = byteBuffer.position() + n;
        int n3 = 0;
        while (byteBuffer.position() < n2) {
            int n4 = byteBuffer.get() & 0xFF;
            if (n4 > 127) {
                byteBuffer.position(byteBuffer.position() - 1);
                return ConstantPoolParser.getUTF8Extended(byteBuffer, n2, cArray, n3);
            }
            cArray[n3++] = (char)n4;
        }
        return new String(cArray, 0, n3);
    }

    private static String getUTF8Extended(ByteBuffer byteBuffer, int n, char[] cArray, int n2) throws InvalidConstantPoolFormatException {
        block5: while (byteBuffer.position() < n) {
            int n3 = byteBuffer.get() & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n2++] = (char)n3;
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte by = byteBuffer.get();
                    if ((by & 0xC0) != 128) {
                        throw new InvalidConstantPoolFormatException("malformed input around byte " + byteBuffer.position());
                    }
                    cArray[n2++] = (char)((n3 & 0x1F) << 6 | by & 0x3F);
                    continue block5;
                }
                case 14: {
                    byte by = byteBuffer.get();
                    byte by2 = byteBuffer.get();
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new InvalidConstantPoolFormatException("malformed input around byte " + byteBuffer.position());
                    }
                    cArray[n2++] = (char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new InvalidConstantPoolFormatException("malformed input around byte " + byteBuffer.position());
        }
        return new String(cArray, 0, n2);
    }
}

