/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax;

import gnu.hylafax.ClientProtocol;
import gnu.inet.ftp.FtpClientProtocol;
import gnu.inet.ftp.ServerResponseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HylaFAXClientProtocol
extends FtpClientProtocol
implements ClientProtocol {
    public static int DEFAULT_PORT = 4559;
    private static final Log log = LogFactory.getLog(ClientProtocol.class);
    public static final String TZONE_GMT = "GMT";
    public static final String TZONE_LOCAL = "LOCAL";
    protected String hylafaxServerTimeZone = null;
    protected String version = null;

    public synchronized void admin(String password) throws IOException, ServerResponseException {
        this.ostream.write("admin " + password + "\r\n");
        this.ostream.flush();
        log.debug("-> admin " + password);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("230")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void answer(String modem) throws IOException, ServerResponseException {
        this.ostream.write("answer " + modem + "\r\n");
        this.ostream.flush();
        log.debug("-> answer " + modem);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void config(String parm, int value) throws IOException, ServerResponseException {
        this.config(parm, Integer.toString(value));
    }

    public void config(String parm, long value) throws IOException, ServerResponseException {
        this.config(parm, Long.toString(value));
    }

    public synchronized void config(String parm, Object value) throws IOException, ServerResponseException {
        this.config(parm, value.toString());
    }

    public synchronized void config(String parm, String value) throws IOException, ServerResponseException {
        String cmd = "site config " + parm + " " + value + "\r\n";
        this.ostream.write(cmd);
        this.ostream.flush();
        log.debug("-> " + cmd);
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String return_code = st.nextToken();
        if (!return_code.equals("213") && !return_code.equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized String filefmt() throws IOException, ServerResponseException {
        this.ostream.write("filefmt\r\n");
        this.ostream.flush();
        log.debug("-> filefmt");
        String response = this.istream.readLine();
        log.debug(response);
        if (!response.substring(0, 3).equals("200")) {
            throw new ServerResponseException(response);
        }
        return response.substring(3);
    }

    public synchronized void filefmt(String value) throws IOException, ServerResponseException {
        this.ostream.write("filefmt \"" + value + "\"\r\n");
        this.ostream.flush();
        log.debug("-> filefmt \"" + value + "\"");
        String response = this.istream.readLine();
        log.debug(response);
        if (!response.substring(0, 3).equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void form(String value) throws IOException, ServerResponseException {
        this.ostream.write("form \"" + value + "\"\r\n");
        this.ostream.flush();
        log.debug("-> form " + value);
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public String getServerVersion() {
        if (this.version == null) {
            try {
                String tmp = this.getGreeting();
                if (tmp == null || tmp.equals("")) {
                    this.version = null;
                } else if (tmp.startsWith("220")) {
                    this.version = tmp.substring(tmp.indexOf("(") + 1, tmp.lastIndexOf(")"));
                }
            }
            catch (Exception e) {
                this.version = null;
                log.error("Cannot parse version from greeting", e);
            }
        }
        return this.version;
    }

    public synchronized long idle() throws IOException, ServerResponseException {
        this.ostream.write("idle\r\n");
        this.ostream.flush();
        log.debug("-> idle");
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("213")) {
            throw new ServerResponseException(response);
        }
        Long l = new Long(st.nextToken());
        return l;
    }

    public synchronized void idle(long timeout) throws IOException, ServerResponseException {
        this.ostream.write("idle " + timeout + "\r\n");
        this.ostream.flush();
        log.debug("-> idle " + timeout);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("213")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void jdele(long jobid) throws IOException, ServerResponseException {
        this.ostream.write("jdele " + jobid + "\r\n");
        this.ostream.flush();
        log.debug("-> jdele " + jobid);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void jintr(long jobid) throws IOException, ServerResponseException {
        this.ostream.write("jintr " + jobid + "\r\n");
        this.ostream.flush();
        log.debug("-> jintr " + jobid);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void jkill(long jobid) throws IOException, ServerResponseException {
        this.ostream.write("jkill " + jobid + "\r\n");
        this.ostream.flush();
        log.debug("-> jkill " + jobid);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void jnew() throws IOException, ServerResponseException {
        this.jnew(true);
    }

    public synchronized void jnew(boolean inheritDefault) throws IOException, ServerResponseException {
        if (inheritDefault) {
            this.job(0L);
        }
        this.ostream.write("jnew\r\n");
        this.ostream.flush();
        log.debug("-> jnew");
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized long job() throws IOException, ServerResponseException {
        this.ostream.write("job\r\n");
        this.ostream.flush();
        log.debug("-> job");
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
        st.nextToken();
        st.nextToken();
        st.nextToken();
        try {
            Long l = new Long(st.nextToken());
            return l;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public synchronized void job(long val) throws IOException, ServerResponseException {
        String value = val <= 0L ? "default" : String.valueOf(val);
        this.ostream.write("job " + value + "\r\n");
        this.ostream.flush();
        log.debug("-> job " + value);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized String jobfmt() throws IOException, ServerResponseException {
        this.ostream.write("jobfmt\r\n");
        this.ostream.flush();
        log.debug("-> jobfmt");
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String temp = new String(st.nextToken());
        if (!temp.equals("200")) {
            throw new ServerResponseException(response);
        }
        return response.substring(temp.length());
    }

    public synchronized void jobfmt(String value) throws IOException, ServerResponseException {
        String command = new String("jobfmt \"" + value + "\"\r\n");
        this.ostream.write(command);
        this.ostream.flush();
        log.debug("-> jobfmt " + value);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized List jparm() throws IOException, ServerResponseException {
        if (log.isDebugEnabled()) {
            log.debug("jparm");
        }
        this.ostream.write("jparm\r\n");
        this.ostream.flush();
        String response = this.istream.readLine();
        log.debug(response);
        if (response.startsWith("217")) {
            ArrayList<String> res = new ArrayList<String>();
            while (true) {
                response = this.istream.readLine();
                log.debug(response);
                if (!response.startsWith("    ")) break;
                res.add(response.substring(4));
            }
            if (response.startsWith("217")) {
                return res;
            }
        }
        throw new ServerResponseException(response);
    }

    public synchronized String jparm(String parm) throws IOException, ServerResponseException {
        if (log.isDebugEnabled()) {
            log.debug("jparam " + parm);
        }
        this.ostream.write("jparm " + parm + "\r\n");
        this.ostream.flush();
        String response = this.istream.readLine();
        if (response.startsWith("213")) {
            String res = response.substring(4);
            while (response.charAt(3) == '-') {
                response = this.istream.readLine();
                if (!response.startsWith("213")) {
                    throw new ServerResponseException(response);
                }
                res = res + "\n" + response.substring(4);
            }
            return res;
        }
        throw new ServerResponseException(response);
    }

    public synchronized void jparm(String parm, int value) throws IOException, ServerResponseException {
        this.jparm(parm, Integer.toString(value));
    }

    public synchronized void jparm(String parm, long value) throws IOException, ServerResponseException {
        this.jparm(parm, Long.toString(value));
    }

    public synchronized void jparm(String parm, Object value) throws IOException, ServerResponseException {
        this.jparm(parm, value.toString());
    }

    public synchronized void jparm(String parm, String value) throws IOException, ServerResponseException {
        this.ostream.write("jparm " + parm + " " + value + "\r\n");
        this.ostream.flush();
        log.debug("-> jparm " + parm + " " + value);
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String return_code = st.nextToken();
        if (!return_code.equals("213") && !return_code.equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void jrest() throws IOException, ServerResponseException {
        this.ostream.write("jrest\r\n");
        this.ostream.flush();
        log.debug("-> jrest");
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized long jsubm() throws IOException, ServerResponseException {
        this.ostream.write("jsubm\r\n");
        this.ostream.flush();
        log.debug("-> jsubm");
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
        st.nextToken();
        return Long.parseLong(st.nextToken());
    }

    public synchronized int jsubm(long jobid) throws IOException, ServerResponseException {
        this.ostream.write("jsubm " + jobid + "\r\n");
        this.ostream.flush();
        log.debug("-> jsubm " + jobid);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        int jobID = 0;
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
        try {
            st.nextToken();
            String jobStr = st.nextToken();
            jobID = Integer.parseInt(jobStr);
        }
        catch (NumberFormatException nfe) {
            throw new ServerResponseException("Bad number format for job id");
        }
        catch (NoSuchElementException nsee) {
            new ServerResponseException("Mangled server response to job submit");
        }
        return jobID;
    }

    public synchronized void jsusp(long jobid) throws IOException, ServerResponseException {
        this.ostream.write("jsusp " + jobid + "\r\n");
        this.ostream.flush();
        log.debug("-> jsusp " + jobid);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void jwait(long jobid) throws IOException, ServerResponseException {
        this.ostream.write("jwait " + jobid + "\r\n");
        this.ostream.flush();
        log.debug("-> jwait " + jobid);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response, " -");
        if (!st.nextToken().equals("216")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized String mdmfmt() throws IOException, ServerResponseException {
        this.ostream.write("mdmfmt\r\n");
        this.ostream.flush();
        log.debug("-> mdmfmt");
        String response = this.istream.readLine();
        log.debug(response);
        if (!response.substring(0, 3).equals("200")) {
            throw new ServerResponseException(response);
        }
        return response.substring(3);
    }

    public synchronized void mdmfmt(String value) throws IOException, ServerResponseException {
        this.ostream.write("mdmfmt \"" + value + "\"\r\n");
        this.ostream.flush();
        log.debug("-> mdmfmt " + value);
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void open() throws UnknownHostException, IOException, ServerResponseException {
        this.open("localhost");
    }

    public synchronized void open(String host) throws UnknownHostException, IOException, ServerResponseException {
        this.open(host, DEFAULT_PORT);
    }

    public synchronized void open(String host, int p) throws UnknownHostException, IOException, ServerResponseException {
        this.connect(host, p);
        log.debug("Connected to: " + this.getServerVersion());
    }

    public synchronized String rcvfmt() throws IOException, ServerResponseException {
        this.ostream.write("rcvfmt\r\n");
        this.ostream.flush();
        log.debug("-> rcvfmt");
        String response = this.istream.readLine();
        log.debug(response);
        if (!response.substring(0, 3).equals("200")) {
            throw new ServerResponseException(response);
        }
        return response.substring(3);
    }

    public synchronized void rcvfmt(String value) throws IOException, ServerResponseException {
        this.ostream.write("rcvfmt \"" + value + "\"\r\n");
        this.ostream.flush();
        log.debug("-> rcvfmt \"" + value + "\"\n");
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void site(String parm, int value) throws IOException, ServerResponseException {
        this.site(parm, Integer.toString(value));
    }

    public synchronized void site(String parm, long value) throws IOException, ServerResponseException {
        this.site(parm, Long.toString(value));
    }

    public synchronized void site(String parm, Object value) throws IOException, ServerResponseException {
        this.site(parm, value.toString());
    }

    public synchronized void site(String parm, String value) throws IOException, ServerResponseException {
        this.ostream.write("site " + parm + " " + value + "\r\n");
        this.ostream.flush();
        log.debug("-> site " + parm + " " + value);
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String return_code = st.nextToken();
        if (!(return_code.equals("213") || return_code.equals("200") || return_code.equals("150"))) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized long size(String pathname) throws IOException, FileNotFoundException, ServerResponseException {
        this.ostream.write("size " + pathname + "\r\n");
        this.ostream.flush();
        log.debug("-> size " + pathname);
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String return_code = st.nextToken();
        if (!return_code.equals("213")) {
            if (return_code.equals("550")) {
                throw new FileNotFoundException(response);
            }
            throw new ServerResponseException(response);
        }
        return Long.parseLong(st.nextToken());
    }

    public synchronized String stot(InputStream data) throws IOException, ServerResponseException {
        this.ostream.write("stot\r\n");
        this.ostream.flush();
        log.debug("-> stot");
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("150")) {
            throw new ServerResponseException(response);
        }
        st.nextToken();
        String filename = new String(st.nextToken());
        response = this.istream.readLine();
        log.debug(response);
        st = new StringTokenizer(response);
        if (!st.nextToken().equals("226")) {
            throw new ServerResponseException(response);
        }
        return filename;
    }

    public synchronized void tzone(String value) throws IOException, ServerResponseException {
        this.hylafaxServerTimeZone = value;
        this.ostream.write("tzone " + value + "\r\n");
        this.ostream.flush();
        log.debug("-> tzone " + value);
        String response = new String(this.istream.readLine());
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized InetAddress vrfy(String dialstring) throws IOException, ServerResponseException {
        this.ostream.write("vrfy " + dialstring + "\r\n");
        this.ostream.flush();
        log.debug("-> vrfy " + dialstring);
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
        return InetAddress.getByName(st.nextToken());
    }
}

