/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.job;

import gnu.hylafax.Client;
import gnu.hylafax.job.TimeParser;
import gnu.inet.ftp.ServerResponseException;
import java.awt.Dimension;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Job
implements gnu.hylafax.Job {
    public static String CHOP_DEFAULT = "default";
    public static String NOTIFY_ALL = "DONE+REQUEUE";
    public static String NOTIFY_DONE = "DONE";
    public static String NOTIFY_NONE = "NONE";
    public static String NOTIFY_REQUEUE = "REQUEUE";
    public static int PRIORITY_BULK = 207;
    public static int PRIORITY_HIGH = 63;
    public static int PRIORITY_NORMAL = 127;
    public static int RESOLUTION_LOW = 98;
    public static int RESOLUTION_MEDIUM = 196;
    protected Client client;
    private long Id;

    public Job(Client c) throws ServerResponseException, IOException {
        this(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job(Client c, boolean inheritDefault) throws ServerResponseException, IOException {
        Client client = c;
        synchronized (client) {
            this.client = c;
            this.client.jnew(inheritDefault);
            this.Id = this.client.job();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job(Client c, long id) throws ServerResponseException, IOException {
        Client client = c;
        synchronized (client) {
            this.client = c;
            this.client.job(id);
            this.Id = this.client.job();
        }
    }

    public void addDocument(String value) throws ServerResponseException, IOException {
        this.setProperty("DOCUMENT", value);
    }

    public int getChopThreshold() throws ServerResponseException, IOException {
        return Integer.parseInt(this.getProperty("CHOPTHRESHOLD"));
    }

    public String getDialstring() throws ServerResponseException, IOException {
        return this.getProperty("DIALSTRING");
    }

    public String getDocumentName() throws ServerResponseException, IOException {
        return this.getProperty("DOCUMENT");
    }

    public String getFromUser() throws ServerResponseException, IOException {
        return this.getProperty("FROMUSER");
    }

    public long getId() {
        return this.Id;
    }

    public String getJobInfo() throws ServerResponseException, IOException {
        return this.getProperty("JOBINFO");
    }

    public String getKilltime() throws ServerResponseException, IOException {
        return this.getProperty("LASTTIME");
    }

    public int getMaximumDials() throws ServerResponseException, IOException {
        return Integer.parseInt(this.getProperty("MAXDIALS"));
    }

    public int getMaximumTries() throws ServerResponseException, IOException {
        return Integer.parseInt(this.getProperty("MAXTRIES"));
    }

    public String getNotifyAddress() throws ServerResponseException, IOException {
        return this.getProperty("NOTIFYADDR");
    }

    public String getNotifyType() throws ServerResponseException, IOException {
        return this.getProperty("NOTIFY");
    }

    public String getPageChop() throws ServerResponseException, IOException {
        return this.getProperty("PAGECHOP");
    }

    public Dimension getPageDimension() throws ServerResponseException, IOException {
        return new Dimension(this.getPageWidth(), this.getPageLength());
    }

    public int getPageLength() throws ServerResponseException, IOException {
        return Integer.parseInt(this.getProperty("PAGELENGTH"));
    }

    public int getPageWidth() throws ServerResponseException, IOException {
        return Integer.parseInt(this.getProperty("PAGEWIDTH"));
    }

    public int getPriority() throws ServerResponseException, IOException {
        return Integer.parseInt(this.getProperty("SCHEDPRI"));
    }

    public String getProperty(String key) throws ServerResponseException, IOException {
        String tmp = this.client.jparm(key);
        return tmp;
    }

    public String getRetrytime() throws ServerResponseException, IOException {
        return this.getProperty("RETRYTIME");
    }

    public String getTagline() throws ServerResponseException, IOException {
        return this.getProperty("TAGLINE");
    }

    public boolean getUseTagline() throws ServerResponseException, IOException {
        return "YES".equalsIgnoreCase(this.getProperty("USETAGLINE"));
    }

    public int getVerticalResolution() throws ServerResponseException, IOException {
        return Integer.parseInt(this.getProperty("VRES"));
    }

    public void setChopThreshold(int value) throws ServerResponseException, IOException {
        this.setProperty("CHOPTHRESHOLD", value);
    }

    public void setDialstring(String value) throws ServerResponseException, IOException {
        this.setProperty("DIALSTRING", value);
    }

    public void setFromUser(String value) throws ServerResponseException, IOException {
        this.setProperty("FROMUSER", value);
    }

    public void setJobInfo(String value) throws ServerResponseException, IOException {
        this.setProperty("JOBINFO", value);
    }

    public void setKilltime(String value) throws ServerResponseException, IOException {
        String time;
        try {
            time = new TimeParser().getKillTime(value);
        }
        catch (TimeParser.ParseException e) {
            time = value;
        }
        this.setProperty("LASTTIME", time);
    }

    public void setMaximumDials(int value) throws ServerResponseException, IOException {
        this.setProperty("MAXDIALS", value);
    }

    public void setMaximumTries(int value) throws ServerResponseException, IOException {
        this.setProperty("MAXTRIES", value);
    }

    public void setNotifyAddress(String value) throws ServerResponseException, IOException {
        this.setProperty("NOTIFYADDR", value);
    }

    public void setNotifyType(String value) throws ServerResponseException, IOException {
        this.setProperty("NOTIFY", value);
    }

    public void setPageChop(String value) throws ServerResponseException, IOException {
        this.setProperty("PAGECHOP", value);
    }

    public void setPageDimension(Dimension value) throws ServerResponseException, IOException {
        this.setPageWidth((int)value.getWidth());
        this.setPageLength((int)value.getHeight());
    }

    public void setPageLength(int length) throws ServerResponseException, IOException {
        this.setProperty("PAGELENGTH", length);
    }

    public void setPageWidth(int width) throws ServerResponseException, IOException {
        this.setProperty("PAGEWIDTH", width);
    }

    public void setPriority(int value) throws ServerResponseException, IOException {
        this.setProperty("SCHEDPRI", value);
    }

    public void setProperty(String property, int value) throws ServerResponseException, IOException {
        this.setProperty(property, new Integer(value).toString());
    }

    public void setProperty(String parameter, String value) throws ServerResponseException, IOException {
        this.client.jparm(parameter, value);
    }

    public void setRetrytime(String value) throws ServerResponseException, IOException {
        this.setProperty("RETRYTIME", value);
    }

    public void setSendTime(Date sendTime) throws ServerResponseException, IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setProperty("SENDTIME", df.format(sendTime));
    }

    public void setSendTime(String sendTime) throws ServerResponseException, IOException {
        this.setSendTime(sendTime, Locale.getDefault(), TimeZone.getDefault());
    }

    public void setSendTime(String sendTime, Locale locale, TimeZone timeZone) throws ServerResponseException, IOException {
        String time;
        try {
            time = new TimeParser(locale, timeZone).getSendTime(sendTime);
        }
        catch (TimeParser.ParseException e) {
            time = sendTime;
        }
        this.setProperty("SENDTIME", time);
    }

    public void setTagline(String value) throws ServerResponseException, IOException {
        this.setProperty("TAGLINE", value);
    }

    public void setUseTagline(boolean value) throws ServerResponseException, IOException {
        this.setProperty("USETAGLINE", value ? "YES" : "NO");
    }

    public void setVerticalResolution(int value) throws ServerResponseException, IOException {
        this.setProperty("VRES", value);
    }
}

