/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AsciiOutputStream
extends FilterOutputStream {
    protected boolean active;
    protected int eol;

    public AsciiOutputStream(OutputStream out) throws Exception {
        super(out);
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator.equals("\r\n")) {
            this.active = false;
        } else {
            if (lineSeparator.length() > 1) {
                throw new Exception("System line separator longer than 1 char");
            }
            this.active = true;
            this.eol = lineSeparator.charAt(0);
        }
    }

    public void write(int b) throws IOException {
        if (this.active && b == this.eol) {
            this.out.write(13);
            this.out.write(10);
        } else {
            this.out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(b[i]);
        }
    }
}

