/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.PassiveParameters;
import gnu.inet.ftp.ServerResponseException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FtpClientProtocol {
    private static final Log log = LogFactory.getLog(FtpClientProtocol.class);
    protected Socket sock;
    protected int port;
    protected BufferedReader istream;
    protected OutputStreamWriter ostream;
    protected String greeting;
    protected char fileType;
    protected int socketTimeout = 10000;
    protected String hylafaxServerHost = null;
    protected int hylafaxServerPort = -1;
    protected String hylafaxServerUsername = null;
    protected String characterEncoding = System.getProperty("file.encoding");
    public static int DEFAULT_PORT = 21;
    public static final char TYPE_ASCII = 'A';
    public static final char TYPE_EBCDIC = 'E';
    public static final char TYPE_IMAGE = 'I';
    public static final char TYPE_LOCAL = 'L';
    public static final char MODE_STREAM = 'S';
    public static final char MODE_BLOCK = 'B';
    public static final char MODE_COMPRESSED = 'C';
    public static final char MODE_ZLIB = 'Z';
    public static final char STRU_FILE = 'F';
    public static final char STRU_RECORD = 'R';
    public static final char STRU_PAGE = 'P';
    public static final char STRU_TIFF = 'T';
    public static final String MDTM_TIME_FORMAT1 = "yyyyMMddHHmmss.SSS";
    public static final String MDTM_TIME_FORMAT2 = "yyyyMMddHHmmss";
    static final Pattern responsePattern = Pattern.compile("(\\d{3})(.)\\s*(.*)");
    private static final int IPV4_LENGTH = 4;
    private static final int IPV4_MAX = 255;

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public FtpClientProtocol() {
        this.fileType = (char)65;
    }

    public synchronized InetAddress getInetAddress() {
        return this.sock.getLocalAddress();
    }

    public synchronized void open(String host, int portnumber) throws UnknownHostException, IOException, ServerResponseException {
        this.connect(host, portnumber);
    }

    public synchronized void open(String host) throws UnknownHostException, IOException, ServerResponseException {
        this.connect(host, DEFAULT_PORT);
    }

    public synchronized void open() throws UnknownHostException, IOException, ServerResponseException {
        this.connect("localhost", DEFAULT_PORT);
    }

    public synchronized boolean user(String username) throws IOException, ServerResponseException {
        this.hylafaxServerUsername = username;
        this.ostream.write("user " + username + "\r\n");
        this.ostream.flush();
        log.debug("-> user " + username);
        String response = this.readResponse(this.istream);
        log.debug(response);
        String temp = new String(response.substring(0, 3));
        if (temp.equals("230")) {
            return false;
        }
        if (temp.equals("331")) {
            return true;
        }
        throw new ServerResponseException(response);
    }

    public synchronized void pass(String password) throws IOException, ServerResponseException {
        this.ostream.write("pass " + password + "\r\n");
        this.ostream.flush();
        log.debug("-> pass");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response, " -");
        if (!st.nextToken().equals("230")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void noop() throws IOException, ServerResponseException {
        this.ostream.write("noop\r\n");
        this.ostream.flush();
        log.debug("-> noop");
        String response = this.readResponse(this.istream);
        log.debug(response);
        String temp = new String(response.substring(0, 3));
        if (!temp.equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized String pwd() throws IOException, ServerResponseException {
        this.ostream.write("pwd\r\n");
        this.ostream.flush();
        log.debug("-> pwd");
        String response = this.readResponse(this.istream);
        log.debug(response);
        String temp = new String(response.substring(0, 3));
        if (!temp.equals("257")) {
            throw new ServerResponseException(response);
        }
        StringTokenizer st = new StringTokenizer(response, "\"");
        st.nextToken();
        return st.nextToken();
    }

    public synchronized void cwd(String value) throws IOException, ServerResponseException {
        this.ostream.write("cwd " + value + "\r\n");
        this.ostream.flush();
        log.debug("-> cwd " + value);
        String response = this.readResponse(this.istream);
        log.debug(response);
        String temp = response.substring(0, 3);
        if (!"250".equals(temp)) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void cdup() throws IOException, ServerResponseException {
        this.ostream.write("cdup\r\n");
        this.ostream.flush();
        log.debug("-> cdup");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("250")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized long idle() throws IOException, ServerResponseException {
        this.ostream.write("idle\r\n");
        this.ostream.flush();
        log.debug("-> idle");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("213")) {
            throw new ServerResponseException(response);
        }
        Long l = new Long(st.nextToken());
        return l;
    }

    public synchronized void idle(long timeout) throws IOException, ServerResponseException {
        this.ostream.write("idle " + timeout + "\r\n");
        this.ostream.flush();
        log.debug("-> idle " + timeout);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("213")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void dele(String pathname) throws IOException, ServerResponseException {
        this.ostream.write("dele " + pathname + "\r\n");
        this.ostream.flush();
        log.debug("-> dele " + pathname);
        String response = this.readResponse(this.istream);
        log.debug(response);
        if (!response.substring(0, 3).equals("250")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void type(char value) throws IOException, ServerResponseException {
        this.ostream.write("type " + value + "\r\n");
        this.ostream.flush();
        log.debug("-> type " + value);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
        this.fileType = value;
    }

    public char getType() {
        return this.fileType;
    }

    public synchronized void mode(char value) throws IOException, ServerResponseException {
        this.ostream.write("mode " + value + "\r\n");
        this.ostream.flush();
        log.debug("-> mode " + value);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void abor() throws IOException, ServerResponseException {
        this.ostream.write("abor\r\n");
        this.ostream.flush();
        log.debug("-> abor");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("225")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void abor(String modem) throws IOException, ServerResponseException {
        this.ostream.write("abor " + modem + "\r\n");
        this.ostream.flush();
        log.debug("-> abor " + modem);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("225")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void port(InetAddress address, int newPort) throws IOException, ServerResponseException {
        String addr = address.getHostAddress();
        addr = addr.replace('.', ',');
        String str = new String("port " + addr + "," + ((newPort & 0xFF00) >> 8) + "," + (newPort & 0xFF));
        this.ostream.write(str + "\r\n");
        this.ostream.flush();
        log.debug("-> " + str + " (" + addr.replace(',', '.') + ":" + newPort + ")");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized String stot(InputStream data) throws IOException, ServerResponseException {
        this.ostream.write("stot\r\n");
        this.ostream.flush();
        log.debug("-> stot");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("150")) {
            throw new ServerResponseException(response);
        }
        st.nextToken();
        String filename = new String(st.nextToken());
        response = this.readResponse(this.istream);
        log.debug(response);
        st = new StringTokenizer(response);
        if (!st.nextToken().equals("226")) {
            throw new ServerResponseException(response);
        }
        return filename;
    }

    public synchronized String stou(InputStream in) throws IOException, ServerResponseException {
        this.ostream.write("stou\r\n");
        this.ostream.flush();
        log.debug("-> stou");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("150")) {
            throw new ServerResponseException(response);
        }
        st.nextToken();
        String filename = new String(st.nextToken());
        response = this.readResponse(this.istream);
        log.debug(response);
        st = new StringTokenizer(response);
        if (!st.nextToken().equals("226")) {
            throw new ServerResponseException(response);
        }
        return filename;
    }

    public synchronized void stor(InputStream in, String pathname) throws IOException, ServerResponseException {
        this.ostream.write("stor " + pathname + "\r\n");
        this.ostream.flush();
        log.debug("-> stor " + pathname);
        String response = this.readResponse(this.istream);
        log.debug(response);
        if (!response.substring(0, 3).equals("150")) {
            throw new ServerResponseException(response);
        }
        response = this.readResponse(this.istream);
        log.debug(response);
        if (!response.substring(0, 3).equals("226")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized String syst() throws IOException, ServerResponseException {
        this.ostream.write("syst\r\n");
        this.ostream.flush();
        log.debug("-> syst");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("215")) {
            throw new ServerResponseException(response);
        }
        return response.substring(4);
    }

    public synchronized void stru(char value) throws IOException, ServerResponseException {
        this.ostream.write("stru " + value + "\r\n");
        this.ostream.flush();
        log.debug("-> stru " + value);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("200")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void list(String path) throws IOException, FileNotFoundException, ServerResponseException {
        String command = path == null ? "list" : "list " + path;
        this.ostream.write(command + "\r\n");
        this.ostream.flush();
        log.debug("-> " + command);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        try {
            String result_code = st.nextToken();
            if (!result_code.equals("150")) {
                if (result_code.equals("550")) {
                    throw new FileNotFoundException(response);
                }
                throw new ServerResponseException(response);
            }
            response = this.readResponse(this.istream);
            log.debug(response);
            st = new StringTokenizer(response);
            if (!st.nextToken().equals("226")) {
                throw new ServerResponseException(response);
            }
        }
        catch (NoSuchElementException e) {
            throw new ServerResponseException("No code found in response: \"" + response + "\"", e);
        }
    }

    public synchronized void list() throws IOException, FileNotFoundException, ServerResponseException {
        this.list(null);
    }

    public synchronized void nlst(String path) throws IOException, ServerResponseException, FileNotFoundException {
        String command = path == null ? "nlst" : "nlst " + path;
        this.ostream.write(command + "\r\n");
        this.ostream.flush();
        log.debug("-> " + command);
        String response = this.readResponse(this.istream);
        log.debug(response);
        String result_code = response.substring(0, 3);
        if (!"150".equals(result_code)) {
            if ("550".equals(result_code)) {
                throw new FileNotFoundException(response);
            }
            throw new ServerResponseException(response);
        }
        response = this.readResponse(this.istream);
        log.debug(response);
        result_code = response.substring(0, 3);
        if (!"226".equals(result_code)) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized void nlst() throws IOException, FileNotFoundException, ServerResponseException {
        this.nlst(null);
    }

    public synchronized void retr(String path) throws IOException, FileNotFoundException, ServerResponseException {
        this.ostream.write("retr " + path + "\r\n");
        this.ostream.flush();
        log.debug("-> retr " + path);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String code = st.nextToken();
        if (!code.equals("150")) {
            if (code.equals("550")) {
                throw new FileNotFoundException(response);
            }
            throw new ServerResponseException(response);
        }
        response = this.readResponse(this.istream);
        log.debug(response);
        st = new StringTokenizer(response);
        if (!st.nextToken().equals("226")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized long size(String pathname) throws IOException, FileNotFoundException, ServerResponseException {
        this.ostream.write("size " + pathname + "\r\n");
        this.ostream.flush();
        log.debug("-> size " + pathname);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String return_code = st.nextToken();
        if (!return_code.equals("213")) {
            if (return_code.equals("550")) {
                throw new FileNotFoundException(response);
            }
            throw new ServerResponseException(response);
        }
        return Long.parseLong(st.nextToken());
    }

    public synchronized Date mdtm(String pathname) throws IOException, FileNotFoundException, ServerResponseException, ParseException {
        this.ostream.write("mdtm " + pathname + "\r\n");
        this.ostream.flush();
        log.debug("-> mdtm " + pathname);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String return_code = st.nextToken();
        if (!return_code.equals("213")) {
            if (return_code.equals("550")) {
                throw new FileNotFoundException(response);
            }
            throw new ServerResponseException(response);
        }
        String time = st.nextToken();
        SimpleDateFormat sdf = time.indexOf(46) == -1 ? new SimpleDateFormat(MDTM_TIME_FORMAT2) : new SimpleDateFormat(MDTM_TIME_FORMAT1);
        TimeZone tz = TimeZone.getTimeZone("GMT");
        Calendar c = sdf.getCalendar();
        c.setTimeZone(tz);
        sdf.setCalendar(c);
        Date d = sdf.parse(time);
        return d;
    }

    public synchronized void rnfr(String pathname) throws IOException, FileNotFoundException, ServerResponseException {
        this.ostream.write("rnfr " + pathname + "\r\n");
        this.ostream.flush();
        log.debug("-> rnfr " + pathname);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String return_code = st.nextToken();
        if (!return_code.equals("350")) {
            if (return_code.equals("550")) {
                throw new FileNotFoundException(response);
            }
            throw new ServerResponseException(response);
        }
    }

    public synchronized void rnto(String pathname) throws IOException, ServerResponseException {
        this.ostream.write("rnto " + pathname + "\r\n");
        this.ostream.flush();
        log.debug("-> rnto " + pathname);
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        String return_code = st.nextToken();
        if (!return_code.equals("250")) {
            throw new ServerResponseException(response);
        }
    }

    public synchronized Vector stat(String path) throws IOException, FileNotFoundException, ServerResponseException {
        String command = path == null ? "stat\r\n" : "stat " + path + "\r\n";
        this.ostream.write(command);
        this.ostream.flush();
        log.debug("-> " + command);
        String response = this.istream.readLine();
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response, "- ");
        String return_code = st.nextToken();
        String remainder = response.substring(4);
        if (return_code.equals("550")) {
            throw new FileNotFoundException(remainder);
        }
        if (!return_code.equals("211")) {
            if (response.charAt(3) == '-') {
                boolean done = false;
                while (!done) {
                    String first_token;
                    response = this.istream.readLine();
                    if (response == null) {
                        done = true;
                        continue;
                    }
                    log.debug(response);
                    remainder = remainder + "\n" + response;
                    Matcher m = responsePattern.matcher(response);
                    if (!m.matches() || !return_code.equals(first_token = m.group(1))) continue;
                    done = true;
                }
            }
            throw new ServerResponseException(remainder);
        }
        Vector<String> status = new Vector<String>();
        if (response.charAt(3) == '-') {
            boolean done = false;
            while (!done) {
                response = this.istream.readLine();
                if (response == null) {
                    done = true;
                    continue;
                }
                log.debug(response);
                Matcher m = responsePattern.matcher(response);
                if (m.matches()) {
                    String first_token = m.group(1);
                    if (return_code.equals(first_token)) {
                        done = true;
                        continue;
                    }
                    status.addElement(response);
                    continue;
                }
                status.addElement(response);
            }
        }
        return status;
    }

    public synchronized Vector stat() throws IOException, ServerResponseException {
        return this.stat(null);
    }

    public synchronized PassiveParameters pasv() throws IOException, ServerResponseException {
        this.ostream.write("pasv\r\n");
        this.ostream.flush();
        log.debug("-> pasv");
        String response = this.readResponse(this.istream);
        log.debug(response);
        StringTokenizer st = new StringTokenizer(response);
        if (!st.nextToken().equals("227")) {
            throw new ServerResponseException(response);
        }
        st.nextToken("(,)");
        String addr = new String(st.nextToken());
        addr = addr + "." + st.nextToken();
        addr = addr + "." + st.nextToken();
        addr = addr + "." + st.nextToken();
        int p = Integer.parseInt(st.nextToken()) << 8 & 0xFF00 | Integer.parseInt(st.nextToken()) & 0xFF;
        return new PassiveParameters(addr, p);
    }

    public synchronized void quit() throws IOException, ServerResponseException {
        try {
            this.ostream.write("quit\r\n");
            this.ostream.flush();
            log.debug("-> quit");
            String response = this.readResponse(this.istream);
            log.debug(response);
            String temp = new String(response.substring(0, 3));
            if (!temp.equals("221")) {
                throw new ServerResponseException(response);
            }
        }
        finally {
            if (this.sock != null && !this.sock.isClosed()) {
                try {
                    log.debug("Setting socket to 0 lingering");
                    this.sock.setSoLinger(true, 0);
                    this.sock.close();
                }
                catch (SocketException socketException) {}
            }
        }
    }

    public String getGreeting() {
        return this.greeting;
    }

    protected synchronized String readResponse(BufferedReader input) throws IOException {
        String rc = "";
        String response = "";
        boolean done = false;
        boolean first = true;
        String tmp = null;
        while (!done && (tmp = input.readLine()) != null) {
            if (tmp.length() <= 0) continue;
            response = response + tmp + '\n';
            if (tmp.length() < 4) continue;
            if (first) {
                rc = response.substring(0, 3);
                first = false;
            }
            if (!rc.equals(tmp.substring(0, 3)) || tmp.charAt(3) != ' ') continue;
            done = true;
        }
        return response;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public static final InetAddress parseIPv4Address(String address) {
        try {
            String[] parts = address.split("\\.");
            if (parts.length == 4) {
                try {
                    byte[] bytes = new byte[4];
                    for (int i = 0; i < 4; ++i) {
                        int part = Integer.parseInt(parts[i]);
                        if (part < 0 || part > 255) {
                            throw new NumberFormatException("Invalid part: " + part);
                        }
                        bytes[i] = (byte)part;
                    }
                    return InetAddress.getByAddress(bytes);
                }
                catch (NumberFormatException e) {
                    log.debug("Not an IPv4 address: " + address);
                }
            }
        }
        catch (Exception e) {
            log.debug("Not an IPv4 address: " + address);
        }
        return null;
    }

    protected void connect(String host, int portnumber) throws UnknownHostException, IOException, ServerResponseException {
        this.hylafaxServerHost = host;
        this.hylafaxServerPort = portnumber;
        InetAddress inetAddress = FtpClientProtocol.parseIPv4Address(host);
        if (inetAddress == null) {
            inetAddress = InetAddress.getByName(host);
        }
        this.sock = new Socket(inetAddress, portnumber);
        this.sock.setSoTimeout(this.socketTimeout);
        this.istream = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), this.getCharacterEncoding()));
        this.ostream = new OutputStreamWriter(this.sock.getOutputStream(), this.getCharacterEncoding());
        this.greeting = this.readResponse(this.istream);
        String temp = new String(this.greeting.substring(0, 3));
        while (temp.equals("130")) {
            log.warn(this.greeting);
            this.greeting = this.readResponse(this.istream);
            temp = new String(this.greeting.substring(0, 3));
        }
        if (!temp.equals("220")) {
            throw new ServerResponseException(this.greeting);
        }
        this.port = portnumber;
    }
}

