/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Password;
import yajhfc.PropertiesSerializable;
import yajhfc.Utils;
import yajhfc.YajLanguage;
import yajhfc.model.FmtItemList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaxOptions
implements PropertiesSerializable {
    static final Logger log = Logger.getLogger(AbstractFaxOptions.class.getName());
    protected final String propertyPrefix;
    private static final char sep = '|';

    public AbstractFaxOptions(String string) {
        this.propertyPrefix = string;
    }

    protected String getPropertyName(Field field, String string) {
        if (string == null || string.length() == 0) {
            return field.getName();
        }
        return string + '-' + field.getName();
    }

    public void storeToProperties(Properties properties) {
        this.storeToProperties(properties, this.getClass().getFields(), this.propertyPrefix);
    }

    @Override
    public void storeToProperties(Properties properties, String string) {
        this.storeToProperties(properties, this.getClass().getFields(), string);
    }

    public void storeToProperties(Properties properties, Field[] fieldArray, String string) {
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                Object object;
                Object object2;
                if (Modifier.isStatic(fieldArray[i].getModifiers()) || (object2 = fieldArray[i].get(this)) == null) continue;
                String string2 = this.getPropertyName(fieldArray[i], string);
                if (object2 instanceof String || object2 instanceof Integer || object2 instanceof Boolean || object2 instanceof Long || object2 instanceof Float || object2 instanceof Double) {
                    properties.setProperty(string2, object2.toString());
                    continue;
                }
                if (object2 instanceof YajLanguage) {
                    properties.setProperty(string2, ((YajLanguage)object2).getLangCode());
                    continue;
                }
                if (object2 instanceof FmtItemList) {
                    properties.setProperty(string2, ((FmtItemList)object2).saveToString());
                    continue;
                }
                if (object2 instanceof Rectangle) {
                    object = (Rectangle)object2;
                    properties.setProperty(string2, "" + ((Rectangle)object).x + '|' + ((Rectangle)object).y + '|' + ((Rectangle)object).width + '|' + ((Rectangle)object).height);
                    continue;
                }
                if (object2 instanceof Point) {
                    object = (Point)object2;
                    properties.setProperty(string2, "" + ((Point)object).x + '|' + ((Point)object).y);
                    continue;
                }
                if (object2 instanceof List) {
                    int n;
                    object = this.resolveTypeParameters(List.class, fieldArray[i]);
                    if (object == null || ((Class<?>[])object).length != 1) {
                        log.warning("Could not resolve type params for " + fieldArray[i]);
                        continue;
                    }
                    Class<?> clazz = object[0];
                    if (clazz == String.class) {
                        List list = (List)object2;
                        n = 0;
                        for (Object object3 : list) {
                            properties.setProperty(string2 + '.' + ++n, (String)object3);
                        }
                        properties.setProperty(string2, String.valueOf(list.size()));
                        continue;
                    }
                    if (Enum.class.isAssignableFrom(clazz)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        List list = (List)object2;
                        for (Object object3 : list) {
                            stringBuilder.append(((Enum)object3).name()).append('|');
                        }
                        properties.setProperty(string2, stringBuilder.toString());
                        continue;
                    }
                    if (PropertiesSerializable.class.isAssignableFrom(clazz)) {
                        List list = (List)object2;
                        n = 0;
                        properties.setProperty(string2 + ".count", String.valueOf(list.size()));
                        for (Object object3 : list) {
                            object3.storeToProperties(properties, string2 + '.' + ++n);
                        }
                        continue;
                    }
                    log.warning("Invalid list content type " + clazz + " for field " + fieldArray[i]);
                    continue;
                }
                if (object2 instanceof Enum) {
                    properties.setProperty(string2, ((Enum)object2).name());
                    continue;
                }
                if (object2 instanceof Password) {
                    properties.setProperty(string2 + "-obfuscated", ((Password)object2).getObfuscatedPassword());
                    continue;
                }
                if (object2 instanceof Map) {
                    object = new StringBuilder();
                    for (Map.Entry entry : ((Map)object2).entrySet()) {
                        String string3 = Utils.escapeChars((String)entry.getKey(), "=;", '~');
                        Iterator iterator = Utils.escapeChars((String)entry.getValue(), "=;", '~');
                        ((StringBuilder)object).append(string3).append('=').append((String)((Object)iterator)).append(';');
                    }
                    properties.setProperty(string2, ((StringBuilder)object).toString());
                    continue;
                }
                if (object2 instanceof Serializable) {
                    object = this.serializeObjectToString(object2);
                    properties.setProperty(string2, (String)object);
                    continue;
                }
                log.log(Level.WARNING, "Unknown field type " + object2.getClass().getName());
                continue;
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Exception reading field: ", exception);
            }
        }
    }

    public void loadFromProperties(Properties properties) {
        this.loadFromProperties(properties, this.propertyPrefix);
    }

    @Override
    public void loadFromProperties(Properties properties, String string) {
        if (properties.size() == 0) {
            log.info("No settings to load found.");
            return;
        }
        for (Field field : this.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object object;
                Object object2;
                Object object3;
                Class<?> clazz = field.getType();
                String string2 = this.getPropertyName(field, string);
                if (List.class.isAssignableFrom(clazz) && !FmtItemList.class.isAssignableFrom(clazz)) {
                    object3 = this.resolveTypeParameters(List.class, field);
                    if (object3 == null || ((Class<?>[])object3).length != 1) {
                        log.warning("Could not resolve type params for " + field);
                        continue;
                    }
                    object2 = object3[0];
                    if (object2 == String.class) {
                        String string3;
                        object = (List)field.get(this);
                        if (!properties.containsKey(string2) && !properties.containsKey(string2 + ".1")) continue;
                        object.clear();
                        int n = 1;
                        while ((string3 = properties.getProperty(string2 + '.' + n)) != null) {
                            object.add(string3);
                            ++n;
                        }
                        continue;
                    }
                    if (Enum.class.isAssignableFrom((Class<?>)object2)) {
                        String[] stringArray;
                        object = properties.getProperty(string2);
                        if (object == null) continue;
                        List list = (List)field.get(this);
                        list.clear();
                        if (object.length() <= 0) continue;
                        for (String string4 : stringArray = Utils.fastSplit((String)object, '|')) {
                            list.add(Enum.valueOf(object2, string4));
                        }
                        continue;
                    }
                    if (PropertiesSerializable.class.isAssignableFrom((Class<?>)object2)) {
                        object = (List)field.get(this);
                        object.clear();
                        int n = Integer.parseInt(properties.getProperty(string2 + ".count", "0"));
                        Constructor constructor = ((Class)object2).getConstructor(this.getClass());
                        for (int i = 1; i <= n; ++i) {
                            PropertiesSerializable propertiesSerializable = (PropertiesSerializable)constructor.newInstance(this);
                            propertiesSerializable.loadFromProperties(properties, string2 + '.' + i);
                            object.add(propertiesSerializable);
                        }
                        continue;
                    }
                    log.warning("Invalid list content type " + object2 + " for field " + field);
                    continue;
                }
                if (Password.class.isAssignableFrom(clazz)) {
                    object3 = (Password)field.get(this);
                    object2 = properties.getProperty(string2);
                    if (object2 != null) {
                        ((Password)object3).setPassword((String)object2);
                        continue;
                    }
                    object2 = properties.getProperty(string2 + "-obfuscated");
                    if (object2 == null) continue;
                    ((Password)object3).setObfuscatedPassword((String)object2);
                    continue;
                }
                object3 = properties.getProperty(string2);
                if (object3 == null) continue;
                if (String.class.isAssignableFrom(clazz)) {
                    field.set(this, object3);
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(clazz)) {
                    field.setInt(this, Integer.parseInt((String)object3));
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(clazz)) {
                    field.setLong(this, Long.parseLong((String)object3));
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(clazz)) {
                    field.setBoolean(this, Boolean.parseBoolean((String)object3));
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(clazz)) {
                    field.setFloat(this, Float.parseFloat((String)object3));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(clazz)) {
                    field.setDouble(this, Double.parseDouble((String)object3));
                    continue;
                }
                if (YajLanguage.class.isAssignableFrom(clazz)) {
                    field.set(this, YajLanguage.languageFromLangCode((String)object3));
                    continue;
                }
                if (FmtItemList.class.isAssignableFrom(clazz)) {
                    object2 = (FmtItemList)field.get(this);
                    ((FmtItemList)object2).loadFromString((String)object3);
                    continue;
                }
                if (Rectangle.class.isAssignableFrom(clazz)) {
                    object2 = Utils.fastSplit((String)object3, '|');
                    field.set(this, new Rectangle(Integer.parseInt(object2[0]), Integer.parseInt(object2[1]), Integer.parseInt(object2[2]), Integer.parseInt((String)object2[3])));
                    continue;
                }
                if (Point.class.isAssignableFrom(clazz)) {
                    object2 = Utils.fastSplit((String)object3, '|');
                    field.set(this, new Point(Integer.parseInt(object2[0]), Integer.parseInt(object2[1])));
                    continue;
                }
                if (Enum.class.isAssignableFrom(clazz)) {
                    field.set(this, Enum.valueOf(clazz, (String)object3));
                    continue;
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    object2 = (Map)field.get(this);
                    object2.clear();
                    for (String string5 : object = Utils.fastSplit((String)object3, ';')) {
                        int n = string5.indexOf(61);
                        if (n > 0) {
                            String string4;
                            string4 = Utils.unEscapeChars(string5.substring(0, n), "=;", '~');
                            String string6 = Utils.unEscapeChars(string5.substring(n + 1), "=;", '~');
                            object2.put(string4, string6);
                            continue;
                        }
                        log.warning("Unknown map entry in " + string2 + ": " + string5);
                    }
                    continue;
                }
                if (Serializable.class.isAssignableFrom(clazz)) {
                    object2 = this.deserializeObjectFromString((String)object3);
                    if (object2 == null) continue;
                    field.set(this, object2);
                    continue;
                }
                log.log(Level.WARNING, "Unknown field type " + clazz);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Couldn't load setting for " + field + ": ", exception);
            }
        }
    }

    protected String serializeObjectToString(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            char[] cArray = new char[byArray.length * 2];
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                cArray[2 * i] = Character.forDigit(by >> 4 & 0xF, 16);
                cArray[2 * i + 1] = Character.forDigit(by & 0xF, 16);
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Error serializing " + object, exception);
            return null;
        }
    }

    protected Object deserializeObjectFromString(String string) {
        try {
            char[] cArray = string.toCharArray();
            if (cArray.length % 2 != 0) {
                throw new IllegalArgumentException("String data length is not even!");
            }
            byte[] byArray = new byte[cArray.length / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(Character.digit(cArray[2 * i], 16) << 4 | Character.digit(cArray[2 * i + 1], 16));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Error deserializing", exception);
            return null;
        }
    }

    protected Class<?>[] resolveTypeParameters(Class<?> clazz, Field field) {
        Type type = field.getGenericType();
        if (type instanceof Class) {
            for (Type type2 : ((Class)type).getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(type2 instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)type2).getRawType().equals(clazz)) continue;
                type = parameterizedType;
                break;
            }
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            Class[] classArray = new Class[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                if (!(typeArray[i] instanceof Class)) {
                    log.fine("Need more levels of resolving for type " + typeArray[i] + " for field " + field);
                    return null;
                }
                classArray[i] = (Class)typeArray[i];
            }
            return classArray;
        }
        log.fine("Not a parameterized type: " + type + " for field " + field);
        return null;
    }

    public void copyFrom(AbstractFaxOptions abstractFaxOptions) {
        if (!this.getClass().isAssignableFrom(abstractFaxOptions.getClass())) {
            throw new IllegalArgumentException("Can only copy attributes from the same class or sub classes.");
        }
        for (Field field : this.getClass().getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object object;
                Object object2;
                Class<?> clazz = field.getType();
                if (Collection.class.isAssignableFrom(clazz)) {
                    object2 = (Collection)field.get(this);
                    object = (Collection)field.get(abstractFaxOptions);
                    object2.clear();
                    object2.addAll(object);
                    continue;
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    object2 = (Map)field.get(this);
                    object = (Map)field.get(abstractFaxOptions);
                    object2.clear();
                    object2.putAll(object);
                    continue;
                }
                if (Password.class.isAssignableFrom(clazz)) {
                    object2 = (Password)field.get(this);
                    object = (Password)field.get(abstractFaxOptions);
                    ((Password)object2).setObfuscatedPassword(((Password)object).getObfuscatedPassword());
                    continue;
                }
                field.set(this, field.get(abstractFaxOptions));
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Error copying field " + field, exception);
            }
        }
    }
}

