/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.print.attribute.Attribute;
import yajhfc.AbstractFaxOptions;
import yajhfc.IDAndNameOptions;
import yajhfc.PlatformInfo;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.YajLanguage;
import yajhfc.file.FileFormat;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.file.textextract.RecipientExtractionMode;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.JobFormat;
import yajhfc.model.RecvFormat;
import yajhfc.model.jobq.QueueFileFormat;
import yajhfc.options.MultiFileMode;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.convrules.CompanyRule;
import yajhfc.phonebook.convrules.LocationRule;
import yajhfc.phonebook.convrules.NameRule;
import yajhfc.phonebook.convrules.ZIPCodeRule;
import yajhfc.send.SendWinStyle;
import yajhfc.server.ServerOptions;
import yajhfc.util.AcceleratorKeys;

public class FaxOptions
extends AbstractFaxOptions
implements Cloneable {
    public final FmtItemList<RecvFormat> recvfmt;
    public final FmtItemList<JobFormat> sentfmt;
    public final FmtItemList<JobFormat> sendingfmt;
    public String faxViewer;
    public boolean useCustomFaxViewer = false;
    public String psViewer;
    public boolean useCustomPSViewer = false;
    public String pdfViewer;
    public boolean useCustomPDFViewer = false;
    public Rectangle mainWinBounds;
    public Rectangle phoneWinBounds;
    public Rectangle customFilterBounds;
    public Rectangle sendWinBounds;
    public Rectangle optWinBounds;
    public String recvColState;
    public String sentColState;
    public String sendingColState;
    public int mainwinLastTab;
    public String CustomCover;
    public boolean useCover;
    public boolean useCustomCover;
    public static final int NEWFAX_NOACTION = 0;
    public static final int NEWFAX_BEEP = 1;
    public static final int NEWFAX_TOFRONT = 2;
    public static final int NEWFAX_VIEWER = 4;
    public static final int NEWFAX_MARKASREAD = 8;
    public static final int NEWFAX_BLINKTRAYICON = 16;
    public int newFaxAction = 19;
    public boolean newFaxTrayNotification = true;
    public boolean pclBug = false;
    public String recvFilter = null;
    public String sentFilter = null;
    public String sendingFilter = null;
    public boolean allowChangeFilter = true;
    public YajLanguage locale = YajLanguage.SYSTEM_DEFAULT;
    public boolean markFailedJobs = true;
    public boolean showRowNumbers = false;
    public boolean adjustColumnWidths = true;
    public String lookAndFeel = "!system!";
    public static final String LOOKANDFEEL_SYSTEM = "!system!";
    public static final String LOOKANDFEEL_CROSSPLATFORM = "!crossplatform!";
    public final List<String> phoneBooks = new ArrayList<String>();
    public boolean regardingAsUsrKey = true;
    public String lastSavePath = "";
    public SendWinStyle sendWinStyle = SendWinStyle.SIMPLIFIED;
    public boolean sendWinIsAdvanced = false;
    public String lastSendWinPath = "";
    public static final String DEF_TOOLBAR_CONFIG = "Send|---|Show|Delete|---|Refresh|---|Phonebook|---|Resume|Suspend";
    public String toolbarConfig = "Send|---|Show|Delete|---|Refresh|---|Phonebook|---|Resume|Suspend";
    public final Map<String, String> keyboardAccelerators = new TreeMap<String, String>();
    public final Map<String, String> pbwinKeyboardAccelerators = new TreeMap<String, String>();
    public boolean showTrayIcon = true;
    public boolean minimizeToTray = true;
    public boolean minimizeToTrayOnMainWinClose = true;
    public String phonebookDisplayStyle = "GIVENNAME_NAME";
    public String phonebookSortOrder = "";
    public NameRule coverNameRule = NameRule.TITLE_GIVENNAME_NAME_JOBTITLE;
    public ZIPCodeRule coverZIPCodeRule = ZIPCodeRule.ZIPCODE_LOCATION;
    public LocationRule coverLocationRule = LocationRule.STREET_LOCATION;
    public CompanyRule coverCompanyRule = CompanyRule.DEPARTMENT_COMPANY;
    public boolean useJDK16PSBugfix = true;
    public boolean createSingleFilesForViewing = false;
    public boolean alwaysCreateTargetFormatForViewing = false;
    public MultiFileConvFormat singleFileFormatForViewing = MultiFileConvFormat.PDF;
    public boolean alwaysCreateTargetFormat = false;
    public MultiFileMode multiFileSendMode = MultiFileMode.NONE;
    public MultiFileConvFormat singleFileFormat = MultiFileConvFormat.PDF;
    public String ghostScriptLocation;
    public String tiff2PDFLocation;
    public final FmtItemList<QueueFileFormat> archiveFmt;
    public String archiveColState = "";
    public String archiveFilter = null;
    public String dateStyle = "$LOCALE$";
    public String timeStyle = "$LOCALE$";
    public long lastUpdateCheck = 0L;
    public String lastSeenUpdateVersion = "";
    public boolean automaticallyCheckForUpdate = false;
    public int statusBarSize = -1;
    public boolean useWin32ShutdownManager = true;
    public final List<String> faxNumbersLRU = new ArrayList<String>();
    public boolean adjustMenusForMacOSX = true;
    public Attribute[] printAttributes = null;
    public boolean faxprintColumnWidthAsOnScreen = true;
    public boolean faxprintMarkErrors = true;
    public boolean faxprintMarkUnread = true;
    public final List<PBEntryField> pbprintPrintColumns = new ArrayList<PBEntryField>();
    public Rectangle logViewerBounds = null;
    public boolean sendFORMCommand = true;
    public final Map<String, String> customFileConverters = new TreeMap<String, String>();
    public boolean autoReconnect = true;
    public boolean useFaxListCache = true;
    public final List<ServerOptions> servers = new ArrayList<ServerOptions>();
    public final List<SenderIdentity> identities = new ArrayList<SenderIdentity>();
    public int lastServerID = -1;
    public int statusUpdateInterval = 3000;
    public int tableUpdateInterval = 20000;
    public int socketTimeout = 90000;
    public String csvExportSettings = "";
    public String lastExportSavePath = "";
    public FileFormat lastExportFormat = FileFormat.CSV;
    public boolean usePaperSizeForTIFF2Any = true;
    public boolean showQuickSearchbar = true;
    public boolean showToolbar = true;
    public RecipientExtractionMode extractRecipients = RecipientExtractionMode.NO;
    public String hylaToTextConverter = "yajhfc.file.textextract.PSToTextConverter";
    public String pstotextPath = PlatformInfo.IS_WINDOWS ? "pstotxt3.exe" : "pstotext";
    public String pdftotextPath = "pdftotext";
    public boolean expandPhoneBooksOnLoad = true;
    public final List<String> dialogsDoNotAskAgain = new ArrayList<String>();
    public static final String[] DEFAULT_RECIPIENT_EXTRACTION_TAGS = new String[]{"Ffax", "Frecipient", "Mmail", "Mmailrecipient", "Ssubject"};
    public final List<String> recipientExtractionTags = new ArrayList<String>();
    public boolean recipientExtractionTagMandatoryColon = false;
    private static final String[][] copyDefaultSettings = new String[][]{{"alwaysCreateTargetFormat", "alwaysCreateTargetFormatForViewing"}, {"singleFileFormat", "singleFileFormatForViewing"}};

    public FaxOptions() {
        super(null);
        this.recvfmt = new FmtItemList((FmtItem[])RecvFormat.values(), (FmtItem[])RecvFormat.getRequiredFormats());
        this.recvfmt.add(RecvFormat.Y);
        this.recvfmt.add(RecvFormat.s);
        this.recvfmt.add(RecvFormat.e);
        this.recvfmt.add(RecvFormat.h);
        this.recvfmt.add(RecvFormat.p);
        this.recvfmt.add(RecvFormat.f);
        this.recvColState = String.valueOf(this.recvfmt.indexOf(RecvFormat.f) + 1);
        this.sentfmt = new FmtItemList((FmtItem[])JobFormat.values(), (FmtItem[])JobFormat.getRequiredFormats());
        this.sentfmt.add(JobFormat.o);
        this.sentfmt.add(JobFormat.e);
        this.sentfmt.add(JobFormat.s);
        this.sentfmt.add(JobFormat.t);
        this.sentfmt.add(JobFormat.j);
        this.sentfmt.add(JobFormat.a_desc);
        this.sentfmt.add(JobFormat.Y);
        this.sendingfmt = new FmtItemList((FmtItem[])JobFormat.values(), (FmtItem[])JobFormat.getRequiredFormats());
        this.sendingfmt.addAll((Collection<JobFormat>)this.sentfmt);
        this.sendingColState = "";
        this.sentColState = "";
        this.archiveFmt = new FmtItemList((FmtItem[])QueueFileFormat.values(), (FmtItem[])QueueFileFormat.getRequiredFormats());
        this.archiveFmt.add(QueueFileFormat.owner);
        this.archiveFmt.add(QueueFileFormat.number);
        this.archiveFmt.add(QueueFileFormat.tottries);
        this.archiveFmt.add(QueueFileFormat.jobid);
        this.archiveFmt.add(QueueFileFormat.state);
        this.archiveFmt.add(QueueFileFormat.status);
        String string = PlatformInfo.getSystemViewerCommandLine();
        if (PlatformInfo.IS_WINDOWS) {
            this.psViewer = string;
            this.pdfViewer = string;
            String string2 = System.getProperty("os.name");
            this.faxViewer = string2.indexOf("XP") >= 0 || string2.indexOf("Vista") >= 0 ? "rundll32.exe shimgvw.dll,ImageView_Fullscreen %s" : string;
            this.ghostScriptLocation = "gswin32c.exe";
            this.tiff2PDFLocation = "tiff2pdf.exe";
        } else {
            if (string == null) {
                this.faxViewer = "kfax %s";
                this.psViewer = "gv %s";
                this.pdfViewer = "xpdf %s";
            } else {
                this.faxViewer = string;
                this.psViewer = string;
                this.pdfViewer = string;
            }
            this.ghostScriptLocation = "gs";
            this.tiff2PDFLocation = "tiff2pdf";
        }
        this.mainWinBounds = null;
        this.phoneWinBounds = null;
        this.mainwinLastTab = 0;
        this.useCover = false;
        this.useCustomCover = false;
        this.CustomCover = "";
        this.keyboardAccelerators.putAll(AcceleratorKeys.DEFAULT_MAINWIN_MAPPING);
        this.pbwinKeyboardAccelerators.putAll(AcceleratorKeys.DEFAULT_PBWIN_MAPPING);
        Collections.addAll(this.recipientExtractionTags, DEFAULT_RECIPIENT_EXTRACTION_TAGS);
    }

    public void loadFromProperties(Properties properties) {
        int n;
        Properties properties2 = null;
        Object object = copyDefaultSettings;
        int n2 = ((String[][])object).length;
        for (int i = 0; i < n2; ++i) {
            String[] stringArray = object[i];
            String string = properties.getProperty(stringArray[0]);
            if (string == null) continue;
            for (n = 1; n < stringArray.length; ++n) {
                String string2 = stringArray[n];
                if (properties.getProperty(string2) != null) continue;
                if (properties2 == null) {
                    properties2 = new Properties(properties);
                }
                properties2.setProperty(string2, string);
            }
        }
        super.loadFromProperties(properties2 == null ? properties : properties2);
        if (properties.containsKey("host")) {
            object = new ServerOptions(this);
            ((ServerOptions)object).name = Utils._("Default");
            ((AbstractFaxOptions)object).loadFromProperties(properties);
            this.servers.add((ServerOptions)object);
        }
        if (properties.containsKey("FromName")) {
            object = new SenderIdentity(this);
            ((SenderIdentity)object).name = Utils._("Default");
            ((AbstractFaxOptions)object).loadFromProperties(properties);
            this.identities.add((SenderIdentity)object);
        }
        if (this.servers.size() == 0) {
            object = new ServerOptions(this);
            ((ServerOptions)object).name = Utils._("Default");
            this.servers.add((ServerOptions)object);
        } else {
            int n3 = IDAndNameOptions.removeDuplicates(this.servers);
            if (n3 > 0) {
                log.severe("" + n3 + " duplicate servers removed!");
            }
        }
        if (this.identities.size() == 0) {
            SenderIdentity senderIdentity = new SenderIdentity(this);
            senderIdentity.name = Utils._("Default");
            this.identities.add(senderIdentity);
        } else {
            int n4 = IDAndNameOptions.removeDuplicates(this.identities);
            if (n4 > 0) {
                log.severe("" + n4 + " duplicate identities removed!");
            }
        }
        char[] cArray = new char[this.recipientExtractionTags.size()];
        for (n2 = 0; n2 < this.recipientExtractionTags.size(); ++n2) {
            String string = this.recipientExtractionTags.get(n2);
            if (string.length() < 1) continue;
            cArray[n2] = string.charAt(0);
        }
        for (String string : DEFAULT_RECIPIENT_EXTRACTION_TAGS) {
            n = string.charAt(0);
            boolean bl = false;
            for (char c : cArray) {
                if (n != c) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            log.info("Adding recipient extraction tag " + string);
            this.recipientExtractionTags.add(string);
        }
    }

    public FaxOptions clone() {
        try {
            return (FaxOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public ServerOptions getDefaultServer() {
        if (this.servers.size() == 0) {
            return null;
        }
        return this.servers.get(0);
    }

    public SenderIdentity getDefaultIdentity() {
        if (this.identities.size() == 0) {
            return null;
        }
        return this.identities.get(0);
    }
}

