/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import yajhfc.Utils;
import yajhfc.util.SafeJFileChooser;

public class FileTextField
extends JComponent
implements ActionListener {
    protected JTextField jTextField;
    protected JButton jButton;
    private JFileChooser fileChooser;
    protected FileFilter[] fileFilters;
    private boolean filtersChanged = true;
    protected int fileSelectionMode = 0;
    protected File currentDirectory = null;

    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new SafeJFileChooser();
        }
        return this.fileChooser;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.configureFileChooser(jFileChooser);
        if (this.currentDirectory != null) {
            jFileChooser.setCurrentDirectory(this.currentDirectory);
        }
        jFileChooser.setSelectedFile(new File(this.readTextFieldFileName()));
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.currentDirectory = jFileChooser.getCurrentDirectory();
            this.handleUserSelection(jFileChooser);
        }
    }

    protected void configureFileChooser(JFileChooser jFileChooser) {
        if (this.fileFilters != null && this.fileFilters.length > 0 && this.filtersChanged) {
            jFileChooser.resetChoosableFileFilters();
            for (FileFilter fileFilter : this.fileFilters) {
                jFileChooser.addChoosableFileFilter(fileFilter);
            }
            FileFilter fileFilter = jFileChooser.getAcceptAllFileFilter();
            jFileChooser.removeChoosableFileFilter(fileFilter);
            jFileChooser.addChoosableFileFilter(fileFilter);
            jFileChooser.setFileFilter(this.fileFilters[0]);
            this.filtersChanged = false;
        }
        jFileChooser.setFileSelectionMode(this.fileSelectionMode);
    }

    protected void handleUserSelection(JFileChooser jFileChooser) {
        this.writeTextFieldFileName(jFileChooser.getSelectedFile().getPath());
    }

    protected String readTextFieldFileName() {
        return this.getText();
    }

    protected void writeTextFieldFileName(String string) {
        this.setText(string);
    }

    public String getText() {
        return this.jTextField.getText();
    }

    public void setText(String string) {
        this.jTextField.setText(string);
    }

    public JTextField getJTextField() {
        return this.jTextField;
    }

    public JButton getJButton() {
        return this.jButton;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public void setFileSelectionMode(int n) {
        this.fileSelectionMode = n;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public FileFilter[] getFileFilters() {
        return this.fileFilters;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.jButton.setEnabled(bl);
        this.jTextField.setEnabled(bl);
    }

    public void setFileFilters(FileFilter ... fileFilterArray) {
        this.fileFilters = fileFilterArray;
        this.filtersChanged = true;
    }

    public FileTextField() {
        this.setLayout(new BoxLayout(this, 0));
        this.jTextField = new JTextField();
        this.jButton = new JButton(Utils.loadIcon("general/Open"));
        this.jButton.setToolTipText(Utils._("Choose a file using a dialog"));
        this.jButton.addActionListener(this);
        Dimension dimension = this.jButton.getPreferredSize();
        Dimension dimension2 = this.jTextField.getPreferredSize();
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        } else {
            dimension2.height = dimension.height;
        }
        dimension2.width = Integer.MAX_VALUE;
        this.jButton.setMaximumSize(dimension);
        this.jTextField.setMaximumSize(dimension2);
        this.add(this.jTextField);
        this.add(this.jButton);
    }
}

