/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.util.Arrays;
import java.util.List;
import yajhfc.Utils;

public class HylaModem {
    protected String internalName;
    protected String number;
    protected String description;
    public static final List<HylaModem> defaultModems = Arrays.asList(new HylaModem("any", null, Utils._("Any modem")));

    public HylaModem(String string, String string2, String string3) {
        this.internalName = string;
        this.number = string2;
        this.description = string3;
    }

    public HylaModem(String string, String string2) {
        this(string, string2, HylaModem.generateDescription(string, string2));
    }

    public HylaModem(String string) {
        this.loadFromString(string);
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public String saveToString() {
        return Utils.escapeChars(this.internalName == null ? "" : this.internalName, "|", '~') + "|" + Utils.escapeChars(this.number == null ? "" : this.number, "|", '~') + "|" + Utils.escapeChars(this.description == null ? "" : this.description, "|", '~');
    }

    protected void loadFromString(String string) {
        String[] stringArray = Utils.fastSplit(string, '|');
        if (stringArray.length >= 1) {
            this.internalName = Utils.unEscapeChars(stringArray[0], "|", '~');
        }
        if (stringArray.length >= 2) {
            this.number = Utils.unEscapeChars(stringArray[1], "|", '~');
        }
        if (stringArray.length >= 3) {
            this.description = Utils.unEscapeChars(stringArray[2], "|", '~');
        }
    }

    protected static String generateDescription(String string, String string2) {
        return string + " (" + string2 + ")";
    }
}

