/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import yajhfc.AbstractFaxOptions;
import yajhfc.FaxOptions;
import yajhfc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IDAndNameOptions
extends AbstractFaxOptions {
    public int id;
    public String name;
    protected final FaxOptions parent;
    private static int maxID = 0;

    @Override
    public void loadFromProperties(Properties properties, String string) {
        super.loadFromProperties(properties, string);
        IDAndNameOptions.newIDLoaded(this.id);
    }

    protected IDAndNameOptions(String string, FaxOptions faxOptions, int n) {
        super(string);
        this.parent = faxOptions;
        this.id = n;
        this.name = this.getClass().getSimpleName() + '-' + n;
    }

    public IDAndNameOptions(String string, FaxOptions faxOptions) {
        this(string, faxOptions, IDAndNameOptions.getNewID());
    }

    public FaxOptions getParent() {
        return this.parent;
    }

    public void generateNewID() {
        this.id = IDAndNameOptions.getNewID();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        IDAndNameOptions iDAndNameOptions = (IDAndNameOptions)object;
        return iDAndNameOptions.id == this.id && iDAndNameOptions.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    protected static synchronized int getNewID() {
        return ++maxID;
    }

    protected static synchronized void newIDLoaded(int n) {
        if (n > maxID) {
            maxID = n;
        }
    }

    public static <E extends IDAndNameOptions> E getItemByID(Collection<E> collection, int n) {
        for (IDAndNameOptions iDAndNameOptions : collection) {
            if (iDAndNameOptions.id != n) continue;
            return (E)iDAndNameOptions;
        }
        return null;
    }

    public static <E extends IDAndNameOptions> E getItemByName(Collection<E> collection, String string) {
        for (IDAndNameOptions iDAndNameOptions : collection) {
            if (!string.equals(iDAndNameOptions.name)) continue;
            return (E)iDAndNameOptions;
        }
        return null;
    }

    public static <E extends IDAndNameOptions> E getItemByNameIgnoreCase(Collection<E> collection, String string) {
        for (IDAndNameOptions iDAndNameOptions : collection) {
            if (!string.equalsIgnoreCase(iDAndNameOptions.name)) continue;
            return (E)iDAndNameOptions;
        }
        return null;
    }

    public static <E extends IDAndNameOptions> E getItemFromCommandLineCoding(List<E> list, String string) {
        if (string.startsWith("#")) {
            try {
                return IDAndNameOptions.getItemByID(list, Integer.parseInt(string.substring(1)));
            }
            catch (NumberFormatException numberFormatException) {
                return IDAndNameOptions.getItemByName(list, string);
            }
        }
        if (Utils.isStringNumeric(string)) {
            try {
                return (E)((IDAndNameOptions)list.get(Integer.parseInt(string)));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return IDAndNameOptions.getItemByName(list, string);
    }

    public static boolean checkForDuplicates(List<? extends IDAndNameOptions> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            IDAndNameOptions iDAndNameOptions = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                IDAndNameOptions iDAndNameOptions2 = list.get(j);
                if (iDAndNameOptions.id != iDAndNameOptions2.id) continue;
                return true;
            }
        }
        return false;
    }

    public static int removeDuplicates(List<? extends IDAndNameOptions> list) {
        int n = 0;
        for (int i = 0; i < list.size() - 1; ++i) {
            IDAndNameOptions iDAndNameOptions = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                IDAndNameOptions iDAndNameOptions2 = list.get(j);
                if (iDAndNameOptions.id != iDAndNameOptions2.id) continue;
                list.remove(j);
                ++n;
            }
        }
        return n;
    }
}

