/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import yajhfc.TextViewPanel;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.util.ProgressWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogViewWorker
extends ProgressWorker {
    protected List<FaxJob<? extends FmtItem>> jobs;
    protected List<TextViewPanel.Text> logList;
    protected FaxListConnection connection;

    public LogViewWorker(FaxListConnection faxListConnection, List<FaxJob<? extends FmtItem>> list, ProgressWorker.ProgressUI progressUI) {
        this.jobs = list;
        this.progressMonitor = progressUI;
        this.connection = faxListConnection;
    }

    @Override
    protected int calculateMaxProgress() {
        return this.jobs.size() * 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() {
        if (this.jobs.size() == 0) {
            return;
        }
        MessageFormat messageFormat = new MessageFormat(Utils._("Getting log for {0}"));
        MessageFormat messageFormat2 = new MessageFormat(Utils._("Fax job {0} ({1})"));
        this.logList = new ArrayList<TextViewPanel.Text>(this.jobs.size());
        try {
            this.connection.beginMultiOperation();
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4000);
                for (FaxJob<? extends FmtItem> faxJob : this.jobs) {
                    this.updateNote(messageFormat.format(new Object[]{faxJob.getIDValue()}));
                    FaxDocument faxDocument = faxJob.getCommunicationsLog();
                    if (faxDocument == null) {
                        this.logList.add(new TextViewPanel.Text(messageFormat2.format(new Object[]{faxJob.getIDValue(), Utils._("<none>")}), Utils._("There is no log file available for this fax job.")));
                    } else {
                        String string = messageFormat2.format(new Object[]{faxJob.getIDValue(), faxDocument.getPath()});
                        try {
                            byteArrayOutputStream.reset();
                            faxDocument.downloadToStream(byteArrayOutputStream);
                            String string2 = byteArrayOutputStream.toString(this.connection.getOptions().hylaFAXCharacterEncoding);
                            this.logList.add(new TextViewPanel.Text(string, string2));
                        }
                        catch (Exception exception) {
                            this.logList.add(new TextViewPanel.Text(string, Utils._("Error retrieving the log:") + '\n' + exception.toString()));
                        }
                    }
                    this.stepProgressBar(100);
                }
            }
            finally {
                this.connection.endMultiOperation();
            }
        }
        catch (Exception exception) {
            this.showExceptionDialog(Utils._("Error retrieving the log:"), exception);
        }
    }

    @Override
    protected void done() {
        TextViewPanel.displayFrame(Utils._("View log"), this.logList, false);
    }
}

