/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Password {
    private static final Logger log = Logger.getLogger(Password.class.getName());
    private String password = null;
    private String obfuscatedPassword = null;
    private static Random generator;

    public String getPassword() {
        if (this.password == null) {
            try {
                this.password = Password.deobfuscatePassword(this.obfuscatedPassword);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.log(Level.WARNING, "Error deobfuscating a password: ", unsupportedEncodingException);
                this.obfuscatedPassword = null;
            }
        }
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
        this.obfuscatedPassword = null;
    }

    public String getObfuscatedPassword() {
        if (this.obfuscatedPassword == null) {
            try {
                this.obfuscatedPassword = Password.obfuscatePassword(this.password);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.log(Level.WARNING, "Error obfuscating a password: ", unsupportedEncodingException);
                this.obfuscatedPassword = null;
            }
        }
        return this.obfuscatedPassword;
    }

    public void setObfuscatedPassword(String string) {
        this.obfuscatedPassword = string;
        this.password = null;
    }

    public String toString() {
        char[] cArray = new char[this.getPassword().length()];
        Arrays.fill(cArray, '*');
        return new String(cArray);
    }

    private static int getRandomInt() {
        if (generator == null) {
            generator = new Random();
        }
        return 1 + generator.nextInt(28);
    }

    public static String obfuscatePassword(String string) throws UnsupportedEncodingException {
        if (string == null || string.length() == 0) {
            return "";
        }
        byte[] byArray = string.getBytes("utf-8");
        char[] cArray = new char[byArray.length * 2 + 1];
        int n = Password.getRandomInt();
        cArray[0] = Character.forDigit(n, 29);
        for (int i = 0; i < byArray.length; ++i) {
            int n2;
            int n3 = byArray[i] & 0xFF;
            int n4 = (n3 + i) * n % 29;
            if (n4 < 0) {
                n4 += 29;
            }
            if ((n2 = (n3 / 29 + i) * n % 29) < 0) {
                n2 += 29;
            }
            cArray[2 * i + 1] = Character.forDigit(n4, 29);
            cArray[2 * i + 2] = Character.forDigit(n2, 29);
        }
        return new String(cArray);
    }

    public static String deobfuscatePassword(String string) throws UnsupportedEncodingException {
        if (string == null || string.length() == 0) {
            return "";
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = Password.extEuclid(Character.digit(string.charAt(0), 29), 29)[1] % 29;
        if (n < 0) {
            n += 29;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n2;
            int n3 = (Character.digit(string.charAt(2 * i + 1), 29) * n - i) % 29;
            if (n3 < 0) {
                n3 += 29;
            }
            if ((n2 = (Character.digit(string.charAt(2 * i + 2), 29) * n - i) % 29) < 0) {
                n2 += 29;
            }
            byArray[i] = (byte)(n2 * 29 + n3);
        }
        return new String(byArray, "utf-8");
    }

    private static int[] extEuclid(int n, int n2) {
        int n3;
        if (n2 == 0) {
            return new int[]{n, 1, 0};
        }
        int[] nArray = Password.extEuclid(n2, n % n2);
        int n4 = nArray[1];
        nArray[1] = n3 = nArray[2];
        nArray[2] = n4 - n / n2 * n3;
        return nArray;
    }
}

