/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.SafeJFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextViewPanel
extends JPanel {
    private static final int border = 8;
    Action actSave;
    Action actCopy;
    JTabbedPane tabs;
    boolean wordWrap;

    public static JFrame displayFrame(String string, List<Text> list, boolean bl) throws HeadlessException {
        JFrame jFrame = new JFrame(string);
        TextViewPanel.initFrame(jFrame, list, bl);
        jFrame.setVisible(true);
        return jFrame;
    }

    public static JDialog displayDialog(Frame frame, String string, List<Text> list, boolean bl) throws HeadlessException {
        JDialog jDialog = new JDialog(frame, string, false);
        TextViewPanel.initDialog(jDialog, list, bl);
        jDialog.setVisible(true);
        return jDialog;
    }

    public static JDialog displayDialog(Dialog dialog, String string, List<Text> list, boolean bl) throws HeadlessException {
        JDialog jDialog = new JDialog(dialog, string, false);
        TextViewPanel.initDialog(jDialog, list, bl);
        jDialog.setVisible(true);
        return jDialog;
    }

    private static void initFrame(JFrame jFrame, List<Text> list, boolean bl) {
        TextViewPanel textViewPanel = new TextViewPanel(list, bl, jFrame);
        jFrame.setContentPane(textViewPanel);
        jFrame.setIconImage(Utils.loadIcon("general/History").getImage());
        jFrame.setDefaultCloseOperation(2);
        TextViewPanel.commonWindowInit(jFrame);
    }

    private static void initDialog(JDialog jDialog, List<Text> list, boolean bl) {
        TextViewPanel textViewPanel = new TextViewPanel(list, bl, jDialog);
        jDialog.setContentPane(textViewPanel);
        jDialog.setDefaultCloseOperation(2);
        TextViewPanel.commonWindowInit(jDialog);
    }

    private static void commonWindowInit(final Window window) {
        if (Utils.getFaxOptions().logViewerBounds != null) {
            window.setBounds(Utils.getFaxOptions().logViewerBounds);
        } else {
            window.pack();
            Utils.setDefWinPos(window);
        }
        window.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                Utils.getFaxOptions().logViewerBounds = window.getBounds();
            }
        });
    }

    public TextViewPanel(List<Text> list, boolean bl, Window window) {
        super(new BorderLayout());
        this.wordWrap = bl;
        this.initialize(list, window);
    }

    private void initialize(List<Text> list, Window window) {
        this.createActions();
        CancelAction cancelAction = new CancelAction(window, Utils._("Close"));
        this.tabs = new JTabbedPane(3);
        for (Text text : list) {
            this.addLog(text);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 8, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel.add(new JButton(this.actCopy));
        jPanel.add(new JButton(this.actSave));
        jPanel.add(cancelAction.createCancelButton());
        this.add((Component)this.tabs, "Center");
        this.add((Component)jPanel, "South");
    }

    private void addLog(Text text) {
        JTextArea jTextArea = new JTextArea(text.log);
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        if (this.wordWrap) {
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
        }
        ClipboardPopup.DEFAULT_POPUP.addToComponent(jTextArea);
        this.tabs.addTab(text.caption, new JScrollPane(jTextArea, 22, 30));
    }

    private void createActions() {
        this.actSave = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                SafeJFileChooser safeJFileChooser = new SafeJFileChooser();
                if (Utils.getFaxOptions().lastSavePath.length() > 0) {
                    safeJFileChooser.setCurrentDirectory(new File(Utils.getFaxOptions().lastSavePath));
                }
                safeJFileChooser.resetChoosableFileFilters();
                ExampleFileFilter exampleFileFilter = new ExampleFileFilter(FileFormat.PlainText.getPossibleExtensions(), FileFormat.PlainText.getDescription());
                ExampleFileFilter exampleFileFilter2 = new ExampleFileFilter("log", Utils._("Log files"));
                safeJFileChooser.addChoosableFileFilter(exampleFileFilter);
                safeJFileChooser.addChoosableFileFilter(exampleFileFilter2);
                safeJFileChooser.setFileFilter(exampleFileFilter);
                if (safeJFileChooser.showSaveDialog(TextViewPanel.this) == 0) {
                    Utils.getFaxOptions().lastSavePath = safeJFileChooser.getCurrentDirectory().getAbsolutePath();
                    File file = Utils.getSelectedFileFromSaveChooser(safeJFileChooser);
                    JTextArea jTextArea = (JTextArea)((JScrollPane)TextViewPanel.this.tabs.getSelectedComponent()).getViewport().getView();
                    try {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
                        outputStreamWriter.write(jTextArea.getText());
                        outputStreamWriter.close();
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog(TextViewPanel.this, Utils._("Error saving the file"), exception);
                    }
                }
            }
        };
        this.actSave.putValue("Name", Utils._("Save") + "...");
        this.actSave.putValue("SmallIcon", Utils.loadIcon("general/Save"));
        this.actCopy = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = (JTextArea)((JScrollPane)TextViewPanel.this.tabs.getSelectedComponent()).getViewport().getView();
                StringSelection stringSelection = new StringSelection(jTextArea.getText());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        };
        this.actCopy.putValue("Name", Utils._("Copy"));
        this.actCopy.putValue("SmallIcon", Utils.loadIcon("general/Copy"));
    }

    public static class Text {
        public String caption;
        public String log;

        public Text(String string, String string2) {
            this.caption = string;
            this.log = string2;
        }
    }
}

