/*
 * Decompiled with CFR 0.152.
 */
package yajhfc;

import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import yajhfc.FaxOptions;
import yajhfc.PlatformInfo;
import yajhfc.RegExDateFormat;
import yajhfc.YajLanguage;
import yajhfc.launch.Launcher2;
import yajhfc.macosx.MacOSXSupport;
import yajhfc.model.jobq.QueueFileDateFormat;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginUI;
import yajhfc.util.AWTExceptionLogger;
import yajhfc.util.ArrayCharSequence;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.ExternalProcessExecutor;
import yajhfc.util.TransactFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static final RegExDateFormat HYLA_LONG_DATE_FORMAT = new RegExDateFormat("(\\d{2,4})[\\.:/](\\d{1,2})[\\.:/](\\d{1,2})\\s+(\\d{1,2})[\\.:/](\\d{1,2})[\\.:/](\\d{1,2})", 1, 2, 5, 11, 12, 13);
    public static final RegExDateFormat HYLA_DURATION_FORMAT = new RegExDateFormat("(?:(\\d{1,2})[\\.:/])?(\\d{1,2})[\\.:/](\\d{1,2})", 11, 12, 13);
    public static final RegExDateFormat HYLA_TIME_ONLY_FORMAT = new RegExDateFormat("(\\d{1,2})[\\.:/](\\d{1,2})(?:[\\.:/](\\d{1,2}))?", 11, 12, 13);
    public static final DateFormat HYLA_UNIX_DATE_FORMAT = new QueueFileDateFormat(false);
    public static final DateFormat HYLA_UNIX_DATE_FORMAT_GMT = new QueueFileDateFormat(true);
    public static boolean debugMode = false;
    public static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2);
    static final Logger log = Logger.getLogger(Utils.class.getName());
    private static FaxOptions theoptions = null;
    private static File configDir = null;
    private static File applicationDir;
    private static File systemwideConfigDir;
    private static boolean systemwideConfigDirSet;
    public static final Locale DEFAULT_LOCALE;
    private static YajLanguage yajhfcLang;
    private static Properties settingsProperties;
    private static Properties settingsPropertiesNoOverride;
    private static Set<Object> settingsNoSave;

    public static File getApplicationDir() {
        if (applicationDir == null) {
            Object object;
            URL uRL = Utils.class.getResource("Utils.class");
            try {
                while (uRL.getProtocol().equals("jar")) {
                    object = uRL.getPath();
                    int n = ((String)object).lastIndexOf(33);
                    if (n >= 0) {
                        object = ((String)object).substring(0, n);
                    }
                    uRL = new URL((String)object);
                }
            }
            catch (MalformedURLException malformedURLException) {
                log.log(Level.WARNING, "Error determining application dir:", malformedURLException);
            }
            if (uRL.getProtocol().equals("file")) {
                try {
                    object = uRL.toURI();
                    if (PlatformInfo.IS_WINDOWS && ((URI)object).getAuthority() != null) {
                        object = new URI("file", null, "////" + ((URI)object).getAuthority() + '/' + ((URI)object).getPath(), null);
                    }
                    applicationDir = new File((URI)object).getParentFile();
                }
                catch (URISyntaxException uRISyntaxException) {
                    applicationDir = new File(".");
                    log.log(Level.SEVERE, "Application directory not found, url was: " + Utils.class.getResource("Utils.class"), uRISyntaxException);
                }
            } else {
                applicationDir = new File(".");
                log.severe("Application directory not found, url was: " + Utils.class.getResource("Utils.class"));
            }
        }
        return applicationDir;
    }

    public static File getSystemwideConfigDir() {
        if (!systemwideConfigDirSet) {
            if (File.separatorChar == '/' && !PlatformInfo.IS_WINDOWS) {
                File file = new File("/etc/yajhfc");
                if (file.isDirectory()) {
                    systemwideConfigDir = file;
                    log.fine("Found system wide config dir at " + file);
                } else {
                    systemwideConfigDir = null;
                    log.fine("Did not find system wide config dir at " + file);
                }
            }
            systemwideConfigDirSet = true;
        }
        return systemwideConfigDir;
    }

    public static String listToString(Collection<?> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection.size() == 0) {
            return "";
        }
        for (Object obj : collection) {
            stringBuilder.append(obj).append(string);
        }
        stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
        return stringBuilder.toString();
    }

    public static FaxOptions getFaxOptions() {
        if (theoptions == null) {
            theoptions = new FaxOptions();
            theoptions.loadFromProperties(Utils.getSettingsProperties());
        }
        return theoptions;
    }

    public static Locale getLocale() {
        return Utils.getYajHFCLanguage().getLocale();
    }

    public static YajLanguage getYajHFCLanguage() {
        if (yajhfcLang == null) {
            Properties properties = Utils.getSettingsProperties();
            String string = properties.getProperty("locale", "auto");
            yajhfcLang = YajLanguage.languageFromLangCode(string);
            Locale.setDefault(yajhfcLang.getLocale());
            UIManager.getDefaults().addResourceBundle("yajhfc.i18n.UIDefaults");
        }
        return yajhfcLang;
    }

    public static File getDefaultConfigFile() {
        return new File(Utils.getConfigDir(), "settings");
    }

    public static Properties getSettingsProperties() {
        if (settingsProperties == null) {
            File file;
            File file2 = Utils.getDefaultConfigFile();
            if (TransactFileOutputStream.checkRecovery(file2) && (file = new File(Utils.getConfigDir(), "shutdown.log")).exists()) {
                file.renameTo(new File(Utils.getConfigDir(), "shutdown-fail.log"));
            }
            file = Utils.getApplicationDir();
            File[] fileArray = Utils.listSettingsD(file);
            File file3 = Utils.getSystemwideConfigDir();
            File[] fileArray2 = Utils.listSettingsD(file3);
            ArrayList<File> arrayList = new ArrayList<File>();
            Utils.addSettingsD(arrayList, fileArray, ".default");
            arrayList.add(new File(file, "settings.default"));
            if (file3 != null) {
                Utils.addSettingsD(arrayList, fileArray2, ".default");
                arrayList.add(new File(file3, "settings.default"));
            }
            arrayList.add(file2);
            Utils.addSettingsD(arrayList, fileArray, ".override");
            arrayList.add(new File(file, "settings.override"));
            if (file3 != null) {
                Utils.addSettingsD(arrayList, fileArray2, ".override");
                arrayList.add(new File(file3, "settings.override"));
            }
            Properties properties = new Properties();
            for (File file4 : arrayList) {
                if (debugMode) {
                    log.fine("Loading prefs from " + file4);
                }
                try {
                    if (file4.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file4);
                        properties.load(fileInputStream);
                        fileInputStream.close();
                        continue;
                    }
                    if (!debugMode) continue;
                    log.info(file4 + " not found");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!debugMode) continue;
                    log.log(Level.INFO, file4 + " not found", fileNotFoundException);
                }
                catch (IOException iOException) {
                    log.log(Level.WARNING, "Error reading file '" + file4 + "': ", iOException);
                }
            }
            settingsPropertiesNoOverride = properties;
            if (Launcher2.overrideSettings != null) {
                properties = new Properties(properties);
                if (debugMode) {
                    log.config("---- Override settings found:");
                    Utils.dumpProperties(Launcher2.overrideSettings, log, new Object[0]);
                    log.config("---- End override settings");
                }
                properties.putAll((Map<?, ?>)Launcher2.overrideSettings);
                settingsNoSave = Launcher2.overrideSettings.keySet();
            } else {
                settingsNoSave = null;
            }
            if (debugMode) {
                log.config("---- BEGIN preferences dump");
                Utils.dumpProperties(properties, log, "pass", "AdminPassword", Pattern.compile(".+-obfuscated$"));
                log.config("---- END preferences dump");
            }
            settingsProperties = properties;
        }
        return settingsProperties;
    }

    private static File[] listSettingsD(File file) {
        if (file != null) {
            File file2 = new File(file, "settings.d");
            if (file2.isDirectory()) {
                Object[] objectArray = file2.listFiles();
                Arrays.sort(objectArray);
                return objectArray;
            }
            return null;
        }
        return null;
    }

    private static void addSettingsD(List<File> list, File[] fileArray, String string) {
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!file.getName().endsWith(string)) continue;
                list.add(file);
            }
        }
    }

    public static void storeOptionsToFile() {
        Utils.storeOptionsToFile(Utils.getDefaultConfigFile());
    }

    public static void storeOptionsToFile(File file) {
        if (theoptions != null) {
            Properties properties = new Properties();
            for (PluginUI object : PluginManager.pluginUIs) {
                object.saveOptions(properties);
            }
            theoptions.storeToProperties(properties);
            if (settingsNoSave != null) {
                for (Object object : settingsNoSave) {
                    String string = settingsPropertiesNoOverride.getProperty((String)object);
                    if (string == null) continue;
                    properties.put(object, string);
                }
            }
            try {
                TransactFileOutputStream transactFileOutputStream = new TransactFileOutputStream(file, true);
                properties.store(transactFileOutputStream, "YajHFC 0.6.1 (srfax v4) configuration file");
                ((FileOutputStream)transactFileOutputStream).close();
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Couldn't save file '" + file + "': ", exception);
            }
        }
    }

    public static String _(String string) {
        return Utils.getYajHFCLanguage()._(string, string);
    }

    public static String _(String string, String string2) {
        return Utils.getYajHFCLanguage()._(string, string2);
    }

    public static void initializeUIProperties() {
        if (PlatformInfo.IS_MACOSX) {
            MacOSXSupport.setUIProperties();
        }
        AWTExceptionLogger.register();
        Utils.setLookAndFeel(Utils.getFaxOptions().lookAndFeel);
    }

    public static String minutesToHylaTime(int n) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string = decimalFormat.format(n % 60);
        string = decimalFormat.format((n /= 60) % 24) + string;
        string = decimalFormat.format(n /= 24) + string;
        return string;
    }

    public static ImageIcon loadIcon(String string) {
        return Utils.loadGeneralIcon("/toolbarButtonGraphics/" + string + "16.gif");
    }

    public static ImageIcon loadCustomIcon(String string) {
        return Utils.loadGeneralIcon("/yajhfc/images/" + string);
    }

    public static ImageIcon loadGeneralIcon(String string) {
        URL uRL = Utils.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static File getConfigDir() {
        if (configDir == null && !(configDir = Launcher2.cmdLineConfDir == null ? new File(System.getProperty("user.home"), ".yajhfc") : new File(Launcher2.cmdLineConfDir)).exists()) {
            configDir.mkdir();
        }
        return configDir;
    }

    public static String escapeChars(String string, String string2, char c) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuilder.append(c).append(c);
                continue;
            }
            int n = string2.indexOf(c2);
            if (n >= 0) {
                stringBuilder.append(c);
                stringBuilder.append((char)(65 + n));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String unEscapeChars(String string, String string2, char c) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if ((c2 = string.charAt(++i)) == c) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(string2.charAt(c2 - 65));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static void setDefWinPos(Window window) {
        if (PlatformInfo.buggyLocationByPlatform) {
            window.setLocationRelativeTo(null);
        } else {
            window.setLocationByPlatform(true);
        }
    }

    public static boolean setLookAndFeel(String string) {
        try {
            String string2 = string.equals("!system!") ? UIManager.getSystemLookAndFeelClassName() : (string.equals("!crossplatform!") ? UIManager.getCrossPlatformLookAndFeelClassName() : string);
            UIManager.setLookAndFeel(string2);
            return true;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Couldn't load look&feel: " + string + ": ", exception);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception2) {
                log.log(Level.WARNING, "Couldn't load native look&feel: ", exception2);
            }
            return false;
        }
    }

    public static void unsetWaitCursorOnOpen(final Dialog dialog, final Window window) {
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                Utils.unsetWaitCursor(dialog);
                window.removeWindowListener(this);
            }
        });
        if (PlatformInfo.IS_MACOSX) {
            Utils.makeWinAndOwnersVisible(window.getOwner());
        }
    }

    public static void makeWinAndOwnersVisible(Window window) {
        if (window == null) {
            return;
        }
        if (!window.isVisible()) {
            window.setVisible(true);
        }
        Utils.makeWinAndOwnersVisible(window.getOwner());
    }

    public static void setWaitCursor(Dialog dialog) {
        Cursor cursor = Cursor.getPredefinedCursor(3);
        if (dialog != null) {
            dialog.setCursor(cursor);
        }
        for (Frame frame : Frame.getFrames()) {
            frame.setCursor(cursor);
        }
    }

    public static void unsetWaitCursor(Dialog dialog) {
        Cursor cursor = Cursor.getDefaultCursor();
        if (dialog != null) {
            dialog.setCursor(cursor);
        }
        for (Frame frame : Frame.getFrames()) {
            frame.setCursor(cursor);
        }
    }

    public static void enableChildren(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            component.setEnabled(bl);
            if (!(component instanceof Container)) continue;
            Utils.enableChildren((Container)component, bl);
        }
    }

    public static String[] fastSplit(String string, char c) {
        List<String> list = Utils.fastSplitToList(string, c);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> fastSplitToList(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 > -1) {
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        if (n < string.length()) {
            arrayList.add(string.substring(n));
        }
        return arrayList;
    }

    public static String stripQuotes(String string) {
        char c;
        if (string == null || string.length() < 2) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 == (c = string.charAt(string.length() - 1)) && (c2 == '\"' || c2 == '\'')) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static void dumpProperties(Properties properties, Logger logger, Object ... objectArray) {
        ArrayList<String> arrayList = new ArrayList<String>(properties.size());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement().toString());
        }
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator", "\n");
        for (String string2 : arrayList) {
            stringBuilder.append(string2).append('=');
            if (Utils.indexOfPatternArray(objectArray, string2) == -1) {
                stringBuilder.append(properties.getProperty(string2));
            } else {
                String string3 = properties.getProperty(string2);
                if (string3 == null) {
                    stringBuilder.append("null");
                } else {
                    stringBuilder.append('<').append(string3.toString().length()).append(" characters>");
                }
            }
            stringBuilder.append(string);
        }
        logger.config(stringBuilder.toString());
    }

    public static int indexOfArray(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2 != object && (object == null || !object.equals(object2))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfPatternArray(Object[] objectArray, Object object) {
        String string = object == null ? "" : object.toString();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (!(object2 instanceof Pattern ? ((Pattern)object2).matcher(string).matches() : object2 == object || object != null && object.equals(object2))) continue;
            return i;
        }
        return -1;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[8000];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileChannel fileChannel = fileInputStream.getChannel();
        FileChannel fileChannel2 = fileOutputStream.getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static String sanitizeInput(String string) {
        return Utils.sanitizeInput(string, "\r\n", ' ', 255);
    }

    public static String sanitizeInput(String string, String string2, char c, int n) {
        if (string == null) {
            return null;
        }
        if (n > 0 && string.length() > n) {
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (string2.indexOf(cArray[i]) < 0) continue;
            cArray[i] = c;
            bl = true;
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static String stringFilterOut(String string, String string2) {
        return Utils.stringFilterOut(string, string2, 0);
    }

    public static String stringFilterOut(String string, String string2, int n) {
        if (string == null) {
            return null;
        }
        if (n > 0 && string.length() > n) {
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        boolean bl = false;
        for (char c : cArray) {
            if (string2.indexOf(c) < 0) {
                stringBuilder.append(c);
                continue;
            }
            bl = true;
        }
        if (bl) {
            return stringBuilder.toString();
        }
        return string;
    }

    public static int identityIndexOf(List<?> list, Object object) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != object) continue;
            return i;
        }
        return -1;
    }

    public static String shortenFileNameForDisplay(File file, int n) {
        return Utils.shortenFileNameForDisplay(file.getPath(), n);
    }

    public static String shortenFileNameForDisplay(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, 3) + "..." + string.substring(string.length() - n + 6);
        }
        return string;
    }

    public static String shortenStringForDisplay(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    public static String extractExecutableFromCmdLine(String string) {
        int n;
        if ((string = string.trim()).startsWith("\"") && (n = string.indexOf(34, 1)) > 0) {
            return string.substring(1, n);
        }
        n = string.indexOf(32);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static File searchExecutableInPath(String string) {
        String string2 = System.getenv("PATH");
        String[] stringArray = string2 != null ? Utils.fastSplit(string2, File.pathSeparatorChar) : null;
        File file = Utils.searchInPath(stringArray, string);
        if (file != null) {
            return file;
        }
        if (PlatformInfo.IS_WINDOWS) {
            String string3 = System.getenv("PATHEXT");
            String[] stringArray2 = string3 != null ? Utils.fastSplit(string3, File.pathSeparatorChar) : new String[]{".exe", ".com", ".bat", ".pif"};
            for (String string4 : stringArray2) {
                file = Utils.searchInPath(stringArray, string + string4);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    private static File searchInPath(String[] stringArray, String string) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        if (stringArray != null) {
            for (String string2 : stringArray) {
                file = new File(string2, string);
                if (!file.exists()) continue;
                return file;
            }
        }
        return null;
    }

    public static void startViewer(String string, URI uRI) throws IOException {
        Utils.startViewer(string, uRI.toString());
    }

    public static void startViewer(String string, File file) throws IOException {
        Utils.startViewer(string, file.getAbsolutePath());
    }

    private static void startViewer(String string, String string2) throws IOException {
        string = string.indexOf("%s") >= 0 ? string.replace("%s", string2) : string + " \"" + string2 + "\"";
        ExternalProcessExecutor.executeProcess(string);
    }

    public static JLabel addWithLabel(JPanel jPanel, Component component, String string, String string2) {
        return Utils.addWithLabel(jPanel, component, string, new TableLayoutConstraints(string2));
    }

    public static JLabel addWithLabel(JPanel jPanel, Component component, String string, TableLayoutConstraints tableLayoutConstraints) {
        jPanel.add(component, tableLayoutConstraints);
        JLabel jLabel = new JLabel(string);
        jLabel.setLabelFor(component);
        tableLayoutConstraints.row1 = tableLayoutConstraints.row2 = tableLayoutConstraints.row1 - 1;
        tableLayoutConstraints.vAlign = 3;
        tableLayoutConstraints.hAlign = 0;
        jPanel.add((Component)jLabel, tableLayoutConstraints);
        return jLabel;
    }

    public static JLabel addWithLabelHorz(JPanel jPanel, Component component, String string, String string2) {
        return Utils.addWithLabelHorz(jPanel, component, string, new TableLayoutConstraints(string2));
    }

    public static JLabel addWithLabelHorz(JPanel jPanel, Component component, String string, TableLayoutConstraints tableLayoutConstraints) {
        JLabel jLabel = new JLabel(string);
        jLabel.setLabelFor(component);
        jPanel.add(component, tableLayoutConstraints);
        tableLayoutConstraints.col1 = tableLayoutConstraints.col2 = tableLayoutConstraints.col1 - 2;
        tableLayoutConstraints.vAlign = 1;
        tableLayoutConstraints.hAlign = 0;
        jPanel.add((Component)jLabel, tableLayoutConstraints);
        return jLabel;
    }

    public static File getSelectedFileFromSaveChooser(JFileChooser jFileChooser) {
        String string;
        int n;
        File file = jFileChooser.getSelectedFile();
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (fileFilter instanceof ExampleFileFilter && (n = (string = file.getName()).lastIndexOf(46)) < 0) {
            file = new File(file.getParent(), string + '.' + ((ExampleFileFilter)fileFilter).getDefaultExtension());
        }
        return file;
    }

    public static boolean isStringNumeric(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static JPopupMenu clonePopupFromMenu(JMenu jMenu) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 == null) {
                jPopupMenu.addSeparator();
                continue;
            }
            try {
                jMenuItem = (JMenuItem)jMenuItem2.getClass().newInstance();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Error creating JMenuItem", exception);
                jMenuItem = new JMenuItem();
            }
            jMenuItem.setText(jMenuItem2.getText());
            jMenuItem.setIcon(jMenuItem2.getIcon());
            jMenuItem.setSelected(jMenuItem2.isSelected());
            jMenuItem.setActionCommand(jMenuItem2.getActionCommand());
            for (ActionListener actionListener : jMenuItem2.getActionListeners()) {
                jMenuItem.addActionListener(actionListener);
            }
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public static boolean listQuickEquals(List<?> list, List<?> list2) {
        if (list == list2) {
            return true;
        }
        if (list == null || list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static <T> int sortedInsert(List<T> list, T t, Comparator<T> comparator) {
        int n = Collections.binarySearch(list, t, comparator);
        if (n < 0) {
            n = -(n + 1);
        }
        list.add(n, t);
        return n;
    }

    public static void setIconImages(Frame frame, Image ... imageArray) {
        try {
            Method method = Window.class.getMethod("setIconImages", List.class);
            method.invoke((Object)frame, Arrays.asList(imageArray));
        }
        catch (Exception exception) {
            log.log(Level.INFO, "Could not use setIconImages, using Frame.setIconImage instead", exception);
            frame.setIconImage(imageArray[0]);
        }
    }

    public static void setDefaultIcons(Frame frame) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Utils.setIconImages(frame, toolkit.getImage(Utils.class.getResource("icon.png")), toolkit.getImage(Utils.class.getResource("icon-32x32.png")), toolkit.getImage(Utils.class.getResource("icon-48x48.png")), toolkit.getImage(Utils.class.getResource("icon-64x64.png")), toolkit.getImage(Utils.class.getResource("logo-large.png")));
    }

    public static <T> T firstDefined(T t, T t2) {
        return t != null ? t : t2;
    }

    public static <T> T firstDefined(T t, T t2, T t3) {
        if (t != null) {
            return t;
        }
        if (t2 != null) {
            return t2;
        }
        return t3;
    }

    public static String readFully(Reader reader) throws IOException {
        return ArrayCharSequence.readCompletely(reader).toString();
    }

    public static <T> int dedupSortedList(List<T> list) {
        Iterator<T> iterator = list.iterator();
        Object object = null;
        int n = 0;
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (object != null && object.equals(t)) {
                iterator.remove();
                ++n;
            }
            object = t;
        }
        return n;
    }

    static {
        systemwideConfigDirSet = false;
        DEFAULT_LOCALE = Locale.getDefault();
    }
}

