/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import yajhfc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache {
    public static boolean useForNextLogin = true;
    static final Logger log = Logger.getLogger(Cache.class.getName());
    private static final int VERSION = 1;
    protected Map<String, Object> checkData = new HashMap<String, Object>();
    protected Map<String, Object> cachedData;

    public Map<String, Object> getCachedData() {
        if (this.cachedData == null) {
            this.cachedData = new HashMap<String, Object>();
        }
        return this.cachedData;
    }

    public Map<String, Object> getCheckData() {
        return this.checkData;
    }

    public void writeToCache(int n) throws IOException {
        this.writeToCache(Cache.getCacheLocation(n));
    }

    public void writeToCache(File file) throws IOException {
        log.fine("Writing cache to " + file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
        this.writeToCache(bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    public void writeToCache(OutputStream outputStream) throws IOException {
        log.fine("Writing cache version 1");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeInt(1);
        objectOutputStream.writeLong(System.currentTimeMillis());
        objectOutputStream.writeObject(this.checkData);
        objectOutputStream.writeObject(this.cachedData);
        objectOutputStream.flush();
    }

    public boolean readFromCache(int n) throws IOException, ClassNotFoundException {
        return this.readFromCache(Cache.getCacheLocation(n));
    }

    public boolean readFromCache(File file) throws IOException, ClassNotFoundException {
        log.fine("Reading cache from " + file);
        if (!file.canRead()) {
            log.info("Cache file " + file + " does not exist");
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));
        boolean bl = this.readFromCache(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        return bl;
    }

    public boolean readFromCache(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        int n = objectInputStream.readInt();
        if (n > 1) {
            log.info("Cache invalid: Found version " + n + ", expected " + 1);
            return false;
        }
        long l = objectInputStream.readLong();
        log.fine("Reading cache with timestamp " + l + "; now = " + System.currentTimeMillis());
        Map map = (Map)objectInputStream.readObject();
        if (!this.checkData.equals(map)) {
            log.info("Cache invalid: Check data differs");
            if (Utils.debugMode) {
                log.fine("Check data in cache: " + map);
                log.fine("Check data expected: " + this.checkData);
            }
            return false;
        }
        this.cachedData = (Map)objectInputStream.readObject();
        log.fine("Cache successfully loaded.");
        return true;
    }

    public static File getCacheLocation(int n) {
        return new File(Utils.getConfigDir(), "faxlists" + n + ".cache");
    }
}

