/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.customprops;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.customprops.EntryPoint;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.util.ComponentEnabler;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.IntVerifier;
import yajhfc.util.MapEditorDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomPropOptionsPanel
extends AbstractOptionsPanel<FaxOptions> {
    JTextField textHttpProxyHost;
    JTextField textHttpProxyPort;
    JTextField textHttpNonProxyHosts;
    JCheckBox checkUseSystemProxies;
    Action actEditProps;
    Map<String, String> customProps;

    public CustomPropOptionsPanel() {
        super(null);
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        this.customProps = new HashMap<String, String>(EntryPoint.getCustomJavaProperties());
        this.loadUIFromProperties(this.customProps, true);
    }

    private String getProperty(Map<String, String> map, String string, String string2, boolean bl) {
        String string3 = map.get(string);
        if (bl && string3 == null) {
            string3 = System.getProperty(string);
        }
        return string3 == null ? string2 : string3;
    }

    void loadUIFromProperties(Map<String, String> map, boolean bl) {
        this.checkUseSystemProxies.setSelected(Boolean.parseBoolean(this.getProperty(map, "java.net.useSystemProxies", "false", bl)));
        this.textHttpProxyHost.setText(this.getProperty(map, "http.proxyHost", "", bl));
        this.textHttpProxyPort.setText(this.getProperty(map, "http.proxyPort", "", bl));
        this.textHttpNonProxyHosts.setText(this.getProperty(map, "http.nonProxyHosts", "", bl));
    }

    void saveUIToProperties(Map<String, String> map) {
        map.put("java.net.useSystemProxies", Boolean.toString(this.checkUseSystemProxies.isSelected()));
        this.putTextFieldValue(map, this.textHttpProxyHost, "http.proxyHost");
        this.putTextFieldValue(map, this.textHttpProxyPort, "http.proxyPort");
        this.putTextFieldValue(map, this.textHttpNonProxyHosts, "http.nonProxyHosts");
    }

    private void putTextFieldValue(Map<String, String> map, JTextComponent jTextComponent, String string) {
        String string2 = jTextComponent.getText();
        if (string2 == null || string2.length() == 0) {
            map.remove(string);
        } else {
            map.put(string, string2);
        }
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        this.saveUIToProperties(this.customProps);
        Map<String, String> map = EntryPoint.getCustomJavaProperties();
        Properties properties = System.getProperties();
        properties.keySet().removeAll(map.keySet());
        map.clear();
        map.putAll(this.customProps);
        properties.putAll(this.customProps);
    }

    @Override
    protected void createOptionsUI() {
        this.actEditProps = new ExcDialogAbstractAction(Utils._("Define system properties") + "..."){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                CustomPropOptionsPanel.this.saveUIToProperties(CustomPropOptionsPanel.this.customProps);
                MapEditorDialog mapEditorDialog = new MapEditorDialog((Dialog)SwingUtilities.getWindowAncestor(CustomPropOptionsPanel.this), Utils._("Define system properties"), CustomPropOptionsPanel.this.customProps){

                    protected String getCaption() {
                        return Utils._("Here you can define Java system properties. Only do this if you know what you are doing.");
                    }

                    protected String[] getAvailableProperties() {
                        return new String[]{"java.net.useSystemProxies", "http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort", "ftp.proxyHost", "ftp.proxyPort", "ftp.nonProxyHosts", "socksProxyHost", "socksProxyPort"};
                    }
                };
                mapEditorDialog.setVisible(true);
                CustomPropOptionsPanel.this.loadUIFromProperties(CustomPropOptionsPanel.this.customProps, false);
            }
        };
        this.textHttpNonProxyHosts = new JTextField();
        this.textHttpProxyHost = new JTextField();
        this.textHttpProxyPort = new JTextField();
        this.textHttpProxyPort.setInputVerifier(new IntVerifier(1, 65536, true));
        this.checkUseSystemProxies = new JCheckBox(Utils._("Use system proxy settings"));
        ComponentEnabler.installOn(this.checkUseSystemProxies, false, this.textHttpNonProxyHosts, this.textHttpProxyHost, this.textHttpProxyPort);
        double[][] dArrayArray = new double[][]{{5.0, 0.666, 5.0, -1.0, 5.0}, {5.0, -2.0, 5.0, -2.0, -2.0, 5.0, -2.0, -2.0, 5.0, -1.0, -2.0, 5.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.add((Component)this.checkUseSystemProxies, "1,1,3,1,l,c");
        Utils.addWithLabel((JPanel)this, (Component)this.textHttpProxyHost, Utils._("HTTP proxy server") + ":", "1,4");
        Utils.addWithLabel((JPanel)this, (Component)this.textHttpProxyPort, Utils._("HTTP proxy port") + ":", "3,4");
        Utils.addWithLabel((JPanel)this, (Component)this.textHttpNonProxyHosts, Utils._("HTTP non proxy hosts") + ":", "1,7,3,7");
        this.add((Component)new JButton(this.actEditProps), "1,10,3,10,f,f");
    }
}

