/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.export;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import yajhfc.MainWin;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.IconMap;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.FaxJobList;
import yajhfc.util.ProgressWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportXMLAction {
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void exportToXML(final MainWin mainWin, final File file) {
        Utils.setWaitCursor(null);
        final FaxJobList<? extends FmtItem> faxJobList = mainWin.getSelectedTable().getRealModel().getJobs();
        ProgressWorker progressWorker = new ProgressWorker(){

            protected void initialize() {
                this.progressMonitor = mainWin.getTablePanel();
            }

            public void doWork() {
                try {
                    this.updateNote(Utils._("Exporting..."));
                    StreamResult streamResult = new StreamResult(file);
                    ExportXMLAction.saveToResult(streamResult, faxJobList);
                }
                catch (Exception exception) {
                    this.dialogs.showExceptionDialog(Utils._("Error saving the table:"), exception);
                }
            }

            protected void done() {
                Utils.unsetWaitCursor(null);
            }
        };
        progressWorker.startWork(mainWin, Utils._("Export to XML"));
    }

    protected static void saveToResult(Result result, FaxJobList<? extends FmtItem> faxJobList) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("faxlist");
        element.setAttribute("xmlns", "http://yajhfc.de/schema/tableexport");
        element.setAttribute("tableType", faxJobList.getJobType().name());
        Element element2 = document.createElement("columns");
        ExportXMLAction.saveColumns(faxJobList.getColumns(), element2, document);
        element.appendChild(element2);
        element2 = document.createElement("contents");
        ExportXMLAction.saveRows(faxJobList, element2, document);
        element.appendChild(element2);
        document.appendChild(element);
        element.normalize();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, result);
    }

    protected static void saveRows(FaxJobList<? extends FmtItem> faxJobList, Element element, Document document) {
        List<? extends FmtItem> list = faxJobList.getColumns().getCompleteView();
        for (FaxJob<? extends FmtItem> faxJob : faxJobList.getJobs()) {
            Element element2 = document.createElement("row");
            element2.setAttribute("id", faxJob.getIDValue().toString());
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Element element3 = document.createElement("cell");
                Class<?> clazz = list.get(i).getDataType();
                if (Date.class.isAssignableFrom(clazz)) {
                    object = (Date)faxJob.getData(i);
                    element3.setAttribute("rawValue", String.valueOf(object == null ? Long.MIN_VALUE : ((Date)object).getTime()));
                    element3.setTextContent(object == null ? "" : DATE_FORMAT.format((Date)object));
                } else {
                    object = faxJob.getData(i);
                    element3.setTextContent(object == null ? "" : object.toString());
                }
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    protected static void saveColumns(FmtItemList<? extends FmtItem> fmtItemList, Element element, Document document) {
        int n = fmtItemList.size();
        List<? extends FmtItem> list = fmtItemList.getCompleteView();
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = document.createElement("column");
            FmtItem fmtItem = list.get(i);
            element2.setTextContent(fmtItem.getDescription());
            element2.setAttribute("name", fmtItem.name());
            element2.setAttribute("longDescription", fmtItem.getLongDescription());
            element2.setAttribute("visible", String.valueOf(i < n));
            String string = IconMap.class.isAssignableFrom(fmtItem.getDataType()) ? "String" : fmtItem.getDataType().getSimpleName();
            element2.setAttribute("dataType", string);
            element.appendChild(element2);
        }
    }
}

