/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.export;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import yajhfc.DateKind;
import yajhfc.Utils;
import yajhfc.export.ImageExportManager;
import yajhfc.model.IconMap;

public class HTMLExporter {
    protected String systemID = "http://www.w3.org/TR/html4/strict.dtd";
    protected String docTypePublic = "-//W3C//DTD HTML 4.01//EN";
    protected String outputMethod = "html";
    protected String headerBackground = "#DADADA";
    protected String[] columnBackground = new String[]{null, "#F0F0F0"};
    protected boolean exportImages = true;

    public String getSystemID() {
        return this.systemID;
    }

    public String getDocTypePublic() {
        return this.docTypePublic;
    }

    public String getOutputMethod() {
        return this.outputMethod;
    }

    public void setSystemID(String string) {
        this.systemID = string;
    }

    public void setDocTypePublic(String string) {
        this.docTypePublic = string;
    }

    public void setOutputMethod(String string) {
        this.outputMethod = string;
    }

    public String getHeaderBackground() {
        return this.headerBackground;
    }

    public String[] getColumnBackground() {
        return this.columnBackground;
    }

    public void setHeaderBackground(String string) {
        this.headerBackground = string;
    }

    public void setColumnBackground(String[] stringArray) {
        this.columnBackground = stringArray;
    }

    public void setExportImages(boolean bl) {
        this.exportImages = bl;
    }

    public boolean isExportImages() {
        return this.exportImages;
    }

    public void saveToFile(File file, TableModel tableModel, String string, String string2) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        ImageExportManager imageExportManager = this.exportImages ? new ImageExportManager(file) : null;
        DocumentType documentType = dOMImplementation.createDocumentType("html", this.docTypePublic, this.systemID);
        Document document = dOMImplementation.createDocument(null, "html", documentType);
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("head");
        Element element3 = document.createElement("title");
        element3.setTextContent(string);
        element2.appendChild(element3);
        element.appendChild(element2);
        Element element4 = document.createElement("body");
        Element element5 = document.createElement("h1");
        element5.setTextContent(string);
        element4.appendChild(element5);
        this.appendTable(document, element4, tableModel, null, imageExportManager);
        element4.appendChild(document.createElement("hr"));
        Element element6 = document.createElement("p");
        Text text = document.createTextNode(string2);
        Text text2 = document.createTextNode(MessageFormat.format(Utils._("List saved at {0}."), DateKind.DATE_AND_TIME.getFormat().format(new Date())));
        Element element7 = document.createElement("a");
        element7.setAttribute("href", "http://www.yajhfc.de/");
        element7.setTextContent("YajHFC 0.6.1 (srfax v4)");
        element6.appendChild(text);
        element6.appendChild(document.createElement("br"));
        element6.appendChild(text2);
        element6.appendChild(document.createElement("br"));
        element6.appendChild(element7);
        element4.appendChild(element6);
        element.appendChild(element4);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("doctype-public", this.docTypePublic);
        transformer.setOutputProperty("doctype-system", this.systemID);
        transformer.setOutputProperty("method", this.outputMethod);
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(file);
        transformer.transform(dOMSource, streamResult);
    }

    protected void appendTable(Document document, Element element, TableModel tableModel, String string, ImageExportManager imageExportManager) {
        Element element2 = document.createElement("table");
        Element element3 = document.createElement("thead");
        if (string == null) {
            string = "background-color:" + this.headerBackground + ";";
        }
        element3.setAttribute("style", string);
        Element element4 = document.createElement("tr");
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            Element element5 = document.createElement("th");
            element5.setTextContent(tableModel.getColumnName(i));
            element4.appendChild(element5);
        }
        element3.appendChild(element4);
        element2.appendChild(element3);
        Element element6 = document.createElement("tbody");
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            element4 = document.createElement("tr");
            String string2 = this.columnBackground[i % this.columnBackground.length];
            if (string2 != null) {
                element4.setAttribute("style", "background-color:" + string2 + ";");
            }
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                Node node = this.createTDElement(document, tableModel, i, j, imageExportManager);
                if (node == null) continue;
                element4.appendChild(node);
            }
            element6.appendChild(element4);
        }
        element2.appendChild(element6);
        element.appendChild(element2);
    }

    protected Node createTDElement(Document document, TableModel tableModel, int n, int n2, ImageExportManager imageExportManager) {
        String string;
        Object object;
        String string2;
        Object object2 = tableModel.getValueAt(n, n2);
        Element element = null;
        if (object2 instanceof Date) {
            string2 = this.getDateFormat(tableModel, n2).format(object2);
        } else if (object2 instanceof Boolean) {
            string2 = (Boolean)object2 != false ? "X" : " ";
        } else if (object2 instanceof IconMap) {
            object = (IconMap)object2;
            if (imageExportManager != null) {
                string2 = " " + object.getText();
                string = imageExportManager.getRelativePathFor(object.getDisplayIcon().getImage());
                if (string != null) {
                    Element element2 = document.createElement("img");
                    element2.setAttribute("alt", object.getText());
                    element2.setAttribute("src", string);
                    element = element2;
                }
            } else {
                string2 = object.getText();
            }
        } else {
            string2 = object2 != null ? object2.toString() : "";
        }
        object = object2 instanceof Number ? "right" : (object2 instanceof Boolean ? "center" : null);
        string = this.getCSSStyle(tableModel, n, n2);
        return this.createTDElement(document, string2, (String)object, string, element);
    }

    protected Node createTDElement(Document document, String string, String string2, String string3, Node node) {
        Element element = document.createElement("td");
        if (string2 != null) {
            element.setAttribute("align", string2);
        }
        if (string3 != null) {
            element.setAttribute("style", string3);
        }
        if (node != null) {
            element.appendChild(node);
        }
        if (string.indexOf(10) < 0) {
            element.appendChild(document.createTextNode(string));
        } else {
            for (String string4 : Utils.fastSplit(string, '\n')) {
                element.appendChild(document.createTextNode(string4));
                element.appendChild(document.createElement("br"));
            }
        }
        return element;
    }

    protected DateFormat getDateFormat(TableModel tableModel, int n) {
        return DateFormat.getDateTimeInstance();
    }

    protected Color getCellBackground(TableModel tableModel, int n, int n2) {
        return null;
    }

    protected Color getCellForeground(TableModel tableModel, int n, int n2) {
        return null;
    }

    protected Font getFont(TableModel tableModel, int n, int n2) {
        return null;
    }

    protected String getCSSStyle(TableModel tableModel, int n, int n2) {
        Color color = this.getCellBackground(tableModel, n, n2);
        Color color2 = this.getCellForeground(tableModel, n, n2);
        Font font = this.getFont(tableModel, n, n2);
        if (color == null && color2 == null && font == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (color != null) {
            stringBuilder.append("background-color:#");
            stringBuilder.append(Integer.toHexString(color.getRGB() & 0xFFFFFF));
            stringBuilder.append(';');
        }
        if (color2 != null) {
            stringBuilder.append("color:#");
            stringBuilder.append(Integer.toHexString(color2.getRGB() & 0xFFFFFF));
            stringBuilder.append(';');
        }
        if (font != null) {
            int n3 = font.getStyle();
            if ((n3 & 1) != 0) {
                stringBuilder.append("font-weight: bold;");
            }
            if ((n3 & 2) != 0) {
                stringBuilder.append("font-style: italic;");
            }
        }
        return stringBuilder.toString();
    }
}

