/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.export;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import yajhfc.Utils;

public class ImageExportManager {
    private static final Logger log = Logger.getLogger(ImageExportManager.class.getName());
    private final String outFormat = "png";
    protected final Map<Image, String> imageCache = new HashMap<Image, String>();
    protected final File htmlDoc;
    protected File outDir;
    protected int imageCounter = 0;

    public String getRelativePathFor(Image image) {
        String string = this.imageCache.get(image);
        if (string == null) {
            String string2 = String.format("image%05d.%s", this.imageCounter++, "png");
            File file = this.getOutputDir();
            RenderedImage renderedImage = this.getRenderedImageFor(image);
            try {
                ImageIO.write(renderedImage, "png", new File(file, string2));
                string = file.getName() + '/' + string2;
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Error exporting image " + string2 + " to " + file, iOException);
                string = "";
            }
            this.imageCache.put(image, string);
        }
        return string == "" ? null : string;
    }

    protected RenderedImage getRenderedImageFor(Image image) {
        if (image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    protected File getOutputDir() {
        if (this.outDir == null) {
            String string;
            File file;
            File file2 = this.htmlDoc.getParentFile();
            String string2 = this.htmlDoc.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            int n2 = 1;
            MessageFormat messageFormat = new MessageFormat(Utils._("{0}-files") + "{1,choice,1#|1< ({1,number,integer})}");
            while ((file = new File(file2, string = messageFormat.format(new Object[]{string2, n2++}))).exists()) {
            }
            file.mkdir();
            this.outDir = file;
        }
        return this.outDir;
    }

    public void resetCache() {
        this.imageCache.clear();
        this.imageCounter = 0;
        this.outDir = null;
    }

    public ImageExportManager(File file) {
        this.htmlDoc = file;
    }
}

