/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.faxcover;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import yajhfc.faxcover.Faxcover;
import yajhfc.phonebook.PBEntryField;

class FaxcoverHyla
extends Faxcover {
    protected int maxcomments = 20;
    protected int maxlencomments = 35;
    private BufferedWriter wOut = null;
    static final String prologue = "/wordbreak ( ) def\n/linebreak (\\n) def\n/doLine {\n% <line> <width> <height> <x> <y> doLine <width> <height> <x> <y>\n    2 copy moveto 5 -1 roll\n    wordbreak\n    {\n        search {\n            dup stringwidth pop currentpoint pop add 7 index 6 index add gt {\n                6 3 roll 2 index sub 2 copy moveto 6 3 roll\n            } if\n            show wordbreak show\n        }{\n            dup stringwidth pop currentpoint pop add 5 index 4 index add gt {\n                3 1 roll 3 index sub 2 copy moveto 3 -1 roll\n            } if\n            show exit\n        } ifelse\n    } loop\n    2 index sub 2 copy moveto\n} def\n/BreakIntoLines {\n% <width> <height> <x> <y> <text> BreakIntoLines\n    linebreak\n    {\n         search {\n             7 3 roll doLine 6 -2 roll\n         }{\n             5 1 roll doLine exit\n         } ifelse\n    } loop\n    pop pop pop pop\n} def\n/BreakIntoCommentX {\n% <maxlines> <text> BreakIntoCommentX -\n    /cbuf (Comment ) def\n    0 exch\n    linebreak { search { 4 -1 roll 1 add 4 2 roll }{ exch 1 add exit } ifelse } loop\n    dup dup 2 add 1 roll\n    -1 1 { cbuf exch 7 exch 48 add put cbuf cvn exch def } for\n    1 add exch 1 exch { cbuf exch 7 exch 48 add put cbuf cvn () def } for\n} def\n/XtoCommentsX {\n% <X> XtoCommentsX <commentsX>\n    3 string cvs (comments) dup length dup 4 1 roll\n    2 index length add string dup 0 4 -1 roll\n    putinterval dup 4 -2 roll putinterval\n} def\n/BreakIntoCommentsX {\n% <maxlines> <text> BreakIntoCommentsX -\n    exch 1 1 3 2 roll\n    { XtoCommentsX cvn () def } for\n    dup length string copy 0 1 index 0 4 1 roll\n    {   linebreak 0 get eq {\n            exch dup 0 3 index getinterval 4 -1 roll 1 add dup 5 1 roll\n            XtoCommentsX cvn exch def dup length 2 index sub 1 sub\n            2 index 1 add exch getinterval exch pop 0\n        }{ 1 add } ifelse\n        dup MaxLenComments gt {\n            exch MaxLenComments 1 sub -1 0 {\n                2 copy get wordbreak 0 get eq {\n                    mark 4 1 roll\n                    {   2 copy 1 add 1 index length 1 index 1 add sub\n                        getinterval 5 -1 roll search { 3 -2 roll pop pop } if\n                        length MaxLenComments gt { 4 -1 roll exec\n                        }{ false } ifelse\n                    }\n                    { true }\n                    5 1 roll linebreak 1 index wordbreak 7 3 roll exec\n                    counttomark 1 add 4 roll cleartomark { pop exit } if\n                    2 copy 1 add 0 exch getinterval 5 -1 roll\n                    1 add dup 6 1 roll XtoCommentsX cvn exch def\n                    2 copy 1 add 1 index length 1 index sub getinterval\n                    3 -1 roll pop 3 -2 roll 1 add sub exch exit\n                } if\n                pop\n            } for\n            exch dup MaxLenComments gt {\n                pop dup 0 MaxLenComments getinterval 3 -1 roll\n                1 add dup 4 1 roll XtoCommentsX cvn exch def\n                dup length MaxLenComments sub\n                MaxLenComments exch getinterval 1\n            } if\n        }if\n    } forall\n    pop exch 1 add XtoCommentsX cvn exch def\n} def\n";

    public void makeCoverSheet(OutputStream outputStream) throws IOException {
        int n;
        this.wOut = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO8859-1"));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.coverTemplate.openStream(), "ISO8859-1"));
        this.wOut.write("%!PS-Adobe-2.0 EPSF-2.0\n");
        this.wOut.write("%%Creator: faxcover\n");
        this.wOut.write("%%Title: HylaFAX Cover Sheet\n");
        this.wOut.write("%%CreationDate: " + new Date().toString() + "\n");
        this.wOut.write("%%Origin: 0 0\n");
        this.wOut.write(String.format(Locale.US, "%%%%BoundingBox: 0 0 %.0f %.0f\n", (double)this.pageSize.getSize().width / 25.4 * 72.0, (double)this.pageSize.getSize().height / 25.4 * 72.0));
        this.wOut.write("%%Pages: 1 +1\n");
        this.wOut.write("%%EndComments\n");
        this.wOut.write("%%BeginProlog\n");
        this.wOut.write(String.format(Locale.US, "%d dict begin\n", this.maxcomments * 2 + 80));
        this.wOut.write(prologue);
        this.emitToDefs();
        this.wOut.write(String.format(Locale.US, "/pageWidth %d def\n", this.pageSize.getSize().width));
        this.wOut.write(String.format(Locale.US, "/pageLength %d def\n", this.pageSize.getSize().height));
        this.emitFromDefs();
        this.coverDef("page-count", String.valueOf(this.pageCount));
        this.emitDateDefs();
        this.coverDef("regarding", this.regarding);
        this.emitCommentDefs();
        this.wOut.write(String.format(Locale.US, "/MaxComments %d def\n", this.maxcomments));
        this.wOut.write("MaxComments comments BreakIntoCommentX\n");
        this.wOut.write(String.format(Locale.US, "/MaxLenComments %d def\n", this.maxlencomments));
        this.wOut.write("MaxComments comments BreakIntoCommentsX\n");
        this.wOut.write("%%EndProlog\n");
        this.wOut.write("%%Page: \"1\" 1\n");
        char[] cArray = new char[8100];
        do {
            if ((n = bufferedReader.read(cArray)) <= 0) continue;
            this.wOut.write(cArray, 0, n);
        } while (n >= 0);
        this.wOut.write("\nend\n");
        bufferedReader.close();
        this.wOut.close();
    }

    private void emitToDefs() throws IOException {
        this.coverDef("to", this.nameRule.applyRule(this.toData));
        this.coverDef("to-company", this.companyRule.applyRule(this.toData));
        this.coverDef("to-location", this.locationRule.applyRule(this.toData));
        this.coverDef("to-voice-number", this.toData.getField(PBEntryField.VoiceNumber));
        this.coverDef("to-fax-number", this.toData.getField(PBEntryField.FaxNumber));
    }

    private void emitFromDefs() throws IOException {
        this.coverDef("from", this.nameRule.applyRule(this.fromData));
        this.coverDef("from-fax-number", this.fromData.getField(PBEntryField.FaxNumber));
        this.coverDef("from-voice-number", this.fromData.getField(PBEntryField.VoiceNumber));
        this.coverDef("from-company", this.companyRule.applyRule(this.fromData));
        this.coverDef("from-location", this.locationRule.applyRule(this.fromData));
        this.coverDef("from-mail-address", this.fromData.getField(PBEntryField.EMailAddress));
    }

    private void emitCommentDefs() throws IOException {
        this.coverDef("comments", this.comments);
    }

    private void emitDateDefs() throws IOException {
        this.coverDef("todays-date", this.dateFmt.format(this.coverDate));
    }

    private void coverDef(String string, String string2) throws IOException {
        this.wOut.write(47);
        this.wOut.write(string);
        this.wOut.write(" (");
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '(' || c == ')' || c == '\\') {
                this.wOut.write(92);
            }
            this.wOut.write(c);
        }
        this.wOut.write(") def\n");
    }

    public FaxcoverHyla(URL uRL) {
        super(uRL);
    }
}

