/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.faxcover;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import yajhfc.faxcover.Faxcover;
import yajhfc.faxcover.tag.ConditionState;
import yajhfc.faxcover.tag.Tag;
import yajhfc.file.FileConverter;

public abstract class MarkupFaxcover
extends Faxcover {
    static final Logger log = Logger.getLogger(MarkupFaxcover.class.getName());
    protected boolean encodeNonASCIIAsEntity = false;
    protected String newLineReplacement = "\n";
    protected String aposReplacement = "&apos;";
    protected String encoding = "utf-8";
    public static final int MAXTAGLENGTH = 300;
    public static final char TAGCHAR = '@';

    public MarkupFaxcover(URL uRL) {
        super(uRL);
    }

    public void makeCoverSheet(OutputStream outputStream) throws IOException {
        try {
            this.createCoverSheet(this.coverTemplate.openStream(), outputStream);
        }
        catch (FileConverter.ConversionException conversionException) {
            throw new RuntimeException(conversionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCoverSheet(InputStream inputStream, OutputStream outputStream) throws IOException, FileConverter.ConversionException {
        File file = null;
        try {
            file = File.createTempFile("cover", ".tmp");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.encoding);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding);
            this.replaceTags(inputStreamReader, outputStreamWriter);
            ((Reader)inputStreamReader).close();
            ((Writer)outputStreamWriter).close();
            this.convertMarkupToHyla(file, outputStream);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    protected abstract void convertMarkupToHyla(File var1, OutputStream var2) throws IOException, FileConverter.ConversionException;

    protected void replaceTags(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[8000];
        ArrayList<ConditionState> arrayList = new ArrayList<ConditionState>();
        int n2 = 0;
        writer = new BufferedWriter(writer);
        do {
            int n3 = cArray.length - n2;
            n = reader.read(cArray, n2, n3);
            int n4 = -1;
            int n5 = 0;
            int n6 = (n < 0 ? 0 : n) + n2;
            for (int i = 0; i < n6; ++i) {
                if (cArray[i] != '@' || i + 1 >= n6 || cArray[i + 1] != '@') continue;
                if (n4 != -1 && i - n4 < 300) {
                    String string;
                    String string2;
                    String string3 = new String(cArray, n4, i - n4).toLowerCase();
                    int n7 = string3.indexOf(58);
                    if (n7 > 0) {
                        string2 = string3.substring(0, n7);
                        string = string3.substring(n7 + 1);
                    } else {
                        string2 = string3;
                        string = null;
                    }
                    Tag tag = Tag.availableTags.get(string2);
                    if (tag == null) {
                        n4 = i + 2;
                        ++i;
                        continue;
                    }
                    String string4 = tag.getValue(this, arrayList, string);
                    if (string4 == null) {
                        string4 = "";
                    }
                    writer.write(cArray, n5, n4 - n5 - 2);
                    if (tag.valueIsRaw()) {
                        writer.write(string4);
                    } else {
                        block10: for (int j = 0; j < string4.length(); ++j) {
                            char c = string4.charAt(j);
                            switch (c) {
                                case '&': {
                                    writer.write("&amp;");
                                    continue block10;
                                }
                                case '<': {
                                    writer.write("&lt;");
                                    continue block10;
                                }
                                case '>': {
                                    writer.write("&gt;");
                                    continue block10;
                                }
                                case '\"': {
                                    writer.write("&quot;");
                                    continue block10;
                                }
                                case '\'': {
                                    writer.write(this.aposReplacement);
                                    continue block10;
                                }
                                case '\n': {
                                    writer.write(this.newLineReplacement);
                                    continue block10;
                                }
                                default: {
                                    if (this.encodeNonASCIIAsEntity) {
                                        if (c <= '\u007f') {
                                            writer.write(c);
                                            continue block10;
                                        }
                                        writer.write("&#" + c + ";");
                                        continue block10;
                                    }
                                    writer.write(c);
                                }
                            }
                        }
                    }
                    n5 = i += 2;
                    n4 = -1;
                    continue;
                }
                n4 = i + 2;
                ++i;
            }
            n2 = n < 0 ? 0 : (n4 >= 0 && n6 - n4 < 304 ? n6 - n4 + 2 : Math.min(2, n6 - n5));
            writer.write(cArray, n5, n6 - n2 - n5);
            if (n2 <= 0) continue;
            System.arraycopy(cArray, n6 - n2, cArray, 0, n2);
        } while (n >= 0);
        writer.close();
        if (arrayList.size() > 0) {
            log.warning("Found " + arrayList.size() + " if tags without an @@ENDIF@@!");
        }
    }
}

