/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FileFormat;
import yajhfc.file.StdErrThread;
import yajhfc.util.ExternalProcessExecutor;

public class ExternalProcessConverter
implements FileConverter {
    private static final Logger log = Logger.getLogger(ExternalProcessConverter.class.getName());
    protected String commandLine;
    protected final FileConverter internalConverter;

    public void convertToHylaFormat(File file, OutputStream outputStream, PaperSize paperSize, FileFormat fileFormat) throws FileConverter.ConversionException, IOException {
        String string = this.addArgument(this.commandLine, "%p", paperSize.name(), false);
        string = this.addArgument(string, "%h", paperSize.getSize().height, false);
        string = this.addArgument(string, "%w", paperSize.getSize().width, false);
        string = this.addArgument(string, "%F", fileFormat.name(), false);
        string = this.addArgument(string, "%s", file.getAbsolutePath(), true);
        List<String> list = ExternalProcessExecutor.splitCommandLine(string);
        ExternalProcessExecutor.quoteCommandLine(list);
        if (Utils.debugMode) {
            log.fine("Invoking " + list.get(0) + " with the following command line:");
            for (String object2 : list) {
                log.fine(object2);
            }
        }
        Process process = new ProcessBuilder(list).start();
        StdErrThread stdErrThread = new StdErrThread(list.get(0), process.getErrorStream());
        InputStream inputStream = process.getInputStream();
        Utils.copyStream(inputStream, outputStream);
        process.getOutputStream().close();
        try {
            int interruptedException = process.waitFor();
            if (interruptedException != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                if (interruptedException != 111) {
                    stringBuilder.append("Non-zero exit code of ").append(list.get(0)).append(" (").append(interruptedException).append("):\n");
                }
                for (String string2 : stdErrThread.getTail()) {
                    stringBuilder.append(string2).append('\n');
                }
                throw new FileConverter.ConversionException(stringBuilder.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new FileConverter.ConversionException(interruptedException);
        }
    }

    private String addArgument(String string, String string2, Object object, boolean bl) {
        if (string.contains(string2)) {
            return string.replace(string2, object.toString());
        }
        if (bl) {
            return string + " \"" + object + '\"';
        }
        return string;
    }

    public boolean isOverridable() {
        return true;
    }

    public FileConverter getInternalConverter() {
        return this.internalConverter;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public boolean isUserDefined() {
        return true;
    }

    public ExternalProcessConverter(String string, FileConverter fileConverter) {
        this.commandLine = string;
        this.internalConverter = fileConverter;
    }

    public String toString() {
        return this.getClass().getName() + "[commandLine=" + this.commandLine + ";internalConverter=" + this.internalConverter + "]";
    }
}

