/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FormattedFile;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.file.MultiFileConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCache {
    static final Logger log = Logger.getLogger(FileCache.class.getName());
    protected final Map<List<FormattedFile>, ConvFileInfo> cache = new HashMap<List<FormattedFile>, ConvFileInfo>();

    public synchronized void addToCache(List<FormattedFile> list, File file, PaperSize paperSize) {
        this.cache.put(list, new ConvFileInfo(list, file, paperSize));
        Cleaner.checkInstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File checkCache(List<FormattedFile> list, PaperSize paperSize) {
        ConvFileInfo convFileInfo = this.cache.get(list);
        if (convFileInfo != null) {
            log.fine("Found file in cache...");
            if (paperSize.equals((Object)convFileInfo.paperSize) && convFileInfo.checkValid()) {
                log.fine("File is valid.");
                return convFileInfo.file;
            }
            log.fine("File is invalid, removing it.");
            FileCache fileCache = this;
            synchronized (fileCache) {
                this.cache.remove(list);
            }
            return null;
        }
        log.fine("Found nothing in cache.");
        return null;
    }

    public synchronized void validateCache() {
        if (this.cache.size() > 0) {
            Iterator<Map.Entry<List<FormattedFile>, ConvFileInfo>> iterator = this.cache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<List<FormattedFile>, ConvFileInfo> entry = iterator.next();
                if (entry.getValue().checkValid()) continue;
                iterator.remove();
            }
        }
    }

    public static class Cleaner
    implements Runnable {
        private static final long FREQUENCY = 31L;
        private static boolean INSTALLED = false;

        public void run() {
            try {
                log.fine("Validating caches...");
                for (MultiFileConvFormat multiFileConvFormat : MultiFileConvFormat.values()) {
                    MultiFileConverter multiFileConverter = multiFileConvFormat.getConverter();
                    if (multiFileConverter.cache == null) continue;
                    multiFileConverter.cache.validateCache();
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error cleaning caches", exception);
            }
        }

        public static synchronized void checkInstall() {
            if (!INSTALLED) {
                log.fine("Installing global cache cleaner...");
                Utils.executorService.scheduleWithFixedDelay(new Cleaner(), 31L, 31L, TimeUnit.SECONDS);
                INSTALLED = true;
            }
        }
    }

    public static class FileInfo {
        public final File file;
        public long size;
        public long timestamp;

        protected void readFileInfo() {
            this.size = this.file.length();
            this.timestamp = this.file.lastModified();
        }

        public boolean checkValid() {
            return this.file.exists() && this.file.length() == this.size && this.file.lastModified() == this.timestamp;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FileInfo) {
                return this.file.equals(((FileInfo)object).file);
            }
            return false;
        }

        public FileInfo(File file) {
            this.file = file;
            this.readFileInfo();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConvFileInfo
    extends FileInfo {
        public final List<FileInfo> sourceFiles = new ArrayList<FileInfo>();
        public final PaperSize paperSize;

        @Override
        public boolean checkValid() {
            if (!super.checkValid()) {
                return false;
            }
            for (FileInfo fileInfo : this.sourceFiles) {
                if (fileInfo.checkValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.sourceFiles.hashCode() ^ this.paperSize.hashCode() ^ this.file.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ConvFileInfo) {
                ConvFileInfo convFileInfo = (ConvFileInfo)object;
                return this.paperSize.equals((Object)convFileInfo.paperSize) && this.file.equals(convFileInfo.file) && this.sourceFiles.equals(convFileInfo.sourceFiles);
            }
            return false;
        }

        public ConvFileInfo(List<FormattedFile> list, File file, PaperSize paperSize) {
            super(file);
            this.paperSize = paperSize;
            for (FormattedFile formattedFile : list) {
                this.sourceFiles.add(new FileInfo(formattedFile.file));
            }
        }
    }
}

