/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import yajhfc.file.DefaultConvertersSource;
import yajhfc.file.FileConverter;
import yajhfc.file.FileConverterSource;
import yajhfc.file.FileFormat;
import yajhfc.file.UserDefinedConvertersSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileConverters {
    private static final List<FileConverterSource> sources = new ArrayList<FileConverterSource>();
    private static Map<FileFormat, FileConverter> fileConverters;
    private static FileFilter[] acceptedFilters;

    public static synchronized void addFileConverterSource(FileConverterSource fileConverterSource) {
        sources.add(fileConverterSource);
        FileConverters.invalidateFileConverters();
    }

    public static synchronized void removeFileConverterSource(FileConverterSource fileConverterSource) {
        sources.remove(fileConverterSource);
        FileConverters.invalidateFileConverters();
    }

    public static void invalidateFileConverters() {
        fileConverters = null;
        acceptedFilters = null;
    }

    public static FileConverter getConverterFor(FileFormat fileFormat) {
        return FileConverters.getFileConverters().get((Object)fileFormat);
    }

    public static synchronized Map<FileFormat, FileConverter> getFileConverters() {
        if (fileConverters == null) {
            EnumMap<FileFormat, FileConverter> enumMap = new EnumMap<FileFormat, FileConverter>(FileFormat.class);
            Collections.sort(sources);
            for (FileConverterSource fileConverterSource : sources) {
                fileConverterSource.addFileConvertersTo(enumMap);
            }
            fileConverters = Collections.unmodifiableMap(enumMap);
        }
        return fileConverters;
    }

    public static FileFilter[] getConvertableFileFilters() {
        if (acceptedFilters == null) {
            acceptedFilters = FileFormat.createFileFiltersFromFormats(FileConverters.getFileConverters().keySet());
        }
        return acceptedFilters;
    }

    static {
        FileConverters.addFileConverterSource(new DefaultConvertersSource());
        FileConverters.addFileConverterSource(new UserDefinedConvertersSource());
        fileConverters = null;
    }
}

