/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yajhfc.util.ArrayCharSequence;

public class FileUtils {
    private static Logger log = Logger.getLogger(FileUtils.class.getName());

    public static String extractTitleFromPSFile(File file) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "ISO8859-1");
        char[] cArray = new char[4000];
        int n = inputStreamReader.read(cArray);
        ((Reader)inputStreamReader).close();
        Pattern pattern = Pattern.compile("^%%Title:\\s*(.+)$", 10);
        ArrayCharSequence arrayCharSequence = new ArrayCharSequence(cArray, 0, n);
        String string = null;
        Matcher matcher = pattern.matcher(arrayCharSequence);
        if (matcher.find()) {
            string = matcher.group(1);
            string = FileUtils.decodePSString(string);
        }
        return string;
    }

    public static String decodePSString(String string) {
        if ((string = string.trim()).length() == 0) {
            return string;
        }
        if (string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            string = string.substring(1, string.length() - 1);
            Pattern pattern = Pattern.compile("\\\\(?:(\\d{3})|(.))");
            Matcher matcher = pattern.matcher(string);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (matcher.find(n)) {
                stringBuilder.append(string.substring(n, matcher.start()));
                if (matcher.group(2) != null) {
                    char c = matcher.group(2).charAt(0);
                    switch (c) {
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': {
                            stringBuilder.append(' ');
                            break;
                        }
                        case 't': {
                            stringBuilder.append("    ");
                            break;
                        }
                        default: {
                            stringBuilder.append(c);
                            break;
                        }
                    }
                } else if (matcher.group(1) != null) {
                    try {
                        int n2 = Integer.valueOf(matcher.group(1), 8);
                        if (n2 < 0 || n2 > 255) {
                            log.fine("Invalid codepoint: " + n2);
                            stringBuilder.append('?');
                        } else {
                            stringBuilder.append(FileUtils.decode_ISO_8859_1(n2));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.fine("Invalid octal code: " + matcher.group(1));
                        stringBuilder.append('#');
                    }
                }
                n = matcher.end();
            }
            if (n < string.length()) {
                stringBuilder.append(string.substring(n));
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static char decode_ISO_8859_1(int n) {
        return ISO8859_1_Table.DECODE_TABLE[n];
    }

    public static void main(String[] stringArray) throws Exception {
        File[] fileArray;
        for (File file : fileArray = new File("/home/jonas/java/yajhfc/extracttitle").listFiles()) {
            System.out.println("" + file + ": " + FileUtils.extractTitleFromPSFile(file));
        }
    }

    private static class ISO8859_1_Table {
        public static final char[] DECODE_TABLE;

        private ISO8859_1_Table() {
        }

        static {
            byte[] byArray = new byte[256];
            for (int i = 0; i < 256; ++i) {
                byArray[i] = (byte)i;
            }
            CharBuffer charBuffer = Charset.forName("ISO8859-1").decode(ByteBuffer.wrap(byArray));
            DECODE_TABLE = new char[256];
            charBuffer.get(DECODE_TABLE);
        }
    }
}

