/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yajhfc.DesktopManager;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.file.UnknownFormatException;
import yajhfc.shutdown.ShutdownManager;

public class FormattedFile {
    public final File file;
    protected FileFormat format = null;
    private static final short[] JPEGSignature;
    private static final short[] PNGSignature;
    private static final short[] GIFSignature1;
    private static final short[] GIFSignature2;
    private static final short[] TIFFSignature1;
    private static final short[] TIFFSignature2;
    private static final short[] PostScriptSignature;
    private static final short[] PJLSignature;
    private static final short[] PJLSignature2;
    private static final Pattern PJL_EnterLangPattern;
    private static final short[] PDFSignature;
    private static final short[] PCLSignature;
    private static final short[] XMLSignature;
    private static final String ODTMimeString = "mimetypeapplication/vnd.oasis.opendocument.text";
    private static final short[] ODTSignature;
    private static final int maxSignatureLen = 4096;
    private static final Pattern FOPattern;

    public FormattedFile(String string, FileFormat fileFormat) {
        this(new File(string), fileFormat);
    }

    public FormattedFile(File file, FileFormat fileFormat) {
        this.file = file;
        this.format = fileFormat;
    }

    public FormattedFile(String string) {
        this(new File(string));
    }

    public FormattedFile(File file) {
        this.file = file;
    }

    public void view() throws IOException, UnknownFormatException {
        boolean bl;
        String string;
        switch (this.getFormat()) {
            case TIFF: {
                string = Utils.getFaxOptions().faxViewer;
                bl = Utils.getFaxOptions().useCustomFaxViewer;
                break;
            }
            case PostScript: {
                string = Utils.getFaxOptions().psViewer;
                bl = Utils.getFaxOptions().useCustomPSViewer;
                break;
            }
            case PDF: {
                string = Utils.getFaxOptions().pdfViewer;
                bl = Utils.getFaxOptions().useCustomPDFViewer;
                break;
            }
            default: {
                throw new UnknownFormatException(MessageFormat.format(Utils._("File format {0} not supported."), new Object[]{this.format}));
            }
        }
        if (bl) {
            Utils.startViewer(string, this.file);
        } else {
            DesktopManager.getDefault().open(this.file);
        }
    }

    public FileFormat getFormat() {
        if (this.format == null) {
            try {
                this.format = FormattedFile.detectFileFormat(this.file.getPath());
            }
            catch (Exception exception) {
                this.format = FileFormat.Unknown;
            }
        }
        return this.format;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file + " [format=" + (this.format == null ? "<not yet detected>" : this.format.name()) + "]";
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object object) {
        return this.file.equals(((FormattedFile)object).file);
    }

    public static FileFormat detectFileFormat(String string) throws FileNotFoundException, IOException {
        return FormattedFile.detectFileFormat(new FileInputStream(string));
    }

    public static FileFormat detectFileFormat(File file) throws FileNotFoundException, IOException {
        return FormattedFile.detectFileFormat(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileFormat detectFileFormat(InputStream inputStream) throws IOException {
        try {
            byte[] byArray = new byte[4096];
            int n = inputStream.read(byArray);
            if (FormattedFile.matchesSignature(byArray, JPEGSignature)) {
                FileFormat fileFormat = FileFormat.JPEG;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, PNGSignature)) {
                FileFormat fileFormat = FileFormat.PNG;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, GIFSignature1) || FormattedFile.matchesSignature(byArray, GIFSignature2)) {
                FileFormat fileFormat = FileFormat.GIF;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, TIFFSignature1) || FormattedFile.matchesSignature(byArray, TIFFSignature2)) {
                FileFormat fileFormat = FileFormat.TIFF;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, PDFSignature)) {
                FileFormat fileFormat = FileFormat.PDF;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, PostScriptSignature)) {
                FileFormat fileFormat = FileFormat.PostScript;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, PCLSignature)) {
                FileFormat fileFormat = FileFormat.PCL;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, ODTSignature)) {
                FileFormat fileFormat = FileFormat.ODT;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, XMLSignature)) {
                String string = new String(byArray, "UTF-8");
                if (FOPattern.matcher(string).find()) {
                    FileFormat fileFormat = FileFormat.FOP;
                    return fileFormat;
                }
                FileFormat fileFormat = FileFormat.XML;
                return fileFormat;
            }
            if (FormattedFile.matchesSignature(byArray, PJLSignature) || FormattedFile.matchesSignature(byArray, PJLSignature2)) {
                String string = new String(byArray, "ISO-8859-1");
                Matcher matcher = PJL_EnterLangPattern.matcher(string);
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    if ("POSTSCRIPT".equalsIgnoreCase(string2)) {
                        FileFormat fileFormat = FileFormat.PostScript;
                        return fileFormat;
                    }
                    if ("PCL".equalsIgnoreCase(string2)) {
                        FileFormat fileFormat = FileFormat.PCL;
                        return fileFormat;
                    }
                    FileFormat fileFormat = FileFormat.PJL;
                    return fileFormat;
                }
                FileFormat fileFormat = FileFormat.PJL;
                return fileFormat;
            }
            String string = byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65 ? new String(byArray, 3, 35, "UTF-8") : new String(byArray, 0, 32, "ISO-8859-1");
            if ((string = string.trim().toLowerCase()).startsWith("<html") || string.startsWith("<!doctype html") || string.startsWith("<head") || string.startsWith("<title")) {
                FileFormat fileFormat = FileFormat.HTML;
                return fileFormat;
            }
            if (string.startsWith("{\\rtf")) {
                FileFormat fileFormat = FileFormat.RTF;
                return fileFormat;
            }
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i] & 0xFF;
                if (n2 == 127) {
                    FileFormat fileFormat = FileFormat.Any;
                    return fileFormat;
                }
                if (n2 >= 32 || n2 == 10 || n2 == 13 || n2 == 9) continue;
                FileFormat fileFormat = FileFormat.Any;
                return fileFormat;
            }
            FileFormat fileFormat = FileFormat.PlainText;
            return fileFormat;
        }
        finally {
            inputStream.close();
        }
    }

    private static boolean matchesSignature(byte[] byArray, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            int n;
            short s = sArray[i];
            if (s < 0 || s > 255 || (n = byArray[i] & 0xFF) == s) continue;
            return false;
        }
        return true;
    }

    public static boolean canViewFormat(FileFormat fileFormat) {
        switch (fileFormat) {
            case TIFF: 
            case PostScript: 
            case PDF: {
                return true;
            }
        }
        return false;
    }

    public static FormattedFile getTempFileWithCorrectExtension(File file) throws IOException {
        File file2;
        FileFormat fileFormat = FormattedFile.detectFileFormat(file);
        if (fileFormat == FileFormat.Any || fileFormat == FileFormat.Unknown) {
            file2 = file;
        } else {
            String string = file.getName();
            int n = string.lastIndexOf(46);
            String string2 = n >= 0 ? string.substring(n + 1) : "";
            boolean bl = false;
            for (String string3 : fileFormat.getPossibleExtensions()) {
                if (!string3.equalsIgnoreCase(string2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                file2 = file;
            } else {
                File file3 = File.createTempFile("temp" + fileFormat.name(), "." + fileFormat.getDefaultExtension());
                ShutdownManager.deleteOnExit(file3);
                file2 = file3;
                if (!file.renameTo(file3)) {
                    file3.delete();
                    if (!file.renameTo(file3)) {
                        file2 = file;
                    }
                }
            }
        }
        return new FormattedFile(file2, fileFormat);
    }

    public static void main(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            System.out.println(string + ": " + (Object)((Object)FormattedFile.detectFileFormat(string)));
        }
    }

    static {
        int n;
        JPEGSignature = new short[]{255, 216, 255};
        PNGSignature = new short[]{137, 80, 78, 71, 13, 10, 26, 10};
        GIFSignature1 = new short[]{71, 73, 70, 56, 57, 97};
        GIFSignature2 = new short[]{71, 73, 70, 56, 55, 97};
        TIFFSignature1 = new short[]{77, 77, 0, 42};
        TIFFSignature2 = new short[]{73, 73, 42, 0};
        PostScriptSignature = new short[]{37, 33};
        PJLSignature = new short[]{27, 37, 45, 49, 50, 51, 52, 53, 88, 64, 80, 74, 76};
        PJLSignature2 = new short[]{64, 80, 74, 76, 32};
        PJL_EnterLangPattern = Pattern.compile("@PJL\\s+ENTER\\s+LANGUAGE\\s*=\\s*(\\w+)\\s*\r?\n", 2);
        PDFSignature = new short[]{37, 80, 68, 70, 45};
        PCLSignature = new short[]{27, 69, 27};
        XMLSignature = new short[]{60, 63, 120, 109, 108, 32};
        char[] cArray = ODTMimeString.toCharArray();
        ODTSignature = new short[30 + cArray.length];
        FormattedFile.ODTSignature[0] = 80;
        FormattedFile.ODTSignature[1] = 75;
        FormattedFile.ODTSignature[2] = 3;
        FormattedFile.ODTSignature[3] = 4;
        for (n = 4; n < 30; ++n) {
            FormattedFile.ODTSignature[n] = -1;
        }
        for (n = 0; n < cArray.length; ++n) {
            FormattedFile.ODTSignature[30 + n] = (short)cArray[n];
        }
        FOPattern = Pattern.compile("<[^>]+?xmlns(?::\\w+)?=\"http://www\\.w3\\.org/1999/XSL/Format\"");
    }
}

