/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FileFormat;
import yajhfc.file.MultiFileConverter;
import yajhfc.file.PDFMultiFileConverter;
import yajhfc.util.ExternalProcessExecutor;

public abstract class GhostScriptMultiFileConverter
extends MultiFileConverter {
    private static final int LINES_OF_ERROR_OUTPUT = 20;
    private static final Logger log = Logger.getLogger(PDFMultiFileConverter.class.getName());
    protected static final String[] defaultGSParams = new String[]{"-q", "-dBATCH", "-dSAFER", "-dNOPAUSE"};
    protected static final String[] NO_ADDITIONAL_PARAMETERS = new String[0];

    public void convertMultiplePSorPDFFiles(File[] fileArray, File file, PaperSize paperSize) throws IOException, FileConverter.ConversionException {
        String string;
        String string2 = Utils.getFaxOptions().ghostScriptLocation;
        String[] stringArray = this.getAdditionalGSParams();
        ArrayList<String> arrayList = new ArrayList<String>(5 + stringArray.length + defaultGSParams.length + 2 * fileArray.length);
        arrayList.add(string2);
        for (String linkedList2 : defaultGSParams) {
            arrayList.add(linkedList2);
        }
        arrayList.add("-sDEVICE=" + this.getGSDevice());
        arrayList.add("-sOutputFile=" + file.getAbsolutePath());
        arrayList.add("-sPAPERSIZE=" + paperSize.name().toLowerCase());
        arrayList.add(this.calcResolution(paperSize));
        for (String string3 : stringArray) {
            arrayList.add(string3);
        }
        for (File file2 : fileArray) {
            arrayList.add("-f");
            arrayList.add(file2.getAbsolutePath());
        }
        ExternalProcessExecutor.quoteCommandLine(arrayList);
        if (Utils.debugMode) {
            log.fine("Ghostscript command line:");
            for (String string3 : arrayList) {
                log.fine(string3);
            }
        }
        Process process = new ProcessBuilder(arrayList).redirectErrorStream(true).start();
        process.getOutputStream().close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            log.info("gs output: " + string);
            linkedList.offer(string);
            while (linkedList.size() > 20) {
                linkedList.poll();
            }
        }
        bufferedReader.close();
        try {
            int n = process.waitFor();
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Non-zero exit code of GhostScript (").append(n).append("):\n");
                for (String string4 : linkedList) {
                    stringBuilder.append(string4).append('\n');
                }
                throw new FileConverter.ConversionException(stringBuilder.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new FileConverter.ConversionException(interruptedException);
        }
    }

    protected String calcResolution(PaperSize paperSize) {
        return "-r196";
    }

    protected abstract String getGSDevice();

    protected abstract String[] getAdditionalGSParams();

    public abstract FileFormat getTargetFormat();
}

