/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import yajhfc.file.FileFormat;
import yajhfc.file.MultiFileConverter;
import yajhfc.file.PDFMultiFileConverter;
import yajhfc.file.PSMultiFileConverter;
import yajhfc.file.TIFFDitherMultiFileConverter;
import yajhfc.file.TIFFMultiFileConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MultiFileConvFormat {
    PDF(new PDFMultiFileConverter()),
    PostScript(new PSMultiFileConverter()),
    TIFF(new TIFFMultiFileConverter()),
    TIFF_DITHER(new TIFFDitherMultiFileConverter(), "TIFF (dithered)");

    private final MultiFileConverter converter;
    private final String description;

    private MultiFileConvFormat(MultiFileConverter multiFileConverter, String string2) {
        this.converter = multiFileConverter;
        this.description = string2;
    }

    private MultiFileConvFormat(MultiFileConverter multiFileConverter) {
        this(multiFileConverter, null);
    }

    public FileFormat getFileFormat() {
        return this.converter.getTargetFormat();
    }

    public MultiFileConverter getConverter() {
        return this.converter;
    }

    public String toString() {
        return this.description == null ? super.toString() : this.description;
    }

    public static MultiFileConvFormat getByFileFormat(FileFormat fileFormat) {
        for (MultiFileConvFormat multiFileConvFormat : MultiFileConvFormat.values()) {
            if (multiFileConvFormat.getFileFormat() != fileFormat) continue;
            return multiFileConvFormat;
        }
        return null;
    }
}

