/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.PaperSize;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FileConverterToFile;
import yajhfc.file.FileFormat;
import yajhfc.file.StdErrThread;
import yajhfc.tiff.TIFFReader;
import yajhfc.tiff.TIFFTag;
import yajhfc.util.ExternalProcessExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIFFLibConverter
implements FileConverterToFile {
    private static final Logger log = Logger.getLogger(TIFFLibConverter.class.getName());
    protected static final String[] tiff2pdfParams = new String[0];
    protected static final String[] tiff2psParams = new String[]{"-a1"};

    @Override
    public void convertToHylaFormat(File file, OutputStream outputStream, PaperSize paperSize, FileFormat fileFormat) throws FileConverter.ConversionException, IOException {
        this.convertToHylaFormatInternal(file, outputStream, null, paperSize, fileFormat);
    }

    @Override
    public void convertToHylaFormatFile(File file, File file2, PaperSize paperSize, FileFormat fileFormat) throws FileConverter.ConversionException, IOException {
        this.convertToHylaFormatInternal(file, null, file2, paperSize, fileFormat);
    }

    public void convertToHylaFormatInternal(File file, OutputStream outputStream, File file2, PaperSize paperSize, FileFormat fileFormat) throws FileConverter.ConversionException, IOException {
        List<String> list = this.getCommandLine(fileFormat, file, file2, paperSize);
        ExternalProcessExecutor.quoteCommandLine(list);
        if (Utils.debugMode) {
            log.fine("Invoking tiff2pdf with the following command line:");
            for (String object : list) {
                log.fine(object);
            }
        }
        Process process = new ProcessBuilder(list).start();
        new StdErrThread(list.get(0), process.getErrorStream());
        if (fileFormat == FileFormat.PostScript && outputStream == null) {
            outputStream = new FileOutputStream(file2);
        }
        if (outputStream != null) {
            InputStream n;
            block15: {
                n = process.getInputStream();
                if (fileFormat == FileFormat.PDF) {
                    int n2;
                    byte[] byArray = new byte[1000];
                    int n3 = n2 = n.read(byArray);
                    while (n2 >= 0 && n3 < 3) {
                        n2 = n.read(byArray, n3, byArray.length - n3);
                        if (n2 <= 0) continue;
                        n3 += n2;
                    }
                    if (n2 < 0 || n3 < 0) {
                        throw new IOException("Premature end of stream reading stdout from tiff2pdf (readLen=" + n2 + ", buflen=" + n3 + ").");
                    }
                    if (byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42) {
                        int n4 = 3;
                        do {
                            for (int i = n4; i < n3; ++i) {
                                if (byArray[i] == 0) continue;
                                outputStream.write(byArray, i, n3 - i);
                                break block15;
                            }
                            n4 = 0;
                        } while ((n3 = n.read(byArray)) >= 0);
                    } else {
                        outputStream.write(byArray, 0, n3);
                    }
                }
            }
            Utils.copyStream(n, outputStream);
            if (fileFormat == FileFormat.PostScript && file2 != null) {
                outputStream.close();
            }
        }
        try {
            int n = process.waitFor();
            if (n != 0) {
                throw new FileConverter.ConversionException("Non-zero exit code of tiff2pdf (" + n + ")");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new FileConverter.ConversionException(interruptedException);
        }
    }

    protected List<String> getCommandLine(FileFormat fileFormat, File file, File file2, PaperSize paperSize) throws FileConverter.ConversionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (fileFormat) {
            default: {
                arrayList.add(Utils.getFaxOptions().tiff2PDFLocation);
                for (String string : tiff2pdfParams) {
                    arrayList.add(string);
                }
                if (Utils.getFaxOptions().usePaperSizeForTIFF2Any) {
                    arrayList.add("-p");
                    arrayList.add(paperSize.name().toLowerCase());
                }
                if (file2 != null) {
                    arrayList.add("-o");
                    arrayList.add(file2.getAbsolutePath());
                }
                arrayList.add(file.getAbsolutePath());
                break;
            }
            case PostScript: {
                File file3 = Utils.searchExecutableInPath(new File(new File(Utils.getFaxOptions().tiff2PDFLocation).getParentFile(), "tiff2ps").getPath());
                if (file3 == null) {
                    return this.getCommandLine(FileFormat.PDF, file, null, paperSize);
                }
                arrayList.add(file3.getPath());
                for (String string : tiff2psParams) {
                    arrayList.add(string);
                }
                if (Utils.getFaxOptions().usePaperSizeForTIFF2Any) {
                    arrayList.add("-w");
                    arrayList.add(Float.toString(paperSize.getWidthInches()));
                    arrayList.add("-h");
                    arrayList.add(Float.toString(paperSize.getHeightInches()));
                }
                arrayList.add(file.getAbsolutePath());
            }
        }
        return arrayList;
    }

    @Override
    public boolean isOverridable() {
        return true;
    }

    public static Dimension getTIFFSizeInMM(File file) {
        try {
            TIFFReader tIFFReader = new TIFFReader(){

                protected boolean shouldTagBeRead(int n, int n2) {
                    switch (n) {
                        case 256: 
                        case 257: 
                        case 282: 
                        case 283: 
                        case 296: {
                            return true;
                        }
                    }
                    return false;
                }
            };
            FileInputStream fileInputStream = new FileInputStream(file);
            tIFFReader.read(fileInputStream);
            fileInputStream.close();
            Dimension dimension = new Dimension();
            block6: for (int i = 0; i < tIFFReader.getNumberOfPages(); ++i) {
                double d;
                TIFFTag tIFFTag = tIFFReader.findTag(256, i);
                if (tIFFTag == null) {
                    log.fine(file.toString() + ": TIFFTAG_IMAGEWIDTH not found");
                    continue;
                }
                double d2 = tIFFTag.doubleValue();
                tIFFTag = tIFFReader.findTag(257, i);
                if (tIFFTag == null) {
                    log.fine(file.toString() + ": TIFFTAG_IMAGELENGTH not found");
                    continue;
                }
                double d3 = tIFFTag.doubleValue();
                tIFFTag = tIFFReader.findTag(296, i);
                if (tIFFTag == null) {
                    log.fine(file.toString() + ": TIFFTAG_RESOLUTIONUNIT not found");
                    continue;
                }
                int n = tIFFTag.intValue();
                tIFFTag = tIFFReader.findTag(282, i);
                if (tIFFTag == null) {
                    log.fine(file.toString() + ": TIFFTAG_XRESOLUTION not found");
                    continue;
                }
                double d4 = tIFFTag.doubleValue();
                tIFFTag = tIFFReader.findTag(283, i);
                if (tIFFTag == null) {
                    log.fine(file.toString() + ": TIFFTAG_YRESOLUTION not found");
                    continue;
                }
                double d5 = tIFFTag.doubleValue();
                System.out.println("Page " + i + ": pixelWidth=" + d2 + "; pixelHeight=" + d3 + "; resUnit=" + n + "; resX=" + d4 + "; resY=" + d5);
                switch (n) {
                    case 3: {
                        d = 10.0;
                        break;
                    }
                    case 2: {
                        d = 25.4;
                        break;
                    }
                    default: {
                        log.fine(file.toString() + ": Unsupported resunit: " + n);
                        continue block6;
                    }
                }
                int n2 = (int)Math.round(d2 / d4 * d);
                int n3 = (int)Math.round(d3 / d5 * d);
                System.out.println("Page " + i + " (WxH) => " + n2 + "mm x " + n3 + "mm");
                dimension.height = Math.max(dimension.height, n3);
                dimension.width = Math.max(dimension.width, n2);
            }
            return dimension;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Can not determine page size for " + file, exception);
            return null;
        }
    }
}

