/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file;

import yajhfc.PaperSize;
import yajhfc.file.FileFormat;
import yajhfc.file.GhostScriptMultiFileConverter;

public class TIFFMultiFileConverter
extends GhostScriptMultiFileConverter {
    protected static final String[] additionalGSParams = new String[]{"-dAdjustWidth=1"};
    private final String gsDevice;

    public FileFormat getTargetFormat() {
        return FileFormat.TIFF;
    }

    protected String[] getAdditionalGSParams() {
        return additionalGSParams;
    }

    protected String calcResolution(PaperSize paperSize) {
        double d = 1728.0 / (double)paperSize.getSize().width * 25.4;
        return "-r" + d + "x196";
    }

    protected String getGSDevice() {
        return this.gsDevice;
    }

    public TIFFMultiFileConverter() {
        this("tiffg4");
    }

    public TIFFMultiFileConverter(String string) {
        this.gsDevice = string;
    }
}

