/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file.textextract;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FormattedFile;
import yajhfc.file.textextract.HylaToTextConverter;
import yajhfc.send.HylaTFLItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaxnumberExtractor {
    private static final Logger log = Logger.getLogger(FaxnumberExtractor.class.getName());
    static final Comparator<String> LENGTH_COMPARATOR_DESC = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return string2.length() - string.length();
        }
    };
    public static final String SUBJECT_DOCTITLE = "<doctitle>";
    protected final Pattern[] faxnumberPatterns;
    protected final HylaToTextConverter converter;
    public static final char PATTERN_PREFIX_FAX = 'F';
    public static final char PATTERN_PREFIX_MAIL = 'M';
    public static final char PATTERN_PREFIX_SUBJECT = 'S';

    public FaxnumberExtractor(HylaToTextConverter hylaToTextConverter, Pattern ... patternArray) {
        this.converter = hylaToTextConverter;
        this.faxnumberPatterns = patternArray;
    }

    public FaxnumberExtractor(HylaToTextConverter hylaToTextConverter) {
        this(hylaToTextConverter, FaxnumberExtractor.getDefaultPattern());
    }

    public FaxnumberExtractor(Pattern ... patternArray) {
        this(HylaToTextConverter.findDefault(), patternArray);
    }

    public FaxnumberExtractor() {
        this(HylaToTextConverter.findDefault());
    }

    public static Pattern getDefaultPattern() {
        return FaxnumberExtractor.buildPatternFromOptions(Utils.getFaxOptions(), 'F');
    }

    public static Pattern getDefaultMailPattern() {
        return FaxnumberExtractor.buildPatternFromOptions(Utils.getFaxOptions(), 'M');
    }

    public static Pattern getDefaultSubjectPattern() {
        return FaxnumberExtractor.buildPatternFromOptions(Utils.getFaxOptions(), 'S');
    }

    public static Pattern buildPatternFromOptions(FaxOptions faxOptions, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        String[] stringArray = faxOptions.recipientExtractionTags.toArray(new String[faxOptions.recipientExtractionTags.size()]);
        Arrays.sort(stringArray, LENGTH_COMPARATOR_DESC);
        stringBuilder.append("@@\\s*(?:");
        for (String string : stringArray) {
            if (string.length() <= 1 || string.charAt(0) != c) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append('|');
            }
            stringBuilder.append(Pattern.quote(string.substring(1)));
        }
        if (bl) {
            log.info("No tag names for prefix " + c + " found, returning null as Pattern.");
            return null;
        }
        stringBuilder.append(")\\s*:");
        if (!faxOptions.recipientExtractionTagMandatoryColon) {
            stringBuilder.append('?');
        }
        stringBuilder.append("(.+?)@@");
        log.fine("Built pattern for prefix " + c + ": " + stringBuilder);
        return Pattern.compile(stringBuilder.toString(), 2);
    }

    public int extractFromMultipleFileNames(Collection<String> collection, Collection<String> ... collectionArray) throws IOException, FileConverter.ConversionException {
        if (collection.size() == 0) {
            return 0;
        }
        ArrayList<FormattedFile> arrayList = new ArrayList<FormattedFile>(collection.size());
        for (String string : collection) {
            arrayList.add(new FormattedFile(string));
        }
        return this.extractFromMultipleFiles(arrayList, collectionArray);
    }

    public int extractFromMultipleDocuments(Collection<HylaTFLItem> collection, Collection<String> ... collectionArray) throws IOException, FileConverter.ConversionException {
        if (collection.size() == 0) {
            return 0;
        }
        ArrayList<FormattedFile> arrayList = new ArrayList<FormattedFile>(collection.size());
        for (HylaTFLItem hylaTFLItem : collection) {
            arrayList.add(hylaTFLItem.getPreviewFilename());
        }
        return this.extractFromMultipleFiles(arrayList, collectionArray);
    }

    public int extractFromMultipleFiles(List<FormattedFile> list, Collection<String> ... collectionArray) throws IOException, FileConverter.ConversionException {
        if (list.size() == 0) {
            return 0;
        }
        if (collectionArray.length != this.faxnumberPatterns.length) {
            throw new IllegalArgumentException("The number of output lists must match the number of patterns!");
        }
        CharSequence[] charSequenceArray = this.converter.convertFilesToText(list);
        int n = 0;
        for (int i = 0; i < collectionArray.length; ++i) {
            Collection<String> collection = collectionArray[i];
            Pattern pattern = this.faxnumberPatterns[i];
            if (pattern == null) {
                log.fine("Null pattern at index " + i + ", not extracting anything.");
                continue;
            }
            Collection<String> collection2 = collection instanceof Set ? collection : new TreeSet<String>();
            for (CharSequence charSequence : charSequenceArray) {
                n += this.getMatchesInText(charSequence, pattern, 1, collection2);
            }
            if (collection2 == collection) continue;
            collection.addAll(collection2);
        }
        return n;
    }

    public int getMatchesInText(CharSequence charSequence, Pattern pattern, int n, Collection<String> collection) throws IOException {
        if (Utils.debugMode) {
            log.finest("input text is:\n" + charSequence);
        }
        Matcher matcher = pattern.matcher(charSequence);
        int n2 = 0;
        while (matcher.find()) {
            String string;
            if (Utils.debugMode) {
                log.fine("Found match: " + matcher);
            }
            if ((string = matcher.group(n).trim()).length() <= 0) continue;
            collection.add(string);
            ++n2;
        }
        if (Utils.debugMode) {
            log.fine("No more matches; " + n2 + " matches found in total.");
        }
        return n2;
    }
}

