/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file.textextract;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.file.FileConverter;
import yajhfc.file.FileFormat;
import yajhfc.file.FormattedFile;
import yajhfc.file.MultiFileConvFormat;
import yajhfc.file.MultiFileConverter;
import yajhfc.file.UnknownFormatException;
import yajhfc.file.textextract.PDFToTextConverter;
import yajhfc.file.textextract.PSToAsciiConverter;
import yajhfc.file.textextract.PSToTextConverter;
import yajhfc.server.ServerManager;
import yajhfc.shutdown.ShutdownManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HylaToTextConverter {
    private static final Logger log = Logger.getLogger(HylaToTextConverter.class.getName());
    public static final List<HylaToTextConverter> availableConverters = new ArrayList<HylaToTextConverter>();
    public static final String DEFAULT_CONVERTER = "yajhfc.file.textextract.PSToTextConverter";

    public static HylaToTextConverter findByString(String string) {
        for (HylaToTextConverter hylaToTextConverter : availableConverters) {
            if (!hylaToTextConverter.name().equals(string)) continue;
            return hylaToTextConverter;
        }
        return null;
    }

    public static HylaToTextConverter findDefault() {
        HylaToTextConverter hylaToTextConverter;
        if (Utils.debugMode) {
            log.fine("Trying to find converter " + Utils.getFaxOptions().hylaToTextConverter);
        }
        if ((hylaToTextConverter = HylaToTextConverter.findByString(Utils.getFaxOptions().hylaToTextConverter)) != null) {
            if (Utils.debugMode) {
                log.fine("Found converter of class " + hylaToTextConverter.getClass().getName() + "; description=" + hylaToTextConverter.getDescription());
            }
            return hylaToTextConverter;
        }
        log.info("HylaToTextConverter " + Utils.getFaxOptions().hylaToTextConverter + " not found, falling back to " + DEFAULT_CONVERTER);
        hylaToTextConverter = HylaToTextConverter.findByString(DEFAULT_CONVERTER);
        if (hylaToTextConverter != null) {
            return hylaToTextConverter;
        }
        throw new RuntimeException("Neither the configured converter " + Utils.getFaxOptions().hylaToTextConverter + " nor the default converter " + DEFAULT_CONVERTER + " could be found!");
    }

    public String name() {
        return this.getClass().getName();
    }

    public HylaToTextConverter getInstanceForOptions(FaxOptions faxOptions) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(FaxOptions.class);
            return (HylaToTextConverter)constructor.newInstance(faxOptions);
        }
        catch (Exception exception) {
            log.log(Level.FINE, "Assuming converter has no options", exception);
            return this;
        }
    }

    public abstract String getDescription();

    public String toString() {
        return this.getDescription();
    }

    public abstract FileFormat[] getAllowedInputFormats();

    public CharSequence[] convertFilesToText(List<FormattedFile> list) throws IOException, FileConverter.ConversionException {
        Object[] objectArray = this.ensureInputFormat(list);
        if (Utils.debugMode) {
            log.fine("Extracting text from the following files " + Arrays.toString(objectArray) + " using " + this.getClass().getName());
        }
        return this.convertToText((File[])objectArray);
    }

    protected File[] ensureInputFormat(List<FormattedFile> list) throws FileConverter.ConversionException, IOException {
        FileFormat[] fileFormatArray = this.getAllowedInputFormats();
        if (Utils.debugMode) {
            log.fine("Allowed input formats: " + Arrays.toString((Object[])fileFormatArray));
            log.fine("Input files: " + list);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<FormattedFile> arrayList2 = new ArrayList<FormattedFile>();
        for (FormattedFile object : list) {
            if (Utils.indexOfArray((Object[])fileFormatArray, (Object)object.getFormat()) >= 0) {
                arrayList.add(object.file);
                continue;
            }
            arrayList2.add(object);
        }
        if (arrayList2.size() > 0) {
            FileFormat fileFormat;
            log.fine("Need to convert the following input files: " + arrayList2);
            Object object2 = null;
            FileFormat[] fileFormatArray2 = fileFormatArray;
            int n = fileFormatArray2.length;
            for (int i = 0; i < n && (object2 = MultiFileConvFormat.getByFileFormat(fileFormat = fileFormatArray2[i])) == null; ++i) {
            }
            if (object2 == null) {
                throw new FileConverter.ConversionException("Cannot find a converter to " + Arrays.toString((Object[])fileFormatArray));
            }
            MultiFileConverter multiFileConverter = ((MultiFileConvFormat)((Object)object2)).getConverter();
            File file = File.createTempFile("textextract", "." + multiFileConverter.getTargetFormat().getDefaultExtension());
            ShutdownManager.deleteOnExit(file);
            try {
                multiFileConverter.convertMultipleFiles(arrayList2, file, ServerManager.getDefault().getCurrent().getOptions().paperSize);
            }
            catch (UnknownFormatException unknownFormatException) {
                throw new FileConverter.ConversionException(unknownFormatException);
            }
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    protected abstract CharSequence[] convertToText(File[] var1) throws IOException, FileConverter.ConversionException;

    static {
        availableConverters.add(new PDFToTextConverter());
        availableConverters.add(new PSToTextConverter());
        availableConverters.add(new PSToAsciiConverter());
    }
}

