/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.file.textextract;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import yajhfc.FaxOptions;
import yajhfc.PlatformInfo;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.file.textextract.ExternalCommandToTextConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSToTextConverter
extends ExternalCommandToTextConverter {
    private static final Logger log = Logger.getLogger(PSToTextConverter.class.getName());

    public PSToTextConverter() {
        this(Utils.getFaxOptions());
    }

    public PSToTextConverter(FaxOptions faxOptions) {
        super("ISO8859-1", true, faxOptions);
    }

    @Override
    protected void buildCommandLine(List<String> list, File[] fileArray) {
        File file = new File(this.options.ghostScriptLocation);
        String string = this.options.pstotextPath;
        list.add(string);
        list.add("-gs");
        list.add(file.getName());
        for (File file2 : fileArray) {
            list.add(file2.getAbsolutePath());
        }
    }

    @Override
    protected void modifyEnvironment(Map<String, String> map) {
        File file = new File(this.options.ghostScriptLocation).getAbsoluteFile();
        String string = "PATH";
        if (PlatformInfo.IS_WINDOWS) {
            for (String string2 : map.keySet()) {
                if (!string.equalsIgnoreCase(string2)) continue;
                string = string2;
                break;
            }
        }
        String string3 = map.get(string) + File.pathSeparator + file.getParent();
        if (Utils.debugMode) {
            log.fine("New PATH is: " + (String)string3);
        }
        map.put(string, string3);
    }

    @Override
    public String getDescription() {
        return "pstotext";
    }

    @Override
    public FileFormat[] getAllowedInputFormats() {
        return new FileFormat[]{FileFormat.PostScript, FileFormat.PDF};
    }
}

