/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.filters;

import yajhfc.filters.ComparableFilterOperator;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterKeyList;
import yajhfc.filters.FilterableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparableFilter<V extends FilterableObject, K extends FilterKey>
implements Filter<V, K> {
    protected Comparable compareValue;
    protected ComparableFilterOperator operator;
    protected K column = null;
    protected Object colIdx = null;

    public ComparableFilter(K k, ComparableFilterOperator comparableFilterOperator, Comparable comparable) {
        this.column = k;
        this.operator = comparableFilterOperator;
        this.compareValue = comparable;
    }

    @Override
    public boolean matchesFilter(V v) {
        if (this.column == null || this.compareValue == null || this.operator == null || this.colIdx == null) {
            return true;
        }
        int n = this.compareValue.compareTo(v.getFilterData(this.colIdx));
        switch (this.operator) {
            case EQUAL: {
                return n == 0;
            }
            case NOTEQUAL: {
                return n != 0;
            }
            case LESS: {
                return n > 0;
            }
            case LESSEQUAL: {
                return n >= 0;
            }
            case GREATER: {
                return n < 0;
            }
            case GREATEREQUAL: {
                return n <= 0;
            }
        }
        return true;
    }

    @Override
    public void initFilter(FilterKeyList<K> filterKeyList) {
        this.colIdx = filterKeyList.translateKey(this.column);
    }

    public K getColumn() {
        return this.column;
    }

    public Object getCompareValue() {
        return this.compareValue;
    }

    public ComparableFilterOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean validate(FilterKeyList<K> filterKeyList) {
        return filterKeyList.containsKey(this.column);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append(this.column).append(' ').append(this.operator.getShortSymbol()).append(' ').append(this.compareValue);
    }
}

