/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.filters;

import java.text.FieldPosition;
import java.text.Format;
import yajhfc.filters.AbstractStringFilter;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterKeyList;
import yajhfc.filters.FilterableObject;
import yajhfc.filters.StringFilterOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatStringFilter<V extends FilterableObject, K extends FilterKey>
extends AbstractStringFilter<V, K> {
    protected Object[] concatVals;
    protected Object[] resolvedConcatVals;
    protected Class<K> keyClass;
    protected StringBuffer concatBuffer = new StringBuffer();
    private FieldPosition dummyFieldPos;

    protected FieldPosition getDummyFieldPos() {
        if (this.dummyFieldPos == null) {
            this.dummyFieldPos = new FieldPosition(0);
        }
        return this.dummyFieldPos;
    }

    public ConcatStringFilter(Class<K> clazz, Object[] objectArray, StringFilterOperator stringFilterOperator, String string, boolean bl) {
        super(stringFilterOperator, string, bl);
        this.concatVals = objectArray;
        this.keyClass = clazz;
    }

    @Override
    public void initFilter(FilterKeyList<K> filterKeyList) {
        this.resolvedConcatVals = new Object[this.concatVals.length];
        for (int i = 0; i < this.concatVals.length; ++i) {
            Object object = this.concatVals[i];
            this.resolvedConcatVals[i] = this.keyClass.isInstance(object) ? filterKeyList.translateKey((FilterKey)object) : null;
        }
    }

    @Override
    public boolean matchesFilter(V v) {
        this.concatBuffer.setLength(0);
        for (int i = 0; i < this.resolvedConcatVals.length; ++i) {
            Object object = this.concatVals[i];
            Object object2 = this.resolvedConcatVals[i];
            if (object2 == null) {
                this.concatBuffer.append(object);
                continue;
            }
            Object object3 = v.getFilterData(object2);
            if (object3 == null) continue;
            Format format = ((FilterKey)object).getFormat();
            if (format == null) {
                this.concatBuffer.append(object3);
                continue;
            }
            format.format(object3, this.concatBuffer, this.getDummyFieldPos());
        }
        return this.doActualMatch(this.concatBuffer.toString());
    }

    @Override
    public boolean validate(FilterKeyList<K> filterKeyList) {
        for (int i = 0; i < this.concatVals.length; ++i) {
            Object object = this.concatVals[i];
            if (!this.keyClass.isInstance(object) || filterKeyList.containsKey((FilterKey)object)) continue;
            return false;
        }
        return true;
    }

    public Object[] getConcatVals() {
        return this.concatVals;
    }

    @Override
    protected void fieldToString(StringBuilder stringBuilder) {
        stringBuilder.append('[');
        for (int i = 0; i < this.concatVals.length; ++i) {
            Object object = this.concatVals[i];
            if (this.keyClass.isInstance(object)) {
                stringBuilder.append(object);
            } else {
                stringBuilder.append('\"').append(object).append('\"');
            }
            if (i >= this.concatVals.length - 1) continue;
            stringBuilder.append('+');
        }
        stringBuilder.append(']');
    }
}

