/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.filters;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.DateKind;
import yajhfc.Utils;
import yajhfc.filters.AbstractStringFilter;
import yajhfc.filters.AndFilter;
import yajhfc.filters.CombinationFilter;
import yajhfc.filters.ComparableFilter;
import yajhfc.filters.ComparableFilterOperator;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterKeyList;
import yajhfc.filters.FilterableObject;
import yajhfc.filters.OrFilter;
import yajhfc.filters.StringFilter;
import yajhfc.filters.StringFilterOperator;
import yajhfc.model.FmtItem;
import yajhfc.model.IconMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterCreator {
    private static final Logger log = Logger.getLogger(FilterCreator.class.getName());
    private static String[] booleanOperators = new String[]{Utils._("is set"), Utils._("is not set")};

    public static Object[] getOperators(Class<?> clazz) {
        if (clazz == Integer.class || clazz == Float.class || clazz == Date.class || clazz == Double.class) {
            return ComparableFilterOperator.values();
        }
        if (clazz == String.class || clazz == IconMap.class) {
            return StringFilterOperator.values();
        }
        if (clazz == Boolean.class) {
            return booleanOperators;
        }
        return null;
    }

    public static boolean isInputEnabled(Class<?> clazz) {
        return clazz != Boolean.class && clazz != Void.class;
    }

    public static boolean isCaseSensitiveEnabled(Class<?> clazz) {
        return clazz == String.class || clazz == IconMap.class;
    }

    public static <V extends FilterableObject, K extends FilterKey> Filter<V, K> getFilter(K k, Object object, String string, boolean bl) throws ParseException {
        Class<?> clazz = k.getDataType();
        if (clazz == Integer.class) {
            return new ComparableFilter(k, (ComparableFilterOperator)((Object)object), Integer.valueOf(string));
        }
        if (clazz == Float.class) {
            return new ComparableFilter(k, (ComparableFilterOperator)((Object)object), Float.valueOf(string));
        }
        if (clazz == Double.class) {
            return new ComparableFilter(k, (ComparableFilterOperator)((Object)object), Double.valueOf(string));
        }
        if (clazz == Date.class) {
            DateFormat dateFormat = k instanceof FmtItem ? ((FmtItem)k).getDisplayDateFormat() : DateKind.DATE_AND_TIME.getFormat();
            return new ComparableFilter(k, (ComparableFilterOperator)((Object)object), dateFormat.parse(string));
        }
        if (clazz == String.class || clazz == IconMap.class) {
            return new StringFilter(k, (StringFilterOperator)((Object)object), string, bl);
        }
        if (clazz == Boolean.class) {
            return new ComparableFilter(k, ComparableFilterOperator.EQUAL, Boolean.valueOf(object == booleanOperators[0]));
        }
        return null;
    }

    public static <V extends FilterableObject, K extends FilterKey> K columnFromFilter(Filter<V, K> filter) {
        if (filter instanceof ComparableFilter) {
            return ((ComparableFilter)filter).getColumn();
        }
        if (filter instanceof StringFilter) {
            return ((StringFilter)filter).getColumn();
        }
        return null;
    }

    public static <V extends FilterableObject, K extends FilterKey> Object operatorFromFilter(Filter<V, K> filter) {
        if (filter instanceof ComparableFilter) {
            ComparableFilter comparableFilter = (ComparableFilter)filter;
            if (comparableFilter.getColumn().getDataType() != Boolean.class) {
                return comparableFilter.getOperator();
            }
            if (((Boolean)comparableFilter.getCompareValue()).booleanValue()) {
                return booleanOperators[0];
            }
            return booleanOperators[1];
        }
        if (filter instanceof StringFilter) {
            return ((StringFilter)filter).getOperator();
        }
        return null;
    }

    public static <V extends FilterableObject, K extends FilterKey> String inputFromFilter(Filter<V, K> filter) {
        if (filter instanceof ComparableFilter) {
            ComparableFilter comparableFilter = (ComparableFilter)filter;
            if (comparableFilter.getColumn() instanceof FmtItem && comparableFilter.getColumn().getDataType() == Date.class) {
                return ((FmtItem)comparableFilter.getColumn()).getDisplayDateFormat().format(comparableFilter.getCompareValue());
            }
            if (comparableFilter.getColumn().getDataType() == Boolean.class) {
                return "";
            }
            return comparableFilter.getCompareValue().toString();
        }
        if (filter instanceof StringFilter) {
            return ((StringFilter)filter).getCompareValue().toString();
        }
        return "";
    }

    public static boolean getIsCaseSensitive(Filter<?, ?> filter) {
        if (filter instanceof StringFilter) {
            return ((StringFilter)filter).isCaseSensitive();
        }
        return false;
    }

    public static <V extends FilterableObject, T extends FilterKey> String filterToString(Filter<V, T> filter) {
        if (filter == null || !(filter instanceof CombinationFilter)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (filter instanceof OrFilter) {
            stringBuffer.append('|');
        } else if (filter instanceof AndFilter) {
            stringBuffer.append('&');
        } else {
            return null;
        }
        stringBuffer.append('!');
        for (Filter filter2 : ((CombinationFilter)filter).getChildList()) {
            Filter filter3;
            if (filter2 instanceof ComparableFilter) {
                filter3 = (ComparableFilter)filter2;
                stringBuffer.append("c$");
                stringBuffer.append(((ComparableFilter)filter3).getColumn().name()).append('$');
                stringBuffer.append(((ComparableFilter)filter3).getOperator().name()).append('$');
                String string = ((ComparableFilter)filter3).getColumn().getDataType() == Date.class ? String.valueOf(((Date)((ComparableFilter)filter3).getCompareValue()).getTime()) : ((ComparableFilter)filter3).getCompareValue().toString();
                stringBuffer.append(Utils.escapeChars(string, "$!", '~')).append('$');
                stringBuffer.append('!');
                continue;
            }
            if (filter2 instanceof StringFilter) {
                filter3 = (StringFilter)filter2;
                if (((AbstractStringFilter)filter3).isCaseSensitive()) {
                    stringBuffer.append('s');
                } else {
                    stringBuffer.append('S');
                }
                stringBuffer.append('$');
                stringBuffer.append(((StringFilter)filter3).getColumn().name()).append('$');
                stringBuffer.append(((AbstractStringFilter)filter3).getOperator().name()).append('$');
                stringBuffer.append(Utils.escapeChars(((AbstractStringFilter)filter3).getCompareValue().toString(), "$!", '~')).append('$');
                stringBuffer.append('!');
                continue;
            }
            log.log(Level.WARNING, "Unknown filter type for filterToString: " + filter2.getClass().getName());
        }
        return stringBuffer.toString();
    }

    public static <V extends FilterableObject, T extends FilterKey> Filter<V, T> stringToFilter(String string, FilterKeyList<T> filterKeyList) {
        AndFilter andFilter;
        String[] stringArray = Utils.fastSplit(string, '!');
        if (stringArray[0].equals("|")) {
            andFilter = new OrFilter();
        } else if (stringArray[0].equals("&")) {
            andFilter = new AndFilter();
        } else {
            log.log(Level.WARNING, "Unknown And/Or specification in stringToFilter: " + stringArray[0]);
            return null;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = Utils.fastSplit(stringArray[i], '$');
            if (stringArray2.length != 4) {
                log.log(Level.WARNING, "Unknown filter specification in stringToFilter: " + stringArray[i]);
                continue;
            }
            T t = filterKeyList.getKeyForName(stringArray2[1]);
            if (t == null) {
                log.log(Level.WARNING, "Unknown column in stringToFilter: " + stringArray[i]);
                continue;
            }
            if (stringArray2[0].equals("c")) {
                String string2 = Utils.unEscapeChars(stringArray2[3], "$!", '~');
                Class<?> clazz = t.getDataType();
                try {
                    Comparable<Integer> comparable;
                    block27: {
                        if (clazz == Integer.class) {
                            comparable = Integer.valueOf(string2);
                        } else if (clazz == Float.class) {
                            comparable = Float.valueOf(string2);
                        } else if (clazz == Double.class) {
                            comparable = Double.valueOf(string2);
                        } else if (clazz == Boolean.class) {
                            comparable = Boolean.valueOf(string2);
                        } else {
                            if (clazz == Date.class) {
                                try {
                                    comparable = new Date(Long.parseLong(string2));
                                    break block27;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (t instanceof FmtItem) {
                                        try {
                                            comparable = ((FmtItem)t).getHylaDateFormat().parse(string2);
                                            break block27;
                                        }
                                        catch (ParseException parseException) {
                                            log.log(Level.WARNING, "Unknown date format in stringToFilter: " + string2);
                                            continue;
                                        }
                                    }
                                    log.log(Level.WARNING, "Unknown date format in stringToFilter: " + string2);
                                    continue;
                                }
                            }
                            log.log(Level.WARNING, "Unknown data class in stringToFilter: " + clazz.getName());
                            continue;
                        }
                    }
                    andFilter.addChild(new ComparableFilter(t, ComparableFilterOperator.valueOf(ComparableFilterOperator.class, stringArray2[2]), comparable));
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Exception in stringToFilter: ", exception);
                }
                continue;
            }
            if (stringArray2[0].equalsIgnoreCase("s")) {
                try {
                    andFilter.addChild(new StringFilter(t, StringFilterOperator.valueOf(StringFilterOperator.class, stringArray2[2]), Utils.unEscapeChars(stringArray2[3], "$!", '~'), stringArray2[0].charAt(0) == 's'));
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Exception in stringToFilter: ", exception);
                }
                continue;
            }
            log.log(Level.WARNING, "Unknown filter type in stringToFilter: " + stringArray[i]);
        }
        return andFilter;
    }
}

