/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.filters;

import java.text.FieldPosition;
import java.text.Format;
import yajhfc.filters.AbstractStringFilter;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterKeyList;
import yajhfc.filters.FilterableObject;
import yajhfc.filters.StringFilterOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFilter<V extends FilterableObject, K extends FilterKey>
extends AbstractStringFilter<V, K>
implements Filter<V, K> {
    protected K column = null;
    protected Object colIdx = null;
    private StringBuffer formatBuffer;
    private FieldPosition dummyFieldPos;

    public StringFilter(K k, StringFilterOperator stringFilterOperator, String string, boolean bl) {
        super(stringFilterOperator, string, bl);
        this.column = k;
    }

    protected StringBuffer getFormatBuffer() {
        if (this.formatBuffer == null) {
            this.formatBuffer = new StringBuffer();
        }
        return this.formatBuffer;
    }

    protected FieldPosition getDummyFieldPos() {
        if (this.dummyFieldPos == null) {
            this.dummyFieldPos = new FieldPosition(0);
        }
        return this.dummyFieldPos;
    }

    @Override
    public boolean matchesFilter(V v) {
        String string;
        if (this.column == null || this.colIdx == null) {
            return false;
        }
        Object object = v.getFilterData(this.colIdx);
        if (object == null) {
            string = "";
        } else {
            Format format = this.column.getFormat();
            if (format == null) {
                string = object.toString();
            } else {
                StringBuffer stringBuffer = this.getFormatBuffer();
                stringBuffer.setLength(0);
                string = format.format(object, stringBuffer, this.getDummyFieldPos()).toString();
            }
        }
        return this.doActualMatch(string);
    }

    @Override
    public void initFilter(FilterKeyList<K> filterKeyList) {
        this.colIdx = filterKeyList.translateKey(this.column);
    }

    public K getColumn() {
        return this.column;
    }

    @Override
    public boolean validate(FilterKeyList<K> filterKeyList) {
        return filterKeyList.containsKey(this.column);
    }

    @Override
    protected void fieldToString(StringBuilder stringBuilder) {
        stringBuilder.append(this.column);
    }
}

