/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.filters.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import yajhfc.Utils;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterCreator;
import yajhfc.filters.FilterKey;
import yajhfc.filters.FilterKeyList;
import yajhfc.filters.FilterableObject;
import yajhfc.model.FmtItem;
import yajhfc.model.VirtualColumnType;
import yajhfc.model.ui.FmtItemRenderer;
import yajhfc.util.ClipboardPopup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterPanel<V extends FilterableObject, K extends FilterKey>
extends JPanel
implements ActionListener {
    private JComboBox comboColumns;
    private JComboBox comboOperator;
    private JTextField textValue;
    private JButton buttonDelete;
    private JCheckBox checkCaseSensitive;
    private DefaultComboBoxModel colModel;
    private Class<?> oldClass;
    private static final FmtItem voidFmtItem = new FmtItem(){
        private final String desc = Utils._("(none)");

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public DateFormat getDisplayDateFormat() {
            return null;
        }

        @Override
        public DateFormat getHylaDateFormat() {
            return null;
        }

        @Override
        public String getHylaFmt() {
            return "";
        }

        @Override
        public String getLongDescription() {
            return this.desc;
        }

        @Override
        public Class<?> getDataType() {
            return Void.class;
        }

        @Override
        public String name() {
            return "void";
        }

        @Override
        public Format getFormat() {
            return null;
        }

        @Override
        public VirtualColumnType getVirtualColumnType() {
            return VirtualColumnType.NONE;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public String toString() {
            return this.desc;
        }
    };
    private static final String[] comboOperatorDummy = new String[]{"                         "};

    public void addDeleteActionListener(ActionListener actionListener) {
        this.buttonDelete.addActionListener(actionListener);
    }

    public void removeDeleteActionListener(ActionListener actionListener) {
        this.buttonDelete.removeActionListener(actionListener);
    }

    public boolean isDeleteEnabled() {
        return this.buttonDelete.isEnabled();
    }

    public void setDeleteEnabled(boolean bl) {
        this.buttonDelete.setEnabled(bl);
    }

    public void setDeleteActionCommand(String string) {
        this.buttonDelete.setActionCommand(string);
    }

    public void initFromFilter(Filter<V, K> filter) {
        if (filter == null) {
            return;
        }
        K k = FilterCreator.columnFromFilter(filter);
        if (k != null) {
            this.comboColumns.setSelectedItem(k);
            Object object = FilterCreator.operatorFromFilter(filter);
            if (object != null) {
                this.comboOperator.setSelectedItem(object);
                if (FilterCreator.isInputEnabled(k.getDataType())) {
                    this.textValue.setText(FilterCreator.inputFromFilter(filter));
                } else {
                    this.textValue.setText("");
                }
                this.checkCaseSensitive.setEnabled(FilterCreator.isCaseSensitiveEnabled(k.getDataType()));
                this.checkCaseSensitive.setSelected(FilterCreator.getIsCaseSensitive(filter));
            }
        } else {
            this.comboColumns.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Class<?> clazz;
        if (actionEvent.getActionCommand().equals("columnsel") && this.oldClass != (clazz = ((FilterKey)this.comboColumns.getSelectedItem()).getDataType())) {
            this.oldClass = clazz;
            Object[] objectArray = FilterCreator.getOperators(clazz);
            if (objectArray == null) {
                this.comboOperator.setEnabled(false);
                this.textValue.setEnabled(false);
            } else {
                this.comboOperator.setEnabled(true);
                this.comboOperator.setModel(new DefaultComboBoxModel<Object>(objectArray));
                this.textValue.setEnabled(FilterCreator.isInputEnabled(clazz));
                this.checkCaseSensitive.setEnabled(FilterCreator.isCaseSensitiveEnabled(clazz));
            }
        }
    }

    public void focusInput() {
        this.textValue.selectAll();
        this.textValue.requestFocus();
    }

    public Filter<V, K> getFilter() throws ParseException {
        return FilterCreator.getFilter((FilterKey)this.comboColumns.getSelectedItem(), this.comboOperator.getSelectedItem(), this.textValue.getText(), this.checkCaseSensitive.isSelected());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height);
    }

    public FilterPanel(FilterKeyList<? extends K> filterKeyList) {
        super(null, false);
        double[][] dArrayArray = new double[][]{{-2.0, 12.0, -2.0, 12.0, -1.0, 12.0, -2.0}, {-2.0, 6.0, -2.0}};
        this.setLayout(new TableLayout(dArrayArray));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        FilterKey[] filterKeyArray = filterKeyList.getAvailableKeys();
        this.colModel = new DefaultComboBoxModel<FilterKey>(filterKeyArray);
        this.colModel.insertElementAt(voidFmtItem, 0);
        this.comboColumns = new JComboBox(this.colModel);
        if (FmtItem.class.isAssignableFrom(filterKeyArray.getClass().getComponentType())) {
            this.comboColumns.setRenderer(new FmtItemRenderer());
        }
        this.comboColumns.setActionCommand("columnsel");
        this.comboColumns.addActionListener(this);
        this.comboOperator = new JComboBox<String>(comboOperatorDummy);
        this.comboOperator.setEnabled(false);
        Dimension dimension = new Dimension(this.comboOperator.getPreferredSize());
        this.comboOperator.setMaximumSize(dimension);
        this.comboOperator.setMinimumSize(dimension);
        this.comboOperator.setPreferredSize(dimension);
        this.textValue = new JTextField(20);
        this.textValue.setEnabled(false);
        this.textValue.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.checkCaseSensitive = new JCheckBox(Utils._("Case sensitive"));
        this.checkCaseSensitive.setEnabled(false);
        this.buttonDelete = new JButton(Utils.loadIcon("general/Delete"));
        this.buttonDelete.setToolTipText(Utils._("Remove this condition"));
        this.add((Component)this.comboColumns, "0,0,f,f");
        this.add((Component)this.comboOperator, "2,0,f,f");
        this.add((Component)this.textValue, "4,0,6,0,f,f");
        this.add((Component)this.checkCaseSensitive, "0,2,4,2,f,f");
        this.add((Component)this.buttonDelete, "6,2,f,f");
        this.comboColumns.setSelectedIndex(0);
    }

    public FilterPanel(FilterKeyList<K> filterKeyList, Filter<V, K> filter) {
        this(filterKeyList);
        this.initFromFilter(filter);
    }
}

