/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.launch;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import yajhfc.file.textextract.RecipientExtractionMode;
import yajhfc.launch.CommonCommandLineOpts;
import yajhfc.launch.HelpPrinter;
import yajhfc.launch.Launcher2;
import yajhfc.launch.ManPrinter;
import yajhfc.launch.SubmitProtocol;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginType;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.SafeJFileChooser;

public class CommandLineOpts
extends CommonCommandLineOpts {
    public final List<String> fileNames = new ArrayList<String>();
    public final List<String> recipients = new ArrayList<String>();
    public boolean useStdin = false;
    public boolean adminMode = false;
    public boolean forkNewInst = false;
    public boolean closeAfterSubmit = true;
    public boolean noGUI = false;
    public int selectedTab = -1;
    public Boolean useCover = null;
    public String subject = null;
    public String comment = null;
    public String modem = null;
    public boolean noWait = false;
    public static final int WINDOWSTATE_NOCHANGE = -1;
    public static final int WINDOWSTATE_TOTRAY = -2;
    public int desiredWindowState = -1;
    public String serverToUse = null;
    public String identityToUse = null;
    public RecipientExtractionMode extractRecipients = null;

    public void parse(String[] stringArray) {
        int n;
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("recipient", 1, null, 114), new LongOpt("extract-recipients", 2, null, 14), new LongOpt("use-cover", 2, null, 67), new LongOpt("subject", 1, null, 115), new LongOpt("comment", 1, null, 9), new LongOpt("modem", 1, null, 77), new LongOpt("server", 1, null, 83), new LongOpt("identity", 1, null, 73), new LongOpt("stdin", 0, null, 1), new LongOpt("print-jobids", 2, null, 13), new LongOpt("admin", 0, null, 65), new LongOpt("debug", 0, null, 100), new LongOpt("logfile", 1, null, 108), new LongOpt("appendlogfile", 1, null, 6), new LongOpt("background", 0, null, 2), new LongOpt("noclose", 0, null, 3), new LongOpt("no-wait", 0, null, 10), new LongOpt("showtab", 1, null, 84), new LongOpt("windowstate", 1, null, 11), new LongOpt("loadplugin", 1, null, 4), new LongOpt("loaddriver", 1, null, 5), new LongOpt("override-setting", 1, null, 12), new LongOpt("no-plugins", 0, null, 7), new LongOpt("no-gui", 0, null, 8), new LongOpt("no-check", 0, null, -2), new LongOpt("configdir", 1, null, 99), new LongOpt("help", 2, null, 104), new LongOpt("Xprint-manpage", 0, null, -3)};
        String[] stringArray2 = (String[])stringArray.clone();
        Getopt getopt = new Getopt("yajhfc", stringArray2, "h::Adc:r:T:l:C::s:M:I:S:", longOptArray);
        block45: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case -3: {
                    try {
                        new ManPrinter().printManPage(Launcher2.getConsoleWriter(), longOptArray);
                        System.exit(0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.exit(1);
                    }
                    continue block45;
                }
                case -2: {
                    continue block45;
                }
                case 1: {
                    this.useStdin = true;
                    continue block45;
                }
                case 2: {
                    this.forkNewInst = true;
                    continue block45;
                }
                case 3: {
                    this.closeAfterSubmit = false;
                    continue block45;
                }
                case 4: {
                    this.plugins.add(new PluginManager.PluginInfo(new File(getopt.getOptarg()), PluginType.PLUGIN, false));
                    continue block45;
                }
                case 5: {
                    this.plugins.add(new PluginManager.PluginInfo(new File(getopt.getOptarg()), PluginType.JDBCDRIVER, false));
                    continue block45;
                }
                case 108: {
                    this.logFile = getopt.getOptarg();
                    this.appendToLog = false;
                    continue block45;
                }
                case 6: {
                    this.logFile = getopt.getOptarg();
                    this.appendToLog = true;
                    continue block45;
                }
                case 7: {
                    this.noPlugins = true;
                    continue block45;
                }
                case 8: {
                    this.noGUI = true;
                    continue block45;
                }
                case 9: {
                    this.comment = getopt.getOptarg();
                    continue block45;
                }
                case 10: {
                    this.noWait = true;
                    this.forkNewInst = true;
                    continue block45;
                }
                case 11: {
                    if (getopt.getOptarg().length() < 1) continue block45;
                    switch (getopt.getOptarg().charAt(0)) {
                        case 'N': 
                        case 'n': {
                            this.desiredWindowState = 0;
                            continue block45;
                        }
                        case 'M': 
                        case 'm': {
                            this.desiredWindowState = 6;
                            continue block45;
                        }
                        case 'I': 
                        case 'i': {
                            this.desiredWindowState = 1;
                            continue block45;
                        }
                        case 'T': 
                        case 't': {
                            this.desiredWindowState = -2;
                            continue block45;
                        }
                    }
                    System.err.println("Unknown window state: " + getopt.getOptarg());
                    continue block45;
                }
                case 12: {
                    String string = getopt.getOptarg();
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (c < '\u0080') {
                            this.overrideSettings.append(c);
                            continue;
                        }
                        this.overrideSettings.append("\\u").append(Character.forDigit(c >> 12 & 0xF, 16)).append(Character.forDigit(c >> 8 & 0xF, 16)).append(Character.forDigit(c >> 4 & 0xF, 16)).append(Character.forDigit(c & 0xF, 16));
                    }
                    this.overrideSettings.append('\n');
                    continue block45;
                }
                case 13: {
                    String string = getopt.getOptarg();
                    if (string == null) {
                        this.jobIDOutput = "-";
                        continue block45;
                    }
                    this.jobIDOutput = string;
                    continue block45;
                }
                case 14: {
                    String string = getopt.getOptarg();
                    if (string == null || string.length() == 0) {
                        this.extractRecipients = RecipientExtractionMode.YES;
                        continue block45;
                    }
                    char c = Character.toLowerCase(string.charAt(0));
                    if (c == 'y' || string.equals("1")) {
                        this.extractRecipients = RecipientExtractionMode.YES;
                        continue block45;
                    }
                    if (c == 'n' || string.equals("0")) {
                        this.extractRecipients = RecipientExtractionMode.NO;
                        continue block45;
                    }
                    if (c == 'a' || string.equals("2")) {
                        this.extractRecipients = RecipientExtractionMode.AUTO;
                        continue block45;
                    }
                    System.err.println("Unknown option specified for extract-recipients: " + string);
                    continue block45;
                }
                case 67: {
                    String string = getopt.getOptarg();
                    if (string == null || string.equals("") || Character.toLowerCase(string.charAt(0)) == 'y' || string.equals("true")) {
                        this.useCover = Boolean.TRUE;
                        continue block45;
                    }
                    this.useCover = Boolean.FALSE;
                    continue block45;
                }
                case 115: {
                    this.subject = getopt.getOptarg();
                    continue block45;
                }
                case 104: {
                    new HelpPrinter().printHelp(Launcher2.getConsoleWriter(), longOptArray, getopt.getOptarg());
                    System.exit(0);
                    continue block45;
                }
                case 65: {
                    this.adminMode = true;
                    continue block45;
                }
                case 100: {
                    this.debugMode = true;
                    continue block45;
                }
                case 99: {
                    this.configDir = getopt.getOptarg();
                    continue block45;
                }
                case 114: {
                    this.recipients.add(getopt.getOptarg());
                    continue block45;
                }
                case 84: {
                    if (getopt.getOptarg().length() < 1) continue block45;
                    switch (getopt.getOptarg().charAt(0)) {
                        case '0': 
                        case 'R': 
                        case 'r': {
                            this.selectedTab = 0;
                            continue block45;
                        }
                        case '1': 
                        case 'S': 
                        case 's': {
                            this.selectedTab = 1;
                            continue block45;
                        }
                        case '2': 
                        case 'T': 
                        case 't': {
                            this.selectedTab = 2;
                            continue block45;
                        }
                        case '3': 
                        case 'A': 
                        case 'a': {
                            this.selectedTab = 3;
                            continue block45;
                        }
                    }
                    System.err.println("Unknown tab: " + getopt.getOptarg());
                    continue block45;
                }
                case 77: {
                    this.modem = getopt.getOptarg();
                    continue block45;
                }
                case 73: {
                    this.identityToUse = getopt.getOptarg();
                    continue block45;
                }
                case 83: {
                    this.serverToUse = getopt.getOptarg();
                    continue block45;
                }
                case 63: {
                    continue block45;
                }
            }
            System.err.println("Unknown option '" + (char)n + "' in " + stringArray2[getopt.getOptind()]);
        }
        for (int i = getopt.getOptind(); i < stringArray2.length; ++i) {
            this.fileNames.add(stringArray2[i]);
        }
        if (this.debugMode && ":prompt:".equals(this.logFile)) {
            this.logFile = new LogFilePrompter().promptForLogfile();
            if (this.logFile == null) {
                this.debugMode = false;
            }
        }
    }

    public void fillSubmitProtocol(SubmitProtocol submitProtocol) throws IOException {
        if (this.fileNames.size() > 0) {
            submitProtocol.addFiles(this.fileNames);
        }
        if (this.recipients.size() > 0) {
            submitProtocol.addRecipients(this.recipients);
        }
        if (this.useStdin) {
            submitProtocol.setInputStream(System.in, null);
        }
        if (this.useCover != null) {
            submitProtocol.setCover(this.useCover);
        }
        if (this.subject != null) {
            submitProtocol.setSubject(this.subject);
        }
        if (this.comment != null) {
            submitProtocol.setComments(this.comment);
        }
        if (this.modem != null) {
            submitProtocol.setModem(this.modem);
        }
        if (this.serverToUse != null) {
            submitProtocol.setServer(this.serverToUse);
        }
        if (this.identityToUse != null) {
            submitProtocol.setIdentity(this.identityToUse);
        }
    }

    public CommandLineOpts() {
    }

    public CommandLineOpts(String[] stringArray) {
        this();
        this.parse(stringArray);
    }

    static class LogFilePrompter
    implements Runnable {
        protected String selection = null;

        LogFilePrompter() {
        }

        public void run() {
            SafeJFileChooser safeJFileChooser = new SafeJFileChooser();
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter("log", "Log files");
            safeJFileChooser.addChoosableFileFilter(exampleFileFilter);
            safeJFileChooser.setFileFilter(exampleFileFilter);
            safeJFileChooser.setDialogTitle("Select log file location");
            if (safeJFileChooser.showSaveDialog(null) == 0) {
                this.selection = safeJFileChooser.getSelectedFile().getPath();
                if (safeJFileChooser.getFileFilter() == exampleFileFilter && this.selection.indexOf(46) == -1) {
                    this.selection = this.selection + ".log";
                }
            } else {
                this.selection = null;
            }
        }

        public String promptForLogfile() {
            try {
                SwingUtilities.invokeAndWait(this);
                return this.selection;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }
}

