/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.launch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.IDAndNameOptions;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.file.FileUtils;
import yajhfc.file.FormattedFile;
import yajhfc.file.textextract.FaxnumberExtractor;
import yajhfc.file.textextract.RecipientExtractionMode;
import yajhfc.launch.SubmitProtocol;
import yajhfc.phonebook.convrules.DefaultPBEntryFieldContainer;
import yajhfc.send.FaxSender;
import yajhfc.send.LocalFileTFLItem;
import yajhfc.send.StreamTFLItem;
import yajhfc.server.ServerManager;
import yajhfc.server.ServerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FaxSenderSubmitProtocol
implements SubmitProtocol {
    protected static final Logger log = Logger.getLogger(FaxSenderSubmitProtocol.class.getName());
    protected String subject;
    protected String comments;
    protected String modem;
    protected Boolean useCover;
    protected RecipientExtractionMode extractRecipients;
    protected boolean closeAfterSubmit = false;
    protected final List<String> recipients = new ArrayList<String>();
    protected final List<String> files = new ArrayList<String>();
    protected InputStream inStream;
    protected String streamDesc = null;
    protected StreamTFLItem tflInStream;
    protected String server;
    protected String identity;
    protected boolean preparedSubmit = false;
    protected int numExtractedRecipients = 0;

    @Override
    public void setComments(String string) {
        this.comments = string;
    }

    @Override
    public void setCover(boolean bl) {
        this.useCover = bl;
    }

    @Override
    public void setExtractRecipients(RecipientExtractionMode recipientExtractionMode) throws IOException {
        this.extractRecipients = recipientExtractionMode;
    }

    @Override
    public void addFiles(Collection<String> collection) {
        this.files.addAll(collection);
    }

    @Override
    public void setInputStream(InputStream inputStream, String string) {
        this.inStream = inputStream;
        this.streamDesc = string;
    }

    @Override
    public void addRecipients(Collection<String> collection) {
        this.recipients.addAll(collection);
    }

    @Override
    public void setSubject(String string) {
        this.subject = string;
    }

    @Override
    public void setModem(String string) throws IOException {
        this.modem = string;
    }

    @Override
    public void setCloseAfterSubmit(boolean bl) {
        this.closeAfterSubmit = bl;
    }

    @Override
    public void setIdentity(String string) throws IOException {
        this.identity = string;
    }

    @Override
    public void setServer(String string) throws IOException {
        this.server = string;
    }

    public void prepareSubmit() throws IOException {
        Object object;
        Object object2;
        if (this.preparedSubmit) {
            return;
        }
        if (this.inStream != null) {
            this.tflInStream = new StreamTFLItem(this.inStream, this.streamDesc);
            if (this.subject == null) {
                log.fine("No subject specified, trying to extract one from the file...");
                try {
                    object2 = this.tflInStream.getPreviewFilename();
                    if (((FormattedFile)object2).getFormat() == FileFormat.PostScript) {
                        log.fine("File is PostScript.");
                        object = FileUtils.extractTitleFromPSFile(((FormattedFile)object2).file);
                        if (object != null) {
                            this.subject = object;
                        }
                    }
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Error extracting title from document.", exception);
                }
            }
        }
        if (Utils.debugMode) {
            log.fine("Check for extracting recipients: extractRecipients=" + (Object)((Object)this.extractRecipients) + "; Utils.getFaxOptions().extractRecipients=" + (Object)((Object)Utils.getFaxOptions().extractRecipients));
        }
        if ((object2 = this.getEffectiveExtractRecipients()) == RecipientExtractionMode.YES || object2 == RecipientExtractionMode.AUTO) {
            try {
                if (this.inStream != null) {
                    log.fine("Extracting recipients from stdin");
                    object = new FaxnumberExtractor(FaxnumberExtractor.getDefaultPattern(), FaxnumberExtractor.getDefaultSubjectPattern());
                    TreeSet treeSet = new TreeSet();
                    this.numExtractedRecipients = ((FaxnumberExtractor)object).extractFromMultipleFiles(Collections.singletonList(this.tflInStream.getPreviewFilename()), this.recipients, treeSet);
                    if (treeSet.size() >= 1) {
                        this.numExtractedRecipients -= treeSet.size();
                        this.subject = (String)treeSet.iterator().next();
                    }
                } else if (this.files.size() > 0) {
                    log.fine("Extracting recipients from input files");
                    object = new FaxnumberExtractor(FaxnumberExtractor.getDefaultPattern(), FaxnumberExtractor.getDefaultSubjectPattern());
                    TreeSet treeSet = new TreeSet();
                    this.numExtractedRecipients = ((FaxnumberExtractor)object).extractFromMultipleFileNames(this.files, this.recipients, treeSet);
                    if (treeSet.size() >= 1) {
                        this.numExtractedRecipients -= treeSet.size();
                        this.subject = (String)treeSet.iterator().next();
                    }
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error extracting recipients", exception);
            }
        }
        this.preparedSubmit = true;
    }

    protected RecipientExtractionMode getEffectiveExtractRecipients() {
        RecipientExtractionMode recipientExtractionMode = this.extractRecipients;
        if (recipientExtractionMode == null) {
            recipientExtractionMode = Utils.getFaxOptions().extractRecipients;
        }
        return recipientExtractionMode;
    }

    protected void submitTo(FaxSender faxSender) {
        Object object;
        if (this.server != null) {
            object = IDAndNameOptions.getItemFromCommandLineCoding(Utils.getFaxOptions().servers, this.server);
            if (this.server != null) {
                faxSender.setServer(ServerManager.getDefault().getServerByID(((ServerOptions)object).id));
            } else {
                log.warning("Server not found, using default instead");
            }
        }
        if (this.identity != null) {
            object = IDAndNameOptions.getItemFromCommandLineCoding(Utils.getFaxOptions().identities, this.identity);
            if (this.identity != null) {
                faxSender.setIdentity((SenderIdentity)object);
            } else {
                log.warning("Identity not found, using default instead");
            }
        }
        object = faxSender.getDocuments();
        if (this.inStream != null) {
            object.add(this.tflInStream);
        } else {
            for (String string : this.files) {
                object.add(new LocalFileTFLItem(string));
            }
        }
        if (this.recipients != null && this.recipients.size() > 0) {
            DefaultPBEntryFieldContainer.parseCmdLineStrings(faxSender.getRecipients(), this.recipients);
        }
        if (this.useCover != null) {
            faxSender.setUseCover(this.useCover);
        }
        if (this.subject != null) {
            faxSender.setSubject(this.subject);
        }
        if (this.comments != null) {
            faxSender.setComment(this.comments);
        }
        if (this.modem != null) {
            faxSender.setModem(this.modem);
        }
    }
}

