/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.launch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import yajhfc.MainWin;
import yajhfc.NoGUISender;
import yajhfc.Utils;
import yajhfc.launch.CommandLineOpts;
import yajhfc.launch.CommonCommandLineOpts;
import yajhfc.launch.Lock;
import yajhfc.launch.MainApplicationFrame;
import yajhfc.launch.ResponseException;
import yajhfc.launch.SendControllerSubmitProtocol;
import yajhfc.launch.SendWinSubmitProtocol;
import yajhfc.logconsole.SwingLogHandler;
import yajhfc.plugin.PluginManager;
import yajhfc.send.SendController;
import yajhfc.server.ServerManager;
import yajhfc.shutdown.ShutdownManager;
import yajhfc.splashscreen.YJSplashScreen;
import yajhfc.util.ExternalProcessExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher2 {
    static final Logger launchLog = Logger.getLogger(Launcher2.class.getName());
    public static String cmdLineConfDir = null;
    public static Properties overrideSettings = null;
    public static MainApplicationFrame application;
    public static SwingLogHandler swingLogHandler;
    public static PrintWriter jobIDWriter;
    private static PrintWriter consoleWriter;

    public static void main(String[] stringArray) {
        CommandLineOpts commandLineOpts = new CommandLineOpts(stringArray);
        Launcher2.setupFirstStage(stringArray, commandLineOpts);
        if (commandLineOpts.noGUI) {
            Launcher2.noGUIStartup(commandLineOpts);
        } else if (Launcher2.needSubmitProtocol(commandLineOpts) && commandLineOpts.closeAfterSubmit && !commandLineOpts.forkNewInst) {
            Launcher2.sendOnlyStartup(commandLineOpts);
        } else {
            Launcher2.normalStartup(commandLineOpts);
        }
    }

    public static void setupFirstStage(String[] stringArray, CommonCommandLineOpts commonCommandLineOpts) {
        Object object;
        cmdLineConfDir = commonCommandLineOpts.configDir;
        if (commonCommandLineOpts.overrideSettings.length() > 0) {
            overrideSettings = new Properties();
            try {
                object = new ByteArrayInputStream(commonCommandLineOpts.overrideSettings.toString().getBytes("ISO8859-1"));
                overrideSettings.load((InputStream)object);
            }
            catch (Exception exception) {
                launchLog.log(Level.WARNING, "Error loading override settings", exception);
            }
        }
        Utils.debugMode = commonCommandLineOpts.debugMode;
        object = LogManager.getLogManager().getLogger("");
        swingLogHandler = new SwingLogHandler();
        ((Logger)object).addHandler(swingLogHandler);
        if (commonCommandLineOpts.debugMode) {
            StreamHandler streamHandler;
            if (commonCommandLineOpts.logFile != null) {
                try {
                    streamHandler = new StreamHandler(new FileOutputStream(commonCommandLineOpts.logFile, commonCommandLineOpts.appendToLog), new SimpleFormatter());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    launchLog.log(Level.WARNING, "Could not open log file.", fileNotFoundException);
                    streamHandler = new StreamHandler(System.out, new SimpleFormatter());
                }
            } else {
                streamHandler = new StreamHandler(System.out, new SimpleFormatter());
            }
            streamHandler.setLevel(Level.FINEST);
            ((Logger)object).setLevel(Level.FINEST);
            ((Logger)object).addHandler(streamHandler);
            Logger.getLogger("sun").setLevel(Level.INFO);
            Logger.getLogger("java.awt").setLevel(Level.INFO);
            Logger.getLogger("javax.swing").setLevel(Level.INFO);
            launchLog.config("YajHFC version: 0.6.1 (srfax v4)");
            launchLog.config("---- BEGIN System.getProperties() dump");
            Utils.dumpProperties(System.getProperties(), launchLog, new Object[0]);
            launchLog.config("---- END System.getProperties() dump");
            launchLog.config("" + stringArray.length + " command line arguments:");
            for (String string : stringArray) {
                launchLog.config(string);
            }
        }
        Launcher2.loadPlugins(commonCommandLineOpts.plugins, commonCommandLineOpts.noPlugins);
        Utils.initializeUIProperties();
        if (commonCommandLineOpts.jobIDOutput != null) {
            if ("-".equals(commonCommandLineOpts.jobIDOutput)) {
                jobIDWriter = Launcher2.getConsoleWriter();
            } else {
                try {
                    jobIDWriter = new PrintWriter(commonCommandLineOpts.jobIDOutput);
                }
                catch (Exception exception) {
                    launchLog.log(Level.WARNING, "Specified job ID file  \"" + commonCommandLineOpts.jobIDOutput + "\" could not be opened for writing", exception);
                }
            }
        }
    }

    public static void normalStartup(CommandLineOpts commandLineOpts) {
        if (Utils.debugMode) {
            launchLog.info("Normal startup...");
        }
        Lock lock = Lock.checkLock();
        if (commandLineOpts.forkNewInst && lock == null) {
            lock = Launcher2.forkNewInstance(commandLineOpts);
        }
        if (lock == null) {
            SendWinSubmitProtocol sendWinSubmitProtocol;
            if (Utils.debugMode) {
                launchLog.info("No old instance found, creating lock...");
            }
            Lock.createLock();
            PluginManager.initializeAllKnownPlugins(0);
            if (Launcher2.needSubmitProtocol(commandLineOpts)) {
                try {
                    sendWinSubmitProtocol = new SendWinSubmitProtocol();
                    commandLineOpts.fillSubmitProtocol(sendWinSubmitProtocol);
                    sendWinSubmitProtocol.setCloseAfterSubmit(commandLineOpts.closeAfterSubmit);
                    sendWinSubmitProtocol.prepareSubmit();
                }
                catch (IOException iOException) {
                    launchLog.log(Level.WARNING, "Error preparing SendWin:", iOException);
                    sendWinSubmitProtocol = null;
                }
            } else {
                sendWinSubmitProtocol = null;
            }
            SwingUtilities.invokeLater(new NewInstRunner(sendWinSubmitProtocol, commandLineOpts.adminMode, commandLineOpts.selectedTab, commandLineOpts.desiredWindowState, commandLineOpts.serverToUse));
            Lock.startLockThread();
            if (Utils.debugMode) {
                launchLog.info("Lock and listener created.");
            }
            ShutdownManager.getInstance().registerShutdownHook(new Runnable(){

                public void run() {
                    if (Utils.debugMode) {
                        System.err.println("Doing shutdown work...");
                    }
                    application.saveWindowSettings();
                    ServerManager.getDefault().shutdownCleanup();
                    Utils.storeOptionsToFile();
                    Lock.releaseLock();
                    if (Utils.debugMode) {
                        System.err.println("Shutdown work finished.");
                    }
                }
            });
        } else {
            try {
                launchLog.info("Connecting to old instance...");
                if (Launcher2.needSubmitProtocol(commandLineOpts)) {
                    launchLog.info("Submitting fax using the old instance");
                    commandLineOpts.fillSubmitProtocol(lock);
                    long[] lArray = lock.submit(!commandLineOpts.noWait);
                    if (lArray != null) {
                        for (long l : lArray) {
                            SendController.printJobIDIfRequested(l);
                        }
                    }
                } else {
                    launchLog.fine("There already is a running instance!");
                    Launcher2.getConsoleWriter().println(Utils._("There already is a running instance!"));
                    lock.bringToFront();
                }
                lock.close();
                launchLog.info("All information submitted to old instance, terminating cleanly.");
                System.exit(0);
            }
            catch (ResponseException responseException) {
                int n = responseException.getErrorCode();
                launchLog.log(Level.INFO, "The old instance gave back an error", responseException);
                if (n >= 0 && n <= 255) {
                    System.exit(n);
                } else {
                    System.exit(1);
                }
            }
            catch (Exception exception) {
                launchLog.log(Level.WARNING, "An error occured communicating with the old instance: ", exception);
                System.exit(1);
            }
        }
    }

    public static void noGUIStartup(CommandLineOpts commandLineOpts) {
        if (Utils.debugMode) {
            launchLog.info("No GUI startup...");
        }
        PluginManager.initializeAllKnownPlugins(1);
        if (commandLineOpts.recipients.size() == 0) {
            System.err.println("In no GUI mode you have to specify at least one recipient.");
            System.exit(1);
        }
        if (commandLineOpts.fileNames.size() == 0 && !commandLineOpts.useStdin) {
            System.err.println("In no GUI mode you have to specify at least one file to send or --stdin.");
            System.exit(1);
        }
        NoGUISender.submitWithoutUI(commandLineOpts, new SendControllerSubmitProtocol());
    }

    public static void sendOnlyStartup(CommandLineOpts commandLineOpts) {
        if (Utils.debugMode) {
            launchLog.info("Send only startup...");
        }
        try {
            PluginManager.initializeAllKnownPlugins(2);
            ShutdownManager.getInstance().registerShutdownHook(new Runnable(){

                public void run() {
                    if (Utils.debugMode) {
                        System.err.println("Doing shutdown work...");
                    }
                    Utils.storeOptionsToFile();
                    if (Utils.debugMode) {
                        System.err.println("Shutdown work finished.");
                    }
                }
            });
            NoGUISender.submitWithoutUI(commandLineOpts, new SendWinSubmitProtocol());
        }
        catch (Exception exception) {
            launchLog.log(Level.WARNING, "Error submitting fax", exception);
        }
    }

    static boolean needSubmitProtocol(CommandLineOpts commandLineOpts) {
        return commandLineOpts.fileNames.size() > 0 || commandLineOpts.useStdin || commandLineOpts.recipients.size() > 0;
    }

    public static void loadPlugins(List<PluginManager.PluginInfo> list, boolean bl) {
        launchLog.fine("Initializing plugins...");
        if (!bl) {
            PluginManager.readPluginList();
        }
        PluginManager.addPlugins(list);
        PluginManager.loadAllKnownPlugins();
    }

    public static Lock forkNewInstance(CommandLineOpts commandLineOpts) {
        try {
            Lock lock;
            launchLog.info("Forking new instance of YajHFC...");
            ArrayList<String> arrayList = new ArrayList<String>(20);
            arrayList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
            arrayList.add("-classpath");
            arrayList.add(System.getProperty("java.class.path"));
            arrayList.add("-Duser.home=" + System.getProperty("user.home"));
            arrayList.add(Launcher2.class.getCanonicalName());
            if (commandLineOpts.adminMode) {
                arrayList.add("--admin");
            }
            if (Utils.debugMode) {
                arrayList.add("--debug");
            }
            if (commandLineOpts.logFile != null) {
                String string;
                arrayList.add("--logfile");
                File file = new File(commandLineOpts.logFile);
                String[] stringArray = file.getName();
                int n = stringArray.lastIndexOf(46);
                if (n >= 0) {
                    string = stringArray.substring(n);
                    stringArray = stringArray.substring(0, n);
                } else {
                    string = "";
                }
                arrayList.add(new File(file.getParentFile(), (String)stringArray + "-background" + string).getAbsolutePath());
            }
            if (!commandLineOpts.closeAfterSubmit) {
                arrayList.add("--noclose");
            }
            if (cmdLineConfDir != null) {
                arrayList.add("--configdir");
                arrayList.add(cmdLineConfDir);
            }
            if (commandLineOpts.selectedTab >= 0) {
                arrayList.add("--showtab=" + commandLineOpts.selectedTab);
            }
            if (commandLineOpts.noPlugins) {
                arrayList.add("--no-plugins");
            }
            for (String[] stringArray : commandLineOpts.plugins) {
                switch (stringArray.type) {
                    case PLUGIN: {
                        arrayList.add("--loadplugin");
                        arrayList.add(stringArray.file.getAbsolutePath());
                        break;
                    }
                    case JDBCDRIVER: {
                        arrayList.add("--loaddriver");
                        arrayList.add(stringArray.file.getAbsolutePath());
                    }
                }
            }
            if (commandLineOpts.desiredWindowState != -1) {
                char c;
                switch (commandLineOpts.desiredWindowState) {
                    case -2: {
                        c = 't';
                        break;
                    }
                    case 1: {
                        c = 'i';
                        break;
                    }
                    case 6: {
                        c = 'm';
                        break;
                    }
                    default: {
                        c = 'n';
                    }
                }
                arrayList.add("--windowstate=" + c);
            }
            if (commandLineOpts.overrideSettings.length() > 0) {
                String[] stringArray;
                for (String string : stringArray = Utils.fastSplit(commandLineOpts.overrideSettings.toString(), '\n')) {
                    arrayList.add("--override-setting");
                    arrayList.add(string);
                }
            }
            if (Utils.debugMode) {
                launchLog.info("Launching new instance:");
                for (int i = 0; i < arrayList.size(); ++i) {
                    launchLog.info("launchArgs[" + i + "] = " + (String)arrayList.get(i));
                }
            }
            ExternalProcessExecutor.executeProcess(arrayList);
            int n = 0;
            if (Utils.debugMode) {
                launchLog.info("Waiting for new instance... ");
            }
            do {
                Thread.sleep(200L);
                if ((n += 200) <= 20000) continue;
                throw new TimeoutException(Utils._("The new instance did not start after 20 seconds."));
            } while ((lock = Lock.checkLock()) == null);
            if (Utils.debugMode) {
                launchLog.info("New instance has been started.");
            }
            return lock;
        }
        catch (Exception exception) {
            if (Utils.debugMode) {
                launchLog.log(Level.WARNING, "Exception launching new instance:", exception);
            }
            JOptionPane.showMessageDialog(null, Utils._("Cannot launch new program instance, continuing with the existing one!\nReason: ") + exception.toString());
            return null;
        }
    }

    public static PrintWriter getConsoleWriter() {
        if (consoleWriter == null) {
            try {
                Method method = System.class.getMethod("console", new Class[0]);
                Class<?> clazz = Class.forName("java.io.Console");
                Method method2 = clazz.getMethod("writer", new Class[0]);
                consoleWriter = (PrintWriter)method2.invoke(method.invoke(null, new Object[0]), new Object[0]);
                if (consoleWriter == null) {
                    consoleWriter = new PrintWriter(System.out, true);
                }
            }
            catch (Exception exception) {
                consoleWriter = new PrintWriter(System.out, true);
            }
        }
        return consoleWriter;
    }

    public static boolean isPropertyTrue(String string) {
        return Launcher2.isPropertyTrue(string, false);
    }

    public static boolean isPropertyTrue(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            if ("true".equals(string2) || "yes".equals(string2)) {
                return true;
            }
            if ("false".equals(string2) || "no".equals(string2)) {
                return false;
            }
            try {
                int n = Integer.parseInt(string2);
                return n != 0;
            }
            catch (NumberFormatException numberFormatException) {
                launchLog.log(Level.WARNING, "Error parsing " + string, numberFormatException);
                return bl;
            }
        }
        return bl;
    }

    static {
        jobIDWriter = null;
    }

    static class NewInstRunner
    implements Runnable {
        protected final String server;
        protected final boolean adminMode;
        protected final int selectedTab;
        protected final Runnable loginRunner;
        protected final int desiredWindowState;

        public void run() {
            YJSplashScreen yJSplashScreen;
            boolean bl = true;
            MainWin mainWin = new MainWin();
            application = mainWin;
            mainWin.initialize(this.adminMode, this.server);
            if (this.desiredWindowState != -1) {
                if (this.desiredWindowState >= 0) {
                    mainWin.setVisible(true);
                    mainWin.setExtendedState(this.desiredWindowState);
                } else if (this.desiredWindowState == -2) {
                    bl = !mainWin.hasTrayIcon();
                } else {
                    Logger.getLogger(NewInstRunner.class.getName()).warning("Unknown window state: " + this.desiredWindowState);
                }
            }
            mainWin.setVisible(bl);
            mainWin.reconnectToServer(this.loginRunner, true);
            if (this.selectedTab >= 0) {
                mainWin.setSelectedTab(this.selectedTab);
            }
            if ((yJSplashScreen = YJSplashScreen.getSplashScreen()) != null && yJSplashScreen.isVisible()) {
                try {
                    yJSplashScreen.close();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        public NewInstRunner(Runnable runnable, boolean bl, int n, int n2, String string) {
            this.loginRunner = runnable;
            this.adminMode = bl;
            this.selectedTab = n;
            this.desiredWindowState = n2;
            this.server = string;
        }
    }
}

