/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.launch;

import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yajhfc.launch.HelpPrinter;

public class ManPrinter
extends HelpPrinter {
    public String commandName = "yajhfc";
    public InputStream READMEstream = ManPrinter.class.getResourceAsStream("/README.txt");
    public String[] seeAlsoList = new String[]{"cyajhfc (1)", "hylafax (1)", "sendfax (1)", "java (1)"};
    public String[] docLocations = new String[]{"/usr/share/doc/yajhfc"};
    public String additionalSynopsis = "This command starts the graphical user interface. For a command line only interface, please see\n.B cyajhfc\n.";
    private static final Pattern minus = Pattern.compile("[\\-\\\\]");
    private static final String minusRepl = "\\\\$0";
    private static final Pattern bar = Pattern.compile("|", 16);
    private static final String barRepl = Matcher.quoteReplacement("\\fP|\\fI");
    private static final Pattern[] descPatterns = new Pattern[]{minus, Pattern.compile("(\\\\-\\\\-[a-zA-Z0-9\\-_]+)"), Pattern.compile("_(.+?)_")};
    private static final String[] descReplacements = new String[]{"\\\\$0", "\\\\fB$1\\\\fP", "\\\\fI$1\\\\fP"};

    protected void printManHeader(PrintWriter printWriter) throws Exception {
        String string;
        Date date = new Date();
        printWriter.append(".\\\" This man page has been auto-generated by YajHFC 0.6.1 (srfax v4) at " + date + "\n.TH YAJHFC 1 \"" + new SimpleDateFormat("MMMM d, yyyy").format(date) + "\" \"" + "YajHFC" + " " + "0.6.1 (srfax v4)" + "\"\n.SH NAME\n" + this.commandName + " \\- Yet Another Java HylaFAX Client\n.SH SYNOPSIS\n.B " + this.commandName + "\n.RI [ options ] \" [documents to send]\" ...\n.SH DESCRIPTION\nThis manual page documents the\n.B " + this.commandName + "\ncommand.\n.PP\n\\fBYajHFC\\fP is a client for the \\fBHylaFAX\\fP fax server written in Java.\n.sp 2\n\\fIFeatures:\\fP\n");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.READMEstream));
        while ((string = bufferedReader.readLine()) != null && !"Features:".equalsIgnoreCase(string.trim())) {
        }
        if (string == null) {
            throw new Exception("Error: \"Features:\" line not found in README.txt!");
        }
        while ((string = bufferedReader.readLine()) != null && (string = string.trim()).length() > 0) {
            if (string.startsWith("*")) {
                printWriter.append(".br\n");
            }
            printWriter.append(' ').append(ManPrinter.quoteMinus(string)).append('\n');
        }
        bufferedReader.close();
        if (this.additionalSynopsis != null) {
            printWriter.append(".sp 2\n");
            printWriter.append(this.additionalSynopsis);
            printWriter.append("\n");
        }
        printWriter.append(".SH OPTIONS\n");
    }

    private static final String quoteMinus(String string) {
        return minus.matcher(string).replaceAll(minusRepl);
    }

    private static final String quoteArgDesc(String string) {
        return bar.matcher(ManPrinter.quoteMinus(string)).replaceAll(barRepl);
    }

    private static final String quoteDescription(String string) {
        String string2 = string;
        for (int i = 0; i < descPatterns.length; ++i) {
            string2 = descPatterns[i].matcher(string2).replaceAll(descReplacements[i]);
        }
        return string2;
    }

    public void printManPage(PrintWriter printWriter, LongOpt[] longOptArray) throws Exception {
        longOptArray = this.filterOptions(longOptArray);
        this.printManHeader(printWriter);
        for (int i = 0; i < longOptArray.length; ++i) {
            LongOpt longOpt = longOptArray[i];
            printWriter.println(".TP");
            printWriter.print(".B ");
            if (longOpt.getVal() >= 48) {
                printWriter.append("\\-");
                printWriter.append((char)longOpt.getVal());
            }
            if (longOpt.getName() != null) {
                if (longOpt.getVal() < 48) {
                    printWriter.append("  \\-\\-");
                } else {
                    printWriter.append(", \\-\\-");
                }
                printWriter.append(ManPrinter.quoteMinus(longOpt.getName()));
                int n = longOpt.getHasArg();
                if (n != 0) {
                    printWriter.append("\\fP");
                    if (n == 2) {
                        printWriter.append('[');
                    }
                    printWriter.append("=\\fI");
                    printWriter.append(ManPrinter.quoteArgDesc(this.getArgDesc(longOpt)));
                    printWriter.append("\\fP");
                    if (n == 2) {
                        printWriter.append(']');
                    }
                }
            }
            printWriter.println();
            ManPrinter.printWrapped(printWriter, 0, ManPrinter.quoteDescription(this.getDescription(longOpt)), 80);
            printWriter.println();
        }
        printWriter.append(this.getManFooter());
        printWriter.flush();
    }

    public ManPrinter() {
    }

    public ManPrinter(String string) {
        super(string);
    }

    protected String getManFooter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".SH SEE ALSO\n");
        for (String string : this.seeAlsoList) {
            stringBuilder.append(".BR ").append(string).append(",\n");
        }
        stringBuilder.append(".br\nMore documentation is available in PDF and HTML format in the YajHFC FAQ and README files at\n");
        for (int i = 0; i < this.docLocations.length; ++i) {
            stringBuilder.append(".IR ").append(this.docLocations[i]);
            if (i < this.docLocations.length - 2) {
                stringBuilder.append(" ,");
            } else if (i == this.docLocations.length - 2) {
                stringBuilder.append("\nor");
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("and on the homepage at\n.IR http://www.yajhfc.de/\n.SH AUTHOR\nYajHFC was written by Jonas Wolz <jonas@yajhfc.de>.\n\n");
        return stringBuilder.toString();
    }
}

