/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.logconsole;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.SwingUtilities;

public class SwingLogHandler
extends Handler {
    protected final List<LogListener> listeners = new ArrayList<LogListener>();
    protected final Queue<LogRecord> recordBuffer = new LinkedList<LogRecord>();
    protected int bufferSize;

    public void addLogListenerAndPublishBuffer(LogListener logListener) {
        this.addLogListener(logListener);
        this.publishBufferTo(logListener);
    }

    public void addLogListener(LogListener logListener) {
        this.listeners.add(logListener);
    }

    public void removeLogListener(LogListener logListener) {
        this.listeners.remove(logListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBufferTo(LogListener logListener) {
        LogRecord[] logRecordArray = this.recordBuffer;
        synchronized (this.recordBuffer) {
            LogRecord[] logRecordArray2 = this.recordBuffer.toArray(new LogRecord[this.recordBuffer.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (LogRecord logRecord : logRecordArray2) {
                logListener.recordPublished(logRecord);
            }
            return;
        }
    }

    public void close() throws SecurityException {
    }

    public void flush() {
    }

    public void publish(final LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        this.bufferRecord(logRecord);
        if (this.listeners.size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (LogListener logListener : SwingLogHandler.this.listeners) {
                        logListener.recordPublished(logRecord);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bufferRecord(LogRecord logRecord) {
        Queue<LogRecord> queue = this.recordBuffer;
        synchronized (queue) {
            this.recordBuffer.offer(logRecord);
            while (this.recordBuffer.size() > this.bufferSize) {
                this.recordBuffer.poll();
            }
        }
    }

    public SwingLogHandler() {
        this(20);
    }

    public SwingLogHandler(int n) {
        this.bufferSize = n;
        this.setLevel(Level.INFO);
    }

    public static interface LogListener {
        public void recordPublished(LogRecord var1);
    }
}

