/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.macosx;

import java.awt.Image;
import java.awt.PopupMenu;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import yajhfc.PlatformInfo;
import yajhfc.launch.MainApplicationFrame;

public abstract class MacOSXSupport {
    private static MacOSXSupport instance;
    private static final String IMPL_CLASS_NAME = "yajhfc.macosx.MacOSXSupportImpl";

    public static MacOSXSupport getInstance() {
        if (!PlatformInfo.IS_MACOSX) {
            return null;
        }
        if (instance == null) {
            try {
                instance = (MacOSXSupport)Class.forName(IMPL_CLASS_NAME).newInstance();
            }
            catch (Exception exception) {
                instance = null;
                Logger.getLogger(MacOSXSupport.class.getName()).log(Level.WARNING, "Mac OS X support not available:", exception);
            }
        }
        return instance;
    }

    public static void setUIProperties() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "YajHFC");
    }

    public abstract void setApplicationMenuActions(MainApplicationFrame var1, Action var2, Action var3, Action var4);

    public abstract void setDockIconImage(Image var1);

    public abstract void setDockIconBadge(String var1);

    public abstract void setDockIconMenu(PopupMenu var1);

    public abstract PopupMenu getDockIconMenu();
}

