/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model;

import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import yajhfc.DateKind;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.VirtualColumnType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RecvFormat implements FmtItem
{
    Y("Y", Utils._("Time/Date"), Utils._("Extended representation of the time when the receive happened"), Utils.HYLA_LONG_DATE_FORMAT, DateKind.DATE_AND_TIME),
    a("a", Utils._("SubAddress"), Utils._("SubAddress received from sender (if any)")),
    b("b", Utils._("Speed"), Utils._("Signalling rate used during receive"), Integer.class),
    d("d", Utils._("Format"), Utils._("Data format used during receive")),
    e("e", Utils._("Error description"), Utils._("Error description if an error occurred during receive")),
    f("f", Utils._("Filename"), Utils._("Document filename (relative to the recvq directory)")),
    h("h", Utils._("Time to receive"), Utils._("Time spent receiving document (HH:MM:SS)"), Utils.HYLA_DURATION_FORMAT, DateKind.DURATION),
    i("i", Utils._("CIDName"), Utils._("CIDName value for received fax")),
    j("j", Utils._("CIDNumber"), Utils._("CIDNumber value for received fax")),
    l("l", Utils._("Page length"), Utils._("Page length in mm"), Integer.class),
    m("m", Utils._("Fax Protection"), Utils._("Fax-style protection mode string (``-rwxrwx'')")),
    n("n", Utils._("File size"), Utils._("File size (number of bytes)"), Integer.class),
    o("o", Utils._("Owner"), Utils._("File owner")),
    p("p", Utils._("Pages"), Utils._("Number of pages in document"), Integer.class),
    r("r", Utils._("Resolution"), Utils._("Resolution of received data"), Integer.class),
    s("s", Utils._("Sender"), Utils._("Sender identity (TSI)")),
    t("t", Utils._("Date"), Utils._("Compact representation of the time when the receive happened")),
    w("w", Utils._("Page width"), Utils._("Page width in mm"), Integer.class),
    z("z", Utils._("In progress"), Utils._("A ``*'' if receive is going on; otherwise `` '' (space)"), Boolean.class),
    Z("Z", Utils._("Time/Date (UNIX)"), Utils._("Time in seconds since the UNIX epoch"), Utils.HYLA_UNIX_DATE_FORMAT, DateKind.DATE_AND_TIME),
    virt_read(null, Utils._("Read"), Utils._("Has the fax been read by a YajHFC user?"), Boolean.class, null, null, false, VirtualColumnType.READ),
    virt_comment(null, Utils._("User comment"), Utils._("Comment added by a YajHFC user"), String.class, null, null, false, VirtualColumnType.USER_COMMENT);

    private final String description;
    private final String hylaFmt;
    private final String longDescription;
    private final Class<?> dataType;
    private final DateFormat hylaDateFormat;
    private final DateKind displayDateFormat;
    private final boolean readOnly;
    private final VirtualColumnType virtualColumnType;
    private static final RecvFormat[] requiredFormats;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getHylaFmt() {
        return this.hylaFmt;
    }

    @Override
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }

    @Override
    public DateFormat getHylaDateFormat() {
        return this.hylaDateFormat;
    }

    @Override
    public DateFormat getDisplayDateFormat() {
        if (this.displayDateFormat == null) {
            return null;
        }
        return DateKind.getInstanceFromKind(this.displayDateFormat);
    }

    @Override
    public Format getFormat() {
        if (this.dataType == Date.class) {
            return this.getDisplayDateFormat();
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public VirtualColumnType getVirtualColumnType() {
        return this.virtualColumnType;
    }

    private RecvFormat(String string2, String string3) {
        this(string2, string3, string3);
    }

    private RecvFormat(String string2, String string3, String string4) {
        this(string2, string3, string4, String.class, null, null);
    }

    private RecvFormat(String string2, String string3, String string4, DateFormat dateFormat, DateKind dateKind) {
        this(string2, string3, string4, Date.class, dateFormat, dateKind);
    }

    private RecvFormat(String string2, String string3, String string4, Class<?> clazz) {
        this(string2, string3, string4, clazz, null, null);
    }

    private RecvFormat(String string2, String string3, Class<?> clazz) {
        this(string2, string3, string3, clazz, null, null);
    }

    private RecvFormat(String string2, String string3, String string4, Class<?> clazz, DateFormat dateFormat, DateKind dateKind) {
        this(string2, string3, string4, clazz, dateFormat, dateKind, true, VirtualColumnType.NONE);
    }

    private RecvFormat(String string2, String string3, String string4, Class<?> clazz, DateFormat dateFormat, DateKind dateKind, boolean bl, VirtualColumnType virtualColumnType) {
        this.hylaFmt = string2;
        this.description = string3;
        this.longDescription = string4;
        this.dataType = clazz;
        this.hylaDateFormat = dateFormat;
        this.displayDateFormat = dateKind;
        this.readOnly = bl;
        this.virtualColumnType = virtualColumnType;
    }

    public static RecvFormat[] getRequiredFormats() {
        return requiredFormats;
    }

    static {
        requiredFormats = new RecvFormat[]{f, o, z, e, virt_comment, virt_read};
    }
}

