/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.jobq;

import gnu.inet.ftp.FtpClient;
import gnu.inet.ftp.ServerResponseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yajhfc.Utils;
import yajhfc.model.jobq.FileHylaDirAccessor;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.shutdown.ShutdownManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPHylaDirAccessor
implements HylaDirAccessor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final Logger log = Logger.getLogger(FileHylaDirAccessor.class.getName());
    public final String server;
    public final int port;
    public final String user;
    public final String pass;
    public final String baseDir;
    public final boolean pasv;
    protected long maxCacheAge = 5000L;
    protected long cacheTime = -1L;
    protected Map<String, FTPFile> fileCache = new TreeMap<String, FTPFile>();
    protected Pattern ftpFileListPattern = Pattern.compile("([a-z-]+)\\s+\\d+\\s+(\\w+)\\s+\\w+\\s+(\\d+)\\s+(?:([A-Za-z]+\\s+\\d+\\s+\\d+:\\d+)|([A-Za-z]+\\s+\\d+\\s+\\d+))\\s+(.+)$");
    private static final int GROUP_MODE = 1;
    private static final int GROUP_OWNER = 2;
    private static final int GROUP_SIZE = 3;
    private static final int GROUP_DATE_TIME = 4;
    private static final int GROUP_DATE_ONLY = 5;
    private static final int GROUP_FILENAME = 6;
    protected DateFormat ftpFileListDateFormat = new SimpleDateFormat("MMM dd HH:mm", Locale.US);
    protected DateFormat ftpFileListDateOnlyFormat = new SimpleDateFormat("MMM dd yyyy", Locale.US);
    protected long logoutTimeout = 30000L;
    protected FtpClient ftpClient;
    protected long lastActionTime;
    protected ScheduledFuture<?> logoutChecker;

    public FTPHylaDirAccessor(String string, int n, String string2, String string3, String string4, boolean bl) {
        this.server = string;
        this.port = n;
        this.user = string2;
        this.pass = string3;
        this.baseDir = string4;
        this.pasv = bl;
    }

    private void initializeLogoutChecker() {
        if (this.logoutChecker != null) {
            this.logoutChecker = Utils.executorService.scheduleWithFixedDelay(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (FTPHylaDirAccessor.this.ftpClient != null) {
                        FTPHylaDirAccessor fTPHylaDirAccessor = FTPHylaDirAccessor.this;
                        synchronized (fTPHylaDirAccessor) {
                            if (System.currentTimeMillis() - FTPHylaDirAccessor.this.lastActionTime > FTPHylaDirAccessor.this.logoutTimeout) {
                                log.fine("Closing FTP connection...");
                                try {
                                    FTPHylaDirAccessor.this.ftpClient.quit();
                                }
                                catch (Exception exception) {
                                    log.log(Level.WARNING, "Error closing FTP connection", exception);
                                }
                                FTPHylaDirAccessor.this.ftpClient = null;
                                FTPHylaDirAccessor.this.logoutChecker.cancel(false);
                                FTPHylaDirAccessor.this.logoutChecker = null;
                            }
                        }
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    protected synchronized FtpClient getFtpClient() throws UnknownHostException, IOException, ServerResponseException {
        if (this.ftpClient == null) {
            this.ftpClient = new FtpClient();
            this.ftpClient.open(this.server, this.port);
            if (this.ftpClient.user(this.user)) {
                this.ftpClient.pass(this.pass);
            }
            this.ftpClient.cwd(this.baseDir);
            this.ftpClient.setPassive(this.pasv);
            this.initializeLogoutChecker();
            this.lastActionTime = System.currentTimeMillis();
        }
        return this.ftpClient;
    }

    protected synchronized FTPFile getFtpFile(String string) throws IOException {
        FTPFile fTPFile = this.getFileList().get(string);
        if (fTPFile == null) {
            throw new FileNotFoundException(string + " does not exist.");
        }
        return fTPFile;
    }

    protected synchronized Map<String, FTPFile> getFileList() throws IOException {
        if (System.currentTimeMillis() - this.cacheTime < this.maxCacheAge) {
            log.fine("Using cached file list...");
            return this.fileCache;
        }
        log.fine("Refreshing file list");
        try {
            FtpClient ftpClient = this.getFtpClient();
            Vector vector = ftpClient.getList();
            this.fileCache.clear();
            Date date = new Date(0L);
            for (Object e : vector) {
                boolean bl;
                int n;
                Matcher matcher;
                String string = (String)e;
                if (Utils.debugMode) {
                    log.fine("Parsing listing line " + string);
                }
                if (!(matcher = this.ftpFileListPattern.matcher(string)).matches()) {
                    log.warning("\"" + string + "\" does not match the expected pattern, ignoring it. Pattern=" + this.ftpFileListPattern);
                    continue;
                }
                String string2 = matcher.group(6);
                Date date2 = date;
                if (matcher.group(4) != null) {
                    try {
                        date2 = this.ftpFileListDateFormat.parse(matcher.group(4));
                    }
                    catch (Exception exception) {
                        log.log(Level.WARNING, "Unparseable file date for \"" + string + "\": " + matcher.group(4), exception);
                    }
                } else if (matcher.group(5) != null) {
                    try {
                        date2 = this.ftpFileListDateOnlyFormat.parse(matcher.group(5));
                    }
                    catch (Exception exception) {
                        log.log(Level.WARNING, "Unparseable file date for \"" + string + "\": " + matcher.group(5), exception);
                    }
                }
                long l = -1L;
                try {
                    l = Long.parseLong(matcher.group(3));
                }
                catch (Exception exception) {
                    log.warning("Unparseable file size for \"" + string + "\": " + matcher.group(3));
                }
                String string3 = matcher.group(1);
                if (string3.length() >= 10) {
                    n = FTPHylaDirAccessor.modeToInt(string3, 1) * 64 | FTPHylaDirAccessor.modeToInt(string3, 4) * 8 | FTPHylaDirAccessor.modeToInt(string3, 7);
                    bl = string3.charAt(0) == 'd';
                } else {
                    n = 0;
                    bl = false;
                }
                String string4 = matcher.group(2);
                this.fileCache.put(string2, new FTPFile(string2, bl, n, l, date2, string4));
            }
            this.cacheTime = System.currentTimeMillis();
            return this.fileCache;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public synchronized String[] listDirectory() throws IOException {
        return this.getFileList().keySet().toArray(EMPTY_STRING_ARRAY);
    }

    @Override
    public synchronized String[] listDirectory(String string) throws IOException {
        try {
            FtpClient ftpClient = this.getFtpClient();
            Vector vector = ftpClient.getNameList(string);
            String[] stringArray = vector.toArray(EMPTY_STRING_ARRAY);
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].lastIndexOf(47);
                if (n < 0) continue;
                stringArray[i] = stringArray[i].substring(n + 1);
            }
            return stringArray;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public Reader getInputReader(String string) throws IOException {
        return new FileReader(this.getFtpFile(string).getTempFile());
    }

    @Override
    public synchronized void copyFile(String string, OutputStream outputStream) throws IOException {
        try {
            FtpClient ftpClient = this.getFtpClient();
            ftpClient.get(string, outputStream);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public File getFile(String string) throws IOException {
        return this.getFtpFile(string).getTempFile();
    }

    @Override
    public void deleteFile(String string) throws IOException {
        try {
            FtpClient ftpClient = this.getFtpClient();
            ftpClient.dele(string);
            this.invalidateCache();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public void invalidateCache() {
        this.cacheTime = -1L;
    }

    @Override
    public void deleteTree(String string) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public long getLastModified() throws IOException {
        this.getFileList();
        return this.cacheTime;
    }

    @Override
    public long getLastModified(String string) throws IOException {
        return this.getFtpFile((String)string).modificationTime;
    }

    @Override
    public long getSize(String string) throws IOException {
        return this.getFtpFile((String)string).size;
    }

    @Override
    public int getProtection(String string) throws IOException {
        return this.getFtpFile((String)string).mode;
    }

    public String getOwner(String string) throws IOException {
        return this.getFtpFile((String)string).owner;
    }

    @Override
    public String getBasePath() {
        return this.baseDir;
    }

    protected static int modeToInt(String string, int n) {
        return (string.charAt(n) == 'r' ? 4 : 0) | (string.charAt(n + 1) == 'w' ? 2 : 0) | (string.charAt(n + 2) == 'x' ? 1 : 0);
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public Pattern getFtpFileListPattern() {
        return this.ftpFileListPattern;
    }

    public DateFormat getFtpFileListDateFormat() {
        return this.ftpFileListDateFormat;
    }

    public void setMaxCacheAge(long l) {
        this.maxCacheAge = l;
    }

    public void setFtpFileListPattern(Pattern pattern) {
        this.ftpFileListPattern = pattern;
    }

    public void setFtpFileListDateFormat(DateFormat dateFormat) {
        this.ftpFileListDateFormat = dateFormat;
    }

    public long getLogoutTimeout() {
        return this.logoutTimeout;
    }

    public void setLogoutTimeout(long l) {
        this.logoutTimeout = l;
    }

    protected class FTPFile {
        public final String name;
        public final int mode;
        public final long size;
        public final long modificationTime;
        public final boolean isDirectory;
        public final String owner;
        protected File tempFile;

        public FTPFile(String string, boolean bl, int n, long l, Date date, String string2) {
            this.name = string;
            this.isDirectory = bl;
            this.mode = n;
            this.size = l;
            this.modificationTime = date.getTime();
            this.owner = string2;
            if (Utils.debugMode) {
                log.finer("new FTPFile: " + this);
            }
        }

        public synchronized File getTempFile() throws IOException {
            if (this.tempFile == null) {
                this.tempFile = File.createTempFile("ftp", this.name.length() > 4 ? this.name.substring(this.name.length() - 4) : null);
                ShutdownManager.deleteOnExit(this.tempFile);
                FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);
                FTPHylaDirAccessor.this.copyFile(this.name, fileOutputStream);
                fileOutputStream.close();
            }
            return this.tempFile;
        }

        public String toString() {
            return this.name + " (mode=" + Integer.toOctalString(this.mode) + "; size=" + this.size + "; owner=" + this.owner + "; modificationTime=" + new Date(this.modificationTime) + "; isDirectory=" + this.isDirectory + "; tempFile=" + this.tempFile + ")";
        }
    }
}

