/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.jobq;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.server.ServerOptions;

public class FileHylaDirAccessor
implements HylaDirAccessor {
    static final Logger log = Logger.getLogger(FileHylaDirAccessor.class.getName());
    protected File baseDir;
    protected Map<String, SoftReference<File>> fileCache = new HashMap<String, SoftReference<File>>();
    protected String encoding;

    public FileHylaDirAccessor(File file, ServerOptions serverOptions) {
        if (Utils.debugMode) {
            log.fine("Created new dir accessor for " + file);
        }
        this.baseDir = file;
        this.encoding = serverOptions.hylaFAXCharacterEncoding;
    }

    public void deleteFile(String string) {
        if (Utils.debugMode) {
            log.fine("Delete " + string);
        }
        this.getFile(string).delete();
    }

    public File getFile(String string) {
        SoftReference<File> softReference = this.fileCache.get(string);
        File file = softReference != null ? softReference.get() : null;
        if (file == null) {
            file = new File(this.baseDir, string);
            this.fileCache.put(string, new SoftReference<File>(file));
        }
        return file;
    }

    public String[] listDirectory() throws IOException {
        if (Utils.debugMode) {
            log.fine("List base dir");
        }
        return this.baseDir.list();
    }

    public String[] listDirectory(String string) {
        if (Utils.debugMode) {
            log.fine("List directory " + string);
        }
        return this.getFile(string).list();
    }

    public void deleteTree(String string) throws IOException {
        if (Utils.debugMode) {
            log.fine("Delete tree " + string);
        }
        this.delTree(this.getFile(string));
    }

    private void delTree(File file) throws IOException {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.delTree(file2);
            }
        }
        if (!file.delete()) {
            throw new IOException("Could not delete the file " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(String string, OutputStream outputStream) throws IOException {
        if (Utils.debugMode) {
            log.fine("Copy file " + string);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getFile(string));
            Utils.copyStream(fileInputStream, outputStream);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Reader getInputReader(String string) throws IOException {
        if (Utils.debugMode) {
            log.fine("Get input reader " + string);
        }
        return new InputStreamReader((InputStream)new FileInputStream(this.getFile(string)), this.encoding);
    }

    public long getLastModified() throws IOException {
        if (Utils.debugMode) {
            log.fine("Get base dir last modified ");
        }
        return this.baseDir.lastModified();
    }

    public long getLastModified(String string) throws IOException {
        if (Utils.debugMode) {
            log.fine("Get last modified " + string);
        }
        return this.getFile(string).lastModified();
    }

    public long getSize(String string) throws IOException {
        if (Utils.debugMode) {
            log.fine("Get size " + string);
        }
        return this.getFile(string).length();
    }

    public int getProtection(String string) throws IOException {
        if (Utils.debugMode) {
            log.fine("Get protection " + string);
        }
        File file = this.getFile(string);
        int n = 0;
        if (file.canRead()) {
            n |= 0x124;
        }
        if (file.canWrite()) {
            n |= 0x92;
        }
        return n;
    }

    public String getBasePath() {
        return this.baseDir.getPath();
    }
}

