/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.defimpl;

import gnu.inet.ftp.ServerResponseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.file.FormattedFile;
import yajhfc.model.FmtItem;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.hylafax.HylaServerDoc;
import yajhfc.shutdown.ShutdownManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaxDocument<T extends FmtItem>
implements FaxDocument,
Serializable {
    protected static final Logger log = Logger.getLogger(HylaServerDoc.class.getName());
    protected final String path;
    protected FaxJob<T> parent;
    protected FileFormat type;
    protected transient FormattedFile localDocument = null;

    public String getDefaultExtension() {
        if (this.type == FileFormat.Unknown) {
            int n = this.path.lastIndexOf(46);
            if (n < 0) {
                return "tmp";
            }
            return this.path.substring(n + 1);
        }
        return this.type.getDefaultExtension();
    }

    @Override
    public void downloadToStream(OutputStream outputStream) throws IOException, ServerResponseException {
        if (this.localDocument == null) {
            log.fine("Using direct download from server");
            this.downloadFromServer(outputStream);
        } else {
            log.fine("Reading file from local copy");
            FileInputStream fileInputStream = new FileInputStream(this.localDocument.file);
            Utils.copyStream(fileInputStream, outputStream);
            fileInputStream.close();
        }
    }

    @Override
    public FormattedFile getDocument() throws IOException, ServerResponseException {
        if (this.localDocument == null) {
            File file = File.createTempFile("fax", "." + this.getDefaultExtension());
            ShutdownManager.deleteOnExit(file);
            log.fine("Copying " + this.path + " into " + file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.downloadFromServer(fileOutputStream);
            fileOutputStream.close();
            if (this.type == FileFormat.Unknown) {
                this.type = FormattedFile.detectFileFormat(file);
            }
            this.localDocument = new FormattedFile(file, this.type);
            log.fine("Downloaded " + this.path + " into local file " + file + " of type " + (Object)((Object)this.type));
        }
        return this.localDocument;
    }

    protected abstract void downloadFromServer(OutputStream var1) throws IOException, ServerResponseException;

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getHylafaxPath() {
        return null;
    }

    @Override
    public FileFormat getType() {
        return this.type;
    }

    public String toString() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    protected AbstractFaxDocument(FaxJob<T> faxJob, String string, FileFormat fileFormat) {
        this.path = string;
        this.parent = faxJob;
        this.type = fileFormat;
    }
}

