/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.directaccess;

import gnu.hylafax.HylaFAXClient;
import gnu.inet.ftp.ServerResponseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.FmtItemList;
import yajhfc.model.jobq.HylaDirAccessor;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.FaxListConnection;
import yajhfc.model.servconn.defimpl.AbstractFaxJobList;
import yajhfc.model.servconn.defimpl.JobIDComparator;
import yajhfc.model.servconn.directaccess.DirectAccessFaxJob;
import yajhfc.model.servconn.directaccess.DirectAccessFaxListConnection;
import yajhfc.model.servconn.hylafax.ManagedFaxJobList;
import yajhfc.server.ServerOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectAccessFaxJobList<T extends FmtItem>
extends AbstractFaxJobList<T>
implements ManagedFaxJobList<T> {
    static final Logger log = Logger.getLogger(DirectAccessFaxJobList.class.getName());
    protected long lastDirectoryModification = -1L;
    protected final String directory;

    public DirectAccessFaxJobList(FaxListConnection faxListConnection, FmtItemList<T> fmtItemList, ServerOptions serverOptions, String string) {
        super(fmtItemList, faxListConnection);
        this.directory = string;
        this.reloadSettings(serverOptions);
    }

    @Override
    public boolean isShowingErrorsSupported() {
        return true;
    }

    @Override
    public void disconnectCleanup() {
        this.setJobs(Collections.emptyList());
        this.lastDirectoryModification = -1L;
    }

    @Override
    public void pollForNewJobs(HylaFAXClient hylaFAXClient) throws IOException, ServerResponseException {
        this.pollForNewJobs();
    }

    public void pollForNewJobs() throws IOException {
        long l = this.getDirAccessor().getLastModified();
        if (Utils.debugMode) {
            log.fine(this.directory + ": poll for changes: lastDirectoryModification=" + this.lastDirectoryModification + "; modificationTime=" + l);
        }
        if (this.lastDirectoryModification == -1L || this.lastDirectoryModification != l) {
            this.setJobs(this.updateQueueFiles());
            this.lastDirectoryModification = l;
        } else {
            log.fine("Directory unchanged; polling individual jobs for changes");
            boolean bl = false;
            for (FaxJob faxJob : this.jobs) {
                bl |= ((DirectAccessFaxJob)faxJob).pollForChanges();
            }
            if (bl) {
                this.fireFaxJobsUpdated(this.jobs, this.jobs);
            }
        }
    }

    protected abstract DirectAccessFaxJob<T> createJob(String var1) throws IOException;

    protected abstract String[] translateDirectoryEntries(String[] var1);

    public List<FaxJob<T>> updateQueueFiles() throws IOException {
        Object[] objectArray;
        Object[] objectArray2 = this.directory == null ? this.getDirAccessor().listDirectory() : this.getDirAccessor().listDirectory(this.directory);
        if (Utils.debugMode) {
            log.finer(this.directory + " entries: " + Arrays.toString(objectArray2));
        }
        if ((objectArray = this.translateDirectoryEntries((String[])objectArray2)) == null || objectArray.length == 0) {
            log.fine("Directory is empty");
            return Collections.emptyList();
        }
        if (Utils.debugMode) {
            log.finer(this.directory + " new jobIDs=" + Arrays.toString(objectArray) + "; old jobs=" + this.jobs);
            log.finer(this.directory + " columns are: " + this.columns.getCompleteView());
        }
        ArrayList<FaxJob<T>> arrayList = new ArrayList<FaxJob<T>>(objectArray.length);
        if (this.jobs.size() == 0) {
            log.fine("No old jobs");
            for (Object object : objectArray) {
                try {
                    arrayList.add(this.createJob((String)object));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    log.log(Level.INFO, "Could not add " + this.directory + " file:", fileNotFoundException);
                }
            }
        } else {
            log.fine("Comparing old job list with new");
            DirectAccessFaxJob[] directAccessFaxJobArray = new DirectAccessFaxJob[this.jobs.size()];
            directAccessFaxJobArray = this.jobs.toArray(directAccessFaxJobArray);
            Arrays.sort(objectArray);
            Arrays.sort(directAccessFaxJobArray, JobIDComparator.INSTANCE);
            int n = 0;
            int n2 = 0;
            while (n < objectArray.length && n2 < directAccessFaxJobArray.length) {
                try {
                    Object object = objectArray[n];
                    DirectAccessFaxJob directAccessFaxJob = directAccessFaxJobArray[n2];
                    String string = directAccessFaxJob.jobID;
                    int n3 = ((String)object).compareTo(string);
                    if (n3 == 0) {
                        ++n;
                        ++n2;
                        directAccessFaxJob.pollForChanges();
                        arrayList.add(directAccessFaxJob);
                        continue;
                    }
                    if (n3 < 0) {
                        ++n;
                        arrayList.add(this.createJob((String)object));
                        continue;
                    }
                    ++n2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    log.log(Level.INFO, "Could not add " + this.directory + " file:", fileNotFoundException);
                }
            }
            while (n < objectArray.length) {
                try {
                    arrayList.add(this.createJob((String)objectArray[n]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    log.log(Level.INFO, "Could not add " + this.directory + " file:", fileNotFoundException);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public HylaDirAccessor getDirAccessor() {
        return ((DirectAccessFaxListConnection)this.parent).getDirAccessor();
    }
}

